/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.bo.PebDealOrderBO;
import com.tydic.order.ability.order.PebOrderApprovalAbilityService;
import com.tydic.order.bo.common.UocGeneralCirculationReqBO;
import com.tydic.order.bo.order.PebOrderApprovalReqBO;
import com.tydic.order.bo.order.PebOrderApprovalRspBO;
import com.tydic.order.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.busi.order.PebOrderApprovalBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebOrderApprovalAbilityService.class)
public class PebOrderApprovalAbilityServiceImpl
implements PebOrderApprovalAbilityService {
    @Autowired
    private PebOrderApprovalBusiService pebOrderApprovalBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Resource(name="dealZoneDealAutomaticTaskMsgProvider")
    private ProxyMessageProducer dealZoneDealAutomaticTaskMsgProvider;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TOPIC}")
    private String taskTopic;
    @Value(value="${UOC_ZONE_DEAL_AUTO_TASK_TAG}")
    private String taskTag;

    public PebOrderApprovalRspBO dealPebOrderApproval(PebOrderApprovalReqBO reqBO) {
        PebOrderApprovalRspBO rspBO;
        this.validateParams(reqBO);
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        if (!"0000".equals((rspBO = this.pebOrderApprovalBusiService.dealPebOrderApproval(reqBO)).getRespCode())) {
            return rspBO;
        }
        for (PebDealOrderBO pebDealOrderBO : rspBO.getOrderApprovalList()) {
            if (!pebDealOrderBO.getAuto().booleanValue()) continue;
            UocGeneralCirculationReqBO circulationReqBO = new UocGeneralCirculationReqBO();
            circulationReqBO.setActionCode("ACTPEB019");
            circulationReqBO.setObjId(pebDealOrderBO.getSaleVoucherId());
            circulationReqBO.setOrderId(pebDealOrderBO.getOrderId());
            circulationReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            this.dealZoneDealAutomaticTaskMsgProvider.send(new ProxyMessage(this.taskTopic, this.taskTag, JSONObject.toJSONString((Object)circulationReqBO)));
        }
        for (PebDealOrderBO pebDealOrderBO : reqBO.getOrderApprovalList()) {
            this.idxSync(pebDealOrderBO);
        }
        return rspBO;
    }

    private void idxSync(PebDealOrderBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void validateParams(PebOrderApprovalReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279API\u5165\u53c2\u3010bo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getActionCode() == null) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279\u52a8\u4f5c\u7f16\u7801\u3010actionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getActionCode().equals("ACTPEB007") && !reqBO.getActionCode().equals("ACTPEB008")) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279\u52a8\u4f5c\u7f16\u7801\u3010actionCode\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (reqBO.getAuditResult() == null) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.PASS) && !reqBO.getAuditResult().equals(UocConstant.ACTION_RESULT.NO_PASS)) {
            throw new UocProBusinessException("0002", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u7ed3\u679c\u3010auditResult\u3011\u7c7b\u578b\u9519\u8bef");
        }
        if (reqBO.getOrderApprovalList() == null || reqBO.getOrderApprovalList().size() == 0) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u8ba2\u5355\u5bf9\u8c61\u3010orderApprovalList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperId() == null) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279\u5ba1\u6279\u7528\u6237id\u3010operId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperName() == null) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u5ba1\u6279\u7528\u6237\u540d\u79f0\u3010operName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

