/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.order.UocInvoiceNoticeAbilityService;
import com.tydic.order.bo.order.UocInvoiceNoticeReqBO;
import com.tydic.order.bo.order.UocInvoiceNoticeRspBO;
import com.tydic.order.bo.order.UocOrderBO;
import com.tydic.order.busi.order.UocInvoiceNoticeBusiService;
import com.tydic.order.comb.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.constant.UocConstant;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocInvoiceNoticeAbilityService.class)
public class UocInvoiceNoticeAbilityServiceImpl
implements UocInvoiceNoticeAbilityService {
    @Autowired
    private UocInvoiceNoticeBusiService uocInvoiceNoticeBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public UocInvoiceNoticeRspBO dealInvoiceNotice(UocInvoiceNoticeReqBO reqBO) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (UocOrderBO uocOrderBO : reqBO.getOrderInfo()) {
            UocInvoiceNoticeReqBO noticeReqBO = new UocInvoiceNoticeReqBO();
            BeanUtils.copyProperties((Object)uocOrderBO, (Object)noticeReqBO);
            UocInvoiceNoticeRspBO rspBO = this.uocInvoiceNoticeBusiService.dealInvoiceNotice(noticeReqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
                syncReqBO.setOrderId(uocOrderBO.getOrderId());
                syncReqBO.setObjId(uocOrderBO.getSaleVoucherId());
                syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
                continue;
            }
            list.add(uocOrderBO.getOrderId());
        }
        UocInvoiceNoticeRspBO rspBO = new UocInvoiceNoticeRspBO();
        if (CollectionUtils.isNotEmpty(list)) {
            rspBO.setFailedOrder(list);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

