/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.order.UocPebOrdIdxSyncAbilityService;
import com.tydic.order.comb.order.UocPebOrdIdxSyncCombService;
import com.tydic.order.comb.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.comb.order.bo.UocPebOrdIdxSyncRspBO;
import com.tydic.order.constant.PecConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.impl.ability.order.UocPebOrdIdxSyncThreadsImpl;
import com.tydic.order.impl.es.UocEsSyncAbnormalListBusiService;
import com.tydic.order.impl.es.UocEsSyncAfsListBusiService;
import com.tydic.order.impl.es.UocEsSyncInspectionListBusiService;
import com.tydic.order.impl.es.UocEsSyncOrderListBusiService;
import com.tydic.order.impl.es.bo.UocEsSyncAbnormalListRspBO;
import com.tydic.order.impl.es.bo.UocEsSyncAfsListRspBO;
import com.tydic.order.impl.es.bo.UocEsSyncInspectionListRspBO;
import com.tydic.order.impl.es.bo.UocEsSyncOrderListRspBO;
import com.tydic.order.uoc.dao.OrdAbnormalMapper;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdInspectionMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdAbnormalPO;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdInspectionPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocPebOrdIdxSyncAbilityService.class)
public class UocPebOrdIdxSyncAbilityServiceImpl
implements UocPebOrdIdxSyncAbilityService {
    private static final Logger logger = LoggerFactory.getLogger(UocPebOrdIdxSyncAbilityServiceImpl.class);
    @Autowired
    private UocPebOrdIdxSyncCombService uocPebOrdIdxSyncCombService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private UocEsSyncOrderListBusiService esSyncOrderListBusiService;
    @Autowired
    private UocEsSyncAfsListBusiService esSyncAfsListBusiService;
    @Autowired
    private UocEsSyncAbnormalListBusiService esSyncAbnormalListBusiService;
    @Autowired
    private UocEsSyncInspectionListBusiService esSyncInspectionListBusiService;

    public UocPebOrdIdxSyncRspBO dealOrdIdxSync(UocPebOrdIdxSyncReqBO reqBO) {
        UocPebOrdIdxSyncRspBO rspBO = new UocPebOrdIdxSyncRspBO();
        this.validateParam(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getIsAll().booleanValue()) {
            if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
                this.batchDealOrder(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
                this.batchDealAfterService(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.ABNORMAL.equals(reqBO.getObjType())) {
                this.batchDealAbnormal(reqBO, rspBO);
            } else if (UocCoreConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
                this.batchDealInspection(reqBO, rspBO);
            }
        } else {
            UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
            combReqBO.setOrderId(reqBO.getOrderId());
            combReqBO.setObjId(reqBO.getObjId());
            combReqBO.setObjType(reqBO.getObjType());
            if (reqBO.getIsMQ().booleanValue()) {
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
            } else {
                this.dealEsIdxSync(combReqBO);
            }
        }
        return rspBO;
    }

    private void validateParam(UocPebOrdIdxSyncReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("7777", "\u7d22\u5f15\u540c\u6b65API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("7777", "\u7d22\u5f15\u540c\u6b65API\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealEsIdxSync(UocPebOrdIdxSyncReqBO combReqBO) {
        UocPebOrdIdxSyncRspBO combRspBO = this.uocPebOrdIdxSyncCombService.dealOrdIdxSync(combReqBO);
        if ("0000".equals(combRspBO.getRespCode())) {
            UocEsSyncInspectionListRspBO esSyncInspectionListRspBO;
            if (UocConstant.OBJ_TYPE.SALE.equals(combReqBO.getObjType())) {
                UocEsSyncOrderListRspBO esSyncOrderListRspBO = this.esSyncOrderListBusiService.esSyncOrderList(combRspBO.getOrdPurIdxBusiReqBO());
                if (!"0000".equals(esSyncOrderListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncOrderListRspBO.getRespCode(), esSyncOrderListRspBO.getRespDesc());
                }
            } else if (PecConstant.OBJ_TYPE.AFTER_SERVICE.equals(combReqBO.getObjType())) {
                UocEsSyncAfsListRspBO esSyncAfsListRspBO = this.esSyncAfsListBusiService.esSyncAfsList(combRspBO.getOperateOrdAsPurIdxBusiReqBO());
                if (!"0000".equals(esSyncAfsListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncAfsListRspBO.getRespCode(), esSyncAfsListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.ABNORMAL.equals(combReqBO.getObjType())) {
                UocEsSyncAbnormalListRspBO esSyncAbnormalListRspBO = this.esSyncAbnormalListBusiService.esUocEsSyncAbnormalList(combRspBO.getOperateAbnormalPurIdxReqBO());
                if (!"0000".equals(esSyncAbnormalListRspBO.getRespCode())) {
                    throw new UocProBusinessException(esSyncAbnormalListRspBO.getRespCode(), esSyncAbnormalListRspBO.getRespDesc());
                }
            } else if (UocConstant.OBJ_TYPE.INSPECTION.equals(combReqBO.getObjType()) && !"0000".equals((esSyncInspectionListRspBO = this.esSyncInspectionListBusiService.esSyncInspection(combRspBO.getOperateInspectionPurIdxReqBO())).getRespCode())) {
                throw new UocProBusinessException(esSyncInspectionListRspBO.getRespCode(), esSyncInspectionListRspBO.getRespDesc());
            }
        } else {
            throw new UocProBusinessException(combRspBO.getRespCode(), combRspBO.getRespDesc());
        }
    }

    private void batchDealOrder(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrderPO orderPO = new OrderPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            orderPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            orderPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        orderPO.setOrderBy("t.CREATE_TIME DESC");
        List listByCreateTime = this.orderMapper.getListByCreateTime(orderPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<UocPebOrdIdxSyncReqBO> combReqBOList = new ArrayList<UocPebOrdIdxSyncReqBO>();
                for (OrderPO po : listByCreateTime) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(po.getOrderId());
                    combReqBO.setObjId(po.getUpperOrderId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                    combReqBOList.add(combReqBO);
                }
                try {
                    UocPebOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new UocPebOrdIdxSyncThreadsImpl();
                    List<UocPebOrdIdxSyncReqBO> failureCombReqBO = ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum());
                    if (CollectionUtils.isNotEmpty(failureCombReqBO)) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("ES\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a" + failureCombReqBO.size() + "\uff0c\u5c11\u4fa0\u5931\u8d25\u6570\u636e\u8bf7\u770b\u65e5\u5fd7\u3002");
                        logger.info("---ES\u540c\u6b65\u5931\u8d25\u6570\u636e---" + JSON.toJSONString(failureCombReqBO));
                    }
                    ordIdxSyncThreadsAbilityService.releaseObject();
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrderPO po : listByCreateTime) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(po.getOrderId());
                    combReqBO.setObjId(po.getUpperOrderId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealAfterService(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            ordAfterServicePO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            ordAfterServicePO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        ordAfterServicePO.setOrderBy("t.CREATE_TIME DESC");
        List listByCreateTime = this.ordAfterServiceMapper.getListByCreateTime(ordAfterServicePO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<UocPebOrdIdxSyncReqBO> combReqBOList = new ArrayList<UocPebOrdIdxSyncReqBO>();
                for (OrdAfterServicePO afterServicePO : listByCreateTime) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(afterServicePO.getOrderId());
                    combReqBO.setObjId(afterServicePO.getAfterServId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
                    combReqBOList.add(combReqBO);
                }
                try {
                    UocPebOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new UocPebOrdIdxSyncThreadsImpl();
                    List<UocPebOrdIdxSyncReqBO> failureCombReqBO = ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum());
                    if (CollectionUtils.isNotEmpty(failureCombReqBO)) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("ES\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a" + failureCombReqBO.size() + "\uff0c\u5c11\u4fa0\u5931\u8d25\u6570\u636e\u8bf7\u770b\u65e5\u5fd7\u3002");
                        logger.info("---ES\u540c\u6b65\u5931\u8d25\u6570\u636e---" + JSON.toJSONString(failureCombReqBO));
                    }
                    ordIdxSyncThreadsAbilityService.releaseObject();
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdAfterServicePO afterServicePO : listByCreateTime) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(afterServicePO.getOrderId());
                    combReqBO.setObjId(afterServicePO.getAfterServId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealAbnormal(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdAbnormalPO abnormalPO = new OrdAbnormalPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            abnormalPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            abnormalPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        abnormalPO.setOrderBy("CREATE_TIME DESC");
        List ordAbnormalPOS = this.ordAbnormalMapper.getList(abnormalPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + ordAbnormalPOS.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)ordAbnormalPOS)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<UocPebOrdIdxSyncReqBO> combReqBOList = new ArrayList<UocPebOrdIdxSyncReqBO>();
                for (OrdAbnormalPO ordAbnormalPO : ordAbnormalPOS) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordAbnormalPO.getOrderId());
                    combReqBO.setObjId(ordAbnormalPO.getAbnormalVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ABNORMAL);
                    combReqBOList.add(combReqBO);
                }
                try {
                    UocPebOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new UocPebOrdIdxSyncThreadsImpl();
                    List<UocPebOrdIdxSyncReqBO> failureCombReqBO = ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum());
                    if (CollectionUtils.isNotEmpty(failureCombReqBO)) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("ES\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a" + failureCombReqBO.size() + "\uff0c\u5c11\u4fa0\u5931\u8d25\u6570\u636e\u8bf7\u770b\u65e5\u5fd7\u3002");
                        logger.info("---ES\u540c\u6b65\u5931\u8d25\u6570\u636e---" + JSON.toJSONString(failureCombReqBO));
                    }
                    ordIdxSyncThreadsAbilityService.releaseObject();
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdAbnormalPO ordAbnormalPO : ordAbnormalPOS) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordAbnormalPO.getOrderId());
                    combReqBO.setObjId(ordAbnormalPO.getAbnormalVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.ABNORMAL);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }

    private void batchDealInspection(UocPebOrdIdxSyncReqBO reqBO, UocPebOrdIdxSyncRspBO rspBO) {
        OrdInspectionPO inspectionPO = new OrdInspectionPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
            inspectionPO.setCreateTimeEff(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            inspectionPO.setCreateTimeExp(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        inspectionPO.setOrderBy("CREATE_TIME DESC");
        List listByCreateTime = this.ordInspectionMapper.getListByCreateTime(inspectionPO);
        rspBO.setRemark("ES\u540c\u6b65\u6570\u636e\u603b\u6761\u6570\uff1a" + listByCreateTime.size() + "");
        if (CollectionUtils.isNotEmpty((Collection)listByCreateTime)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<UocPebOrdIdxSyncReqBO> combReqBOList = new ArrayList<UocPebOrdIdxSyncReqBO>();
                for (OrdInspectionPO ordInspectionPO : listByCreateTime) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordInspectionPO.getOrderId());
                    combReqBO.setObjId(ordInspectionPO.getInspectionVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
                    combReqBOList.add(combReqBO);
                }
                try {
                    UocPebOrdIdxSyncThreadsImpl ordIdxSyncThreadsAbilityService = new UocPebOrdIdxSyncThreadsImpl();
                    List<UocPebOrdIdxSyncReqBO> failureCombReqBO = ordIdxSyncThreadsAbilityService.handleList(combReqBOList, reqBO.getThreadNum());
                    if (CollectionUtils.isNotEmpty(failureCombReqBO)) {
                        rspBO.setRespCode("0100");
                        rspBO.setRespDesc("ES\u540c\u6b65\u5931\u8d25\u6761\u6570\uff1a" + failureCombReqBO.size() + "\uff0c\u5c11\u4fa0\u5931\u8d25\u6570\u636e\u8bf7\u770b\u65e5\u5fd7\u3002");
                        logger.info("---ES\u540c\u6b65\u5931\u8d25\u6570\u636e---" + JSON.toJSONString(failureCombReqBO));
                    }
                    ordIdxSyncThreadsAbilityService.releaseObject();
                }
                catch (Exception e) {
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (OrdInspectionPO ordInspectionPO : listByCreateTime) {
                    UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
                    combReqBO.setOrderId(ordInspectionPO.getOrderId());
                    combReqBO.setObjId(ordInspectionPO.getInspectionVoucherId());
                    combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.INSPECTION);
                    if (reqBO.getIsMQ().booleanValue()) {
                        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
                        continue;
                    }
                    this.dealEsIdxSync(combReqBO);
                }
            }
        }
    }
}

