/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.order.ability.order.UocPebOrderListExportAbilityService;
import com.tydic.order.ability.order.bo.UocPebChildOrderAbilityBO;
import com.tydic.order.ability.order.bo.UocPebOrderItemAbilityBO;
import com.tydic.order.ability.order.bo.UocPebOrderListExportAbilityBO;
import com.tydic.order.ability.order.bo.UocPebOrderListExportAbilityPageBO;
import com.tydic.order.ability.order.bo.UocPebOrderListExportAbilityRspBO;
import com.tydic.order.ability.order.bo.UocPebPurOrdListAbilityReqBO;
import com.tydic.order.ability.order.bo.UocPebPurOrdListAbilityRspBO;
import com.tydic.order.ability.order.bo.UocPebUpperOrderAbilityBO;
import com.tydic.order.comb.order.UocPebPurOrdListCombService;
import com.tydic.order.constant.PecConstant;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocPebOrderListExportAbilityService.class)
public class UocPebOrderListExportAbilityServiceImpl
implements UocPebOrderListExportAbilityService {
    @Autowired
    private UocPebPurOrdListCombService uocPebPurOrdListCombService;
    private static final String SUCCESS_CODE = "0";
    @Value(value="${es.max.query.number}")
    private String maxQueryNumberStr;

    public UocPebOrderListExportAbilityRspBO dealOrderListExport(UocPebPurOrdListAbilityReqBO reqBO) {
        UocPebOrderListExportAbilityRspBO rspBO = new UocPebOrderListExportAbilityRspBO();
        rspBO.setCode(SUCCESS_CODE);
        rspBO.setMessage("\u67e5\u8be2\u6210\u529f");
        UocPebPurOrdListAbilityRspBO rowsInquire = this.getRows(reqBO);
        if (null == rowsInquire) {
            UocPebOrderListExportAbilityPageBO data = new UocPebOrderListExportAbilityPageBO();
            ArrayList rows = new ArrayList();
            data.setRows(rows);
            data.setPageNo(0);
            data.setPageSize(0);
            data.setTotal(0);
            data.setRecordsTotal(0);
            rspBO.setData(data);
            return rspBO;
        }
        rspBO.setData(this.transRows(rowsInquire, reqBO));
        return rspBO;
    }

    private UocPebPurOrdListAbilityRspBO getRows(UocPebPurOrdListAbilityReqBO reqBO) {
        if (PecConstant.EXPORT_LOCATION.MY_ORDER.equals(reqBO.getExportLocation())) {
            reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        } else if (PecConstant.EXPORT_LOCATION.ARRIVAL_ACCEPTANCE.equals(reqBO.getExportLocation())) {
            reqBO.setPurNo(String.valueOf(reqBO.getOrgId()));
        } else if (PecConstant.EXPORT_LOCATION.COMPANY_ORDER_QUERY.equals(reqBO.getExportLocation())) {
            reqBO.setPurNo(String.valueOf(reqBO.getOrgId()));
        } else if (PecConstant.EXPORT_LOCATION.ORDER_APPROVAL.equals(reqBO.getExportLocation())) {
            reqBO.setApporveFlag(Boolean.valueOf(true));
            reqBO.setOwnOperId(String.valueOf(reqBO.getUserId()));
        }
        Integer maxQueryNumber = Integer.valueOf(this.maxQueryNumberStr);
        if (maxQueryNumber < reqBO.getPageSize()) {
            UocPebPurOrdListAbilityRspBO combRspBO = new UocPebPurOrdListAbilityRspBO();
            ArrayList rows = new ArrayList();
            int remainingQuery = 0;
            for (int i = 0; i < reqBO.getPageSize() / maxQueryNumber; ++i) {
                UocPebPurOrdListAbilityReqBO combReqBO = (UocPebPurOrdListAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocPebPurOrdListAbilityReqBO.class);
                combReqBO.setPageSize(maxQueryNumber.intValue());
                UocPebPurOrdListAbilityRspBO combRspPageBO = this.uocPebPurOrdListCombService.qryQryOrderList(combReqBO);
                if (CollectionUtils.isEmpty((Collection)combRspPageBO.getRows())) {
                    return null;
                }
                rows.addAll(combRspPageBO.getRows());
                if (combRspPageBO.getRecordsTotal() < maxQueryNumber) break;
                remainingQuery = reqBO.getPageSize() - maxQueryNumber * i;
            }
            if (remainingQuery > 0) {
                UocPebPurOrdListAbilityReqBO combReqBO = (UocPebPurOrdListAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocPebPurOrdListAbilityReqBO.class);
                combReqBO.setPageSize(remainingQuery);
                UocPebPurOrdListAbilityRspBO combRspPageBO = this.uocPebPurOrdListCombService.qryQryOrderList(combReqBO);
                rows.addAll(combRspPageBO.getRows());
            }
            combRspBO.setRows(rows);
            return combRspBO;
        }
        return this.uocPebPurOrdListCombService.qryQryOrderList(reqBO);
    }

    private UocPebOrderListExportAbilityPageBO transRows(UocPebPurOrdListAbilityRspBO rowsInquire, UocPebPurOrdListAbilityReqBO reqBO) {
        UocPebOrderListExportAbilityPageBO rspBO = new UocPebOrderListExportAbilityPageBO();
        BeanUtils.copyProperties((Object)rowsInquire, (Object)rspBO);
        ArrayList<UocPebOrderListExportAbilityBO> rows = new ArrayList<UocPebOrderListExportAbilityBO>();
        if (CollectionUtils.isNotEmpty((Collection)rowsInquire.getRows())) {
            for (UocPebUpperOrderAbilityBO upperOrderAbilityBO : rowsInquire.getRows()) {
                for (UocPebChildOrderAbilityBO childOrderAbilityBO : upperOrderAbilityBO.getChildOrderList()) {
                    for (UocPebOrderItemAbilityBO orderItemAbilityBO : childOrderAbilityBO.getOrderItemList()) {
                        UocPebOrderListExportAbilityBO orderListExportAbilityBO = new UocPebOrderListExportAbilityBO();
                        BeanUtils.copyProperties((Object)orderItemAbilityBO, (Object)orderListExportAbilityBO);
                        BeanUtils.copyProperties((Object)upperOrderAbilityBO, (Object)orderListExportAbilityBO);
                        BeanUtils.copyProperties((Object)childOrderAbilityBO, (Object)orderListExportAbilityBO);
                        rows.add(orderListExportAbilityBO);
                    }
                }
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(rows.size());
        rspBO.setPageSize(rows.size());
        rspBO.setTotal(rows.size());
        rspBO.setRecordsTotal(rows.size());
        return rspBO;
    }
}

