/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.order.ability.order.UocProTransactionServiceListQueryAbilityService;
import com.tydic.order.ability.order.bo.UocProTransactionServiceListQueryReqBo;
import com.tydic.order.ability.order.bo.UocProTransactionServiceListQueryRspBo;
import com.tydic.order.bo.AuthorityInfoBO;
import com.tydic.order.impl.es.UocEsQryTransactionServiceListBusiService;
import com.tydic.order.impl.es.bo.UocEsQryTransactionServiceListReqBo;
import com.tydic.order.impl.es.bo.UocEsQryTransactionServiceListRspBo;
import com.tydic.order.third.intf.ability.umc.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationReqBO;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationRspBO;
import com.tydic.order.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.order.uoc.dao.po.ConfTabOrdStatePO;
import com.tydic.uoc.base.bo.other.UocProStationWebBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProTransactionServiceListQueryAbilityService.class)
public class UocProTransactionServiceListQueryAbilityServiceImpl
implements UocProTransactionServiceListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocProTransactionServiceListQueryAbilityServiceImpl.class);
    @Autowired
    private UocEsQryTransactionServiceListBusiService esQryTransactionServiceListBusiService;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;

    public UocProTransactionServiceListQueryRspBo queryTransactionServiceList(UocProTransactionServiceListQueryReqBo reqBo) {
        Boolean isPermission = this.controlPermission(reqBo);
        UocEsQryTransactionServiceListRspBo esQryTransactionServiceListRspBo = new UocEsQryTransactionServiceListRspBo();
        if (isPermission.booleanValue()) {
            UocEsQryTransactionServiceListReqBo esQryTransactionServiceListReqBo = (UocEsQryTransactionServiceListReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UocEsQryTransactionServiceListReqBo.class);
            if (null != reqBo.getTabId()) {
                esQryTransactionServiceListReqBo.setInspectionStateList(this.getStatueList(reqBo.getTabId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBo.getInspectionStateList())) {
                esQryTransactionServiceListReqBo.setInspectionStateQuery(new ArrayList<Integer>(reqBo.getInspectionStateList()));
            }
            if (null != reqBo.getInspectionState()) {
                esQryTransactionServiceListReqBo.setInspectionStateQuery(Collections.singletonList(reqBo.getInspectionState()));
            }
            if (CollectionUtils.isEmpty((Collection)reqBo.getSupNoList())) {
                esQryTransactionServiceListReqBo.setIsQuerySupplierId(true);
                esQryTransactionServiceListRspBo = this.esQryTransactionServiceListBusiService.esQryTransactionServiceList(esQryTransactionServiceListReqBo);
                if (CollectionUtils.isEmpty(esQryTransactionServiceListRspBo.getSupNoList())) {
                    return this.transEsQryInspectionListRspBo(esQryTransactionServiceListRspBo, false, reqBo);
                }
                esQryTransactionServiceListReqBo.setSupNoList(esQryTransactionServiceListRspBo.getSupNoList());
                esQryTransactionServiceListReqBo.setIsQuerySupplierId(null);
            }
            esQryTransactionServiceListRspBo = this.esQryTransactionServiceListBusiService.esQryTransactionServiceList(esQryTransactionServiceListReqBo);
        }
        return this.transEsQryInspectionListRspBo(esQryTransactionServiceListRspBo, isPermission, reqBo);
    }

    private UocProTransactionServiceListQueryRspBo transEsQryInspectionListRspBo(UocEsQryTransactionServiceListRspBo esQryTransactionServiceListRspBo, Boolean isPermission, UocProTransactionServiceListQueryReqBo reqBo) {
        UocProTransactionServiceListQueryRspBo rspBO = new UocProTransactionServiceListQueryRspBo();
        if (isPermission.booleanValue()) {
            rspBO.setPageNo(esQryTransactionServiceListRspBo.getPageNo());
            rspBO.setTotal(esQryTransactionServiceListRspBo.getTotal());
            rspBO.setRecordsTotal(esQryTransactionServiceListRspBo.getRecordsTotal());
            rspBO.setRows(esQryTransactionServiceListRspBo.getRows());
            rspBO.setSupplierInfoBos(esQryTransactionServiceListRspBo.getSupplierInfoBos());
        } else {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Boolean controlPermission(UocProTransactionServiceListQueryReqBo reqBo) {
        if (null != reqBo.getIsControlData() && reqBo.getIsControlData().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getUmcStationsListWebExt())) {
                throw new UocProBusinessException("0001", "\u5165\u53c2\u5c97\u4f4d\u4fe1\u606f[umcStationsListWebExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> orderSourceList = new ArrayList<String>();
            for (UocProStationWebBO stationWebBO : reqBo.getUmcStationsListWebExt()) {
                if ("cs:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("2");
                } else if ("zq:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("1");
                }
                if (orderSourceList.size() != 2) continue;
                break;
            }
            if (orderSourceList.size() == 0) {
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBo.getOrderSourceList())) {
                reqBo.getOrderSourceList().removeIf(orderSource -> !orderSourceList.contains(orderSource));
            } else if (orderSourceList.size() < 2) {
                reqBo.setOrderSourceList(orderSourceList);
            }
        }
        if (null != reqBo.getIsControlPermission() && reqBo.getIsControlPermission().booleanValue()) {
            AuthorityInfoBO authorityInfoBO = this.getOrgInfo(reqBo);
            if (StringUtils.isNotBlank((CharSequence)reqBo.getIsProfessionalOrgExt())) {
                if ("1".equals(reqBo.getIsProfessionalOrgExt()) && !authorityInfoBO.getViewAllFlag().booleanValue()) {
                    if (!CollectionUtils.isEmpty((Collection)authorityInfoBO.getOrgList()) || !CollectionUtils.isEmpty((Collection)authorityInfoBO.getOrgListThrough())) {
                        reqBo.setOrgList(authorityInfoBO.getOrgList());
                        reqBo.setOrgListThrough(authorityInfoBO.getOrgListThrough());
                        reqBo.setPurNo(null);
                    }
                    reqBo.setCreateOperId(String.valueOf(reqBo.getUserId()));
                }
            } else if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                if (!CollectionUtils.isEmpty((Collection)authorityInfoBO.getOrgIdList())) {
                    reqBo.setPurNo(null);
                    reqBo.setPurNoList(authorityInfoBO.getOrgIdList());
                }
                reqBo.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        return true;
    }

    private AuthorityInfoBO getOrgInfo(UocProTransactionServiceListQueryReqBo reqBo) {
        QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
        if (null == reqBo.getMemIdExt() || 0L == reqBo.getMemIdExt()) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        qryOrgReqBO.setMemIdExt(reqBo.getMemIdExt());
        qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
        QryOrgByUserStationRspBO qryOrgRspBo = this.pebIntfQryOrgByUserStationAbilityService.qryOrgTreePathByUserStation(qryOrgReqBO);
        log.debug("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)qryOrgRspBo));
        if (!"0000".equals(qryOrgRspBo.getRespCode())) {
            throw new UocProBusinessException(qryOrgRspBo.getRespCode(), qryOrgRspBo.getRespDesc());
        }
        AuthorityInfoBO authorityInfoBO = new AuthorityInfoBO();
        if (!qryOrgRspBo.getViewAllFlag().booleanValue()) {
            authorityInfoBO.setOrgList(qryOrgRspBo.getOrgList());
            authorityInfoBO.setOrgListThrough(qryOrgRspBo.getOrgListThrough());
        }
        authorityInfoBO.setViewAllFlag(qryOrgRspBo.getViewAllFlag());
        return authorityInfoBO;
    }

    private List<Integer> getStatueList(Integer tabId) {
        ConfTabOrdStatePO confTabOrdStatePO = this.confTabOrdStateMapper.getModelById((long)tabId.intValue());
        if (null != confTabOrdStatePO) {
            ArrayList<Integer> statueItemList = new ArrayList<Integer>();
            String statueStr = confTabOrdStatePO.getOrderStatusCode();
            if (!StringUtils.isEmpty((CharSequence)statueStr)) {
                String[] statue = statueStr.contains(",") ? statueStr.split(",") : new String[]{statueStr};
                for (String state : statue) {
                    statueItemList.add(Integer.valueOf(state));
                }
            }
            return statueItemList;
        }
        throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u9875\u7b7e\uff08tabId\uff09\u914d\u7f6e\u4fe1\u606f");
    }
}

