/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.plan;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.order.ability.plan.PebExtPlanCreateAbilityService;
import com.tydic.order.bo.plan.EcpItemBO;
import com.tydic.order.bo.plan.PebExtPlanBO;
import com.tydic.order.bo.plan.PebExtPlanCreateReqBO;
import com.tydic.order.bo.plan.PebExtPlanCreateRspBO;
import com.tydic.order.bo.plan.PebExtPlanDetailQueryQueryReqBO;
import com.tydic.order.bo.plan.PebExtPlanDetailQueryQueryRspBO;
import com.tydic.order.bo.plan.PebExtPlanInfoUpdateReqBO;
import com.tydic.order.bo.plan.PebExtPlanInfoUpdateRspBO;
import com.tydic.order.bo.plan.PebExtPlanItemBO;
import com.tydic.order.busi.plan.PebExtPlanCreateBusiService;
import com.tydic.order.busi.plan.PebExtPlanDetailQueryBusiService;
import com.tydic.order.busi.plan.PebExtPlanInfoUpdateBusiService;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtPlanCreateAbilityService.class)
public class PebExtPlanCreateAbilityServiceImpl
implements PebExtPlanCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPlanCreateAbilityServiceImpl.class);
    @Autowired
    private PebExtPlanCreateBusiService pebExtPlanCreateBusiService;
    @Autowired
    private PebExtPlanDetailQueryBusiService pebExtPlanDetailQueryBusiService;
    @Autowired
    private PebExtPlanInfoUpdateBusiService pebExtPlanInfoUpdateBusiService;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    public PebExtPlanCreateRspBO dealPebExtPlanCreate(PebExtPlanCreateReqBO reqBO) {
        log.debug("\u4e2d\u6838\u8ba1\u5212\u521b\u5efaAPI\u5165\u53c2\uff1a" + reqBO);
        this.validateArgs(reqBO);
        PebExtPlanDetailQueryQueryRspBO queryBusiRetBo = this.checkPlanInfo(reqBO);
        if (null == queryBusiRetBo.getOrdPlanRspBO()) {
            log.debug("\u6267\u884c\u65b0\u589e\u64cd\u4f5c");
            PebExtPlanCreateRspBO retBo = this.pebExtPlanCreateBusiService.dealPebExtPlanCreate(reqBO);
            return retBo;
        }
        PebExtPlanCreateRspBO retBo = this.updatePlanInfo(reqBO, queryBusiRetBo);
        return retBo;
    }

    private PebExtPlanCreateRspBO updatePlanInfo(PebExtPlanCreateReqBO reqBO, PebExtPlanDetailQueryQueryRspBO queryBusiRetBo) {
        PebExtPlanInfoUpdateReqBO updateBusiReqBo = new PebExtPlanInfoUpdateReqBO();
        ArrayList<PebExtPlanItemBO> mxItems = new ArrayList<PebExtPlanItemBO>();
        updateBusiReqBo.setMxItems(mxItems);
        updateBusiReqBo.setJustUpdateStatus(Boolean.valueOf(false));
        PebExtPlanBO ordPlanRspBO = queryBusiRetBo.getOrdPlanRspBO();
        Long orderId = ordPlanRspBO.getOrderId();
        Long planId = ordPlanRspBO.getPlanId();
        updateBusiReqBo.setOrderId(orderId);
        updateBusiReqBo.setPlanId(planId);
        updateBusiReqBo.setJhmc(reqBO.getJHMC());
        updateBusiReqBo.setZxlsjhbh(reqBO.getZXLSJHBH());
        updateBusiReqBo.setJhtbr(reqBO.getJHTBR());
        updateBusiReqBo.setJhtbrlxdh(reqBO.getJHTBRLXDH());
        updateBusiReqBo.setSfgcjs(reqBO.getSFGCJS());
        updateBusiReqBo.setSfgcjsStr(PebExtConstant.PlanIsOrNot.getDesc((Integer)reqBO.getSFGCJS()).getDesc());
        updateBusiReqBo.setGcjsxmmc(reqBO.getGCJSXMMC());
        updateBusiReqBo.setCglx(reqBO.getCGLX());
        updateBusiReqBo.setCglxStr(PebExtConstant.ProcurementType.getDesc((Integer)reqBO.getCGLX()).getDesc());
        updateBusiReqBo.setSfgjcgsx(reqBO.getSFGJCGSX());
        updateBusiReqBo.setSfgjcgsxStr(PebExtConstant.PlanIsOrNot.getDesc((Integer)reqBO.getSFGJCGSX()).getDesc());
        updateBusiReqBo.setYsje(reqBO.getYSJE());
        updateBusiReqBo.setJycgfs(reqBO.getJYCGFS());
        updateBusiReqBo.setHtyjqdsj(reqBO.getHTYJQDSJ());
        updateBusiReqBo.setSwfzrmx(reqBO.getSWFZRMX());
        updateBusiReqBo.setSwfzrdh(reqBO.getSWFZRDH());
        updateBusiReqBo.setJsfzrmc(reqBO.getJSFZRMC());
        updateBusiReqBo.setJsfzrdh(reqBO.getJSFZRDH());
        updateBusiReqBo.setBz(reqBO.getBZ());
        updateBusiReqBo.setCjsj(reqBO.getCJSJ());
        updateBusiReqBo.setCgzxrbh(reqBO.getCGZXRBH());
        updateBusiReqBo.setCgzxjgbh(reqBO.getCGZXJGBH());
        updateBusiReqBo.setStatus(PebExtConstant.PlanStatus.TODO);
        updateBusiReqBo.setStatusStr("\u672a\u6267\u884c");
        updateBusiReqBo.setCreateTime(ordPlanRspBO.getCreateTime());
        updateBusiReqBo.setUsed(BigDecimal.ZERO);
        List ordPlanItemRspBoList = queryBusiRetBo.getOrdPlanItemRspBoList();
        boolean index = false;
        for (EcpItemBO itemBO : reqBO.getMxItems()) {
            PebExtPlanItemBO updateItemBo = new PebExtPlanItemBO();
            updateItemBo.setPlanId(planId);
            updateItemBo.setOrderId(orderId);
            updateItemBo.setPlanItemId(Long.valueOf(this.idUtil.nextId()));
            updateItemBo.setJhmxbh(itemBO.getJHMXBH());
            updateItemBo.setWlmc(itemBO.getWLMC());
            updateItemBo.setWlbh(itemBO.getWLBH());
            updateItemBo.setWxfl(itemBO.getWXFL());
            updateItemBo.setGgxh(itemBO.getGGXH());
            updateItemBo.setSl(itemBO.getSL());
            updateItemBo.setDw(itemBO.getDW());
            updateItemBo.setZzsmc(itemBO.getZZSMC());
            updateItemBo.setBeiz(itemBO.getBEIZ());
            updateItemBo.setCreateTime(ordPlanRspBO.getCreateTime());
            updateItemBo.setUsed(BigDecimal.ZERO);
            mxItems.add(updateItemBo);
        }
        PebExtPlanInfoUpdateRspBO updateBusiRetBo = this.pebExtPlanInfoUpdateBusiService.updatePlanInfo(updateBusiReqBo);
        PebExtPlanCreateRspBO retBo = new PebExtPlanCreateRspBO();
        BeanUtils.copyProperties((Object)updateBusiReqBo, (Object)retBo);
        retBo.setStatus("1");
        retBo.setMsg("\u6210\u529f");
        return retBo;
    }

    private PebExtPlanDetailQueryQueryRspBO checkPlanInfo(PebExtPlanCreateReqBO reqBO) {
        PebExtPlanDetailQueryQueryReqBO queryReqBo = new PebExtPlanDetailQueryQueryReqBO();
        queryReqBo.setZxlsjhbh(reqBO.getZXLSJHBH());
        queryReqBo.setQryItem(PebExtConstant.QUERY_PLAN_ITEM_INFO);
        PebExtPlanDetailQueryQueryRspBO queryRetBo = this.pebExtPlanDetailQueryBusiService.getPebExtPlanDetailQuery(queryReqBo);
        return queryRetBo;
    }

    private void validateArgs(PebExtPlanCreateReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getJHMC())) {
            throw new UocProBusinessException("0001", "\u8ba1\u5212\u540d\u79f0(JHMC)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getZXLSJHBH())) {
            throw new UocProBusinessException("0001", "\u8ba1\u5212\u7f16\u53f7(ZXLSJHBH)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getYSJE())) {
            throw new UocProBusinessException("0001", "\u9884\u7b97\u91d1\u989d\uff08\u4e07\u5143\uff09(YSJE)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getMxItems())) {
            throw new UocProBusinessException("0001", "\u8ba1\u5212\u660e\u7ec6(MxItems)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validatePlanItem(reqBO.getMxItems());
    }

    private void validatePlanItem(List<EcpItemBO> mxItems) {
        for (EcpItemBO item : mxItems) {
            if (StringUtils.isEmpty((Object)item.getJHMXBH())) {
                throw new UocProBusinessException("0001", "\u8ba1\u5212\u660e\u7ec6\u7f16\u53f7(JHMXBH)\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)item.getSL())) {
                throw new UocProBusinessException("0001", "\u6570\u91cf(SL)\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)item.getDW())) continue;
            throw new UocProBusinessException("0001", "\u8ba1\u91cf\u5355\u4f4d(DW)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

