/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.pro;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.pro.UocOrderRelUpdateAbilityService;
import com.tydic.order.ability.pro.bo.UocOrderRelUpdateReqBo;
import com.tydic.order.ability.pro.bo.UocOrderRelUpdateRspBo;
import com.tydic.order.busi.pro.UocOrderRelUpdateBusiService;
import com.tydic.order.comb.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.constant.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocOrderRelUpdateAbilityService.class)
public class UocOrderRelUpdateAbilityServiceImpl
implements UocOrderRelUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRelUpdateAbilityServiceImpl.class);
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Autowired
    private UocOrderRelUpdateBusiService uocOrderRelUpdateBusiService;

    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        this.validateArgs(reqBo);
        UocOrderRelUpdateRspBo rspBo = this.uocOrderRelUpdateBusiService.dealRelUpdate(reqBo);
        this.syncInspection(reqBo.getOrderId(), reqBo.getInspectionVoucherId());
        return rspBo;
    }

    private void validateArgs(UocOrderRelUpdateReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInspectionVoucherId())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[inspectionVoucherId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRelType())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[relType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRelState())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[relState]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncInspection(Long orderId, Long objId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(orderId);
        pebOrdIdxSyncReqBO.setObjId(objId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }
}

