/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.pro;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.pro.UocProOrderPaymentCallbackAbilityService;
import com.tydic.order.ability.pro.bo.UocProOrderPaymentCallbackAbilityReqBo;
import com.tydic.order.ability.pro.bo.UocProOrderPaymentCallbackAbilityRspBo;
import com.tydic.order.bo.other.UocOrdIdxSyncReqBO;
import com.tydic.order.busi.order.UocPebPreOrderSubmitBsuiService;
import com.tydic.order.busi.order.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.order.busi.order.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.order.busi.pro.UocProOrderPaymentCallbackBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocProOrderPaymentCallbackAbilityService.class)
public class UocProOrderPaymentCallbackAbilityServiceImpl
implements UocProOrderPaymentCallbackAbilityService {
    @Autowired
    private UocProOrderPaymentCallbackBusiService uocProOrderPaymentCallbackBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;

    public UocProOrderPaymentCallbackAbilityRspBo dealOrderPaymentCallback(UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProOrderPaymentCallbackAbilityRspBo rspBo = this.uocProOrderPaymentCallbackBusiService.dealOrderPaymentCallback(reqBo);
        if (null != rspBo.getIsRunPay() && rspBo.getIsRunPay().booleanValue()) {
            if ("2".equals(rspBo.getOrderSource())) {
                UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
                submitReqBO.setOrderId(reqBo.getOrderId());
                submitReqBO.setSaleVoucherId(rspBo.getSaleVoucherId());
                UocPebPreOrderSubmitRspBO submit = this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
                this.syncSale(rspBo, reqBo);
                if (!"0000".equals(submit.getRespCode())) {
                    throw new UocProBusinessException("8888", "\u7535\u5546\u8ba2\u5355\u5931\u8d25" + submit.getRespDesc());
                }
            }
            this.syncSale(rspBo, reqBo);
        } else if (null != rspBo.getSaleVoucherId()) {
            this.syncSale(rspBo, reqBo);
        }
        return rspBo;
    }

    private void validateArgs(UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getIsOrderCallback() || !reqBo.getIsOrderCallback().booleanValue()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getObjectId())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[objectId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getFscShouldPayId())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[fscShouldPayId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getShouldPayMoney())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[shouldPayMoney]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getShouldPayMoney().compareTo(BigDecimal.ZERO) <= 0) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[shouldPayMoney]\u5c5e\u6027\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPayMod())) {
                throw new UocProBusinessException("8888", "\u5165\u53c2\u5bf9\u8c61[payMod]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void syncSale(UocProOrderPaymentCallbackAbilityRspBo rspBo, UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(rspBo.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

