/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.saleorder;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.order.ability.saleorder.PebExtShipDetailsQueryAbilityService;
import com.tydic.order.ability.ship.UocShipDetailsQueryAbilityService;
import com.tydic.order.bo.saleorder.PebExtOrdShipItemRspBO;
import com.tydic.order.bo.saleorder.PebExtShipDetailsQueryReqBO;
import com.tydic.order.bo.saleorder.PebExtShipDetailsQueryRspBO;
import com.tydic.order.bo.ship.UocOrdShipItemRspBO;
import com.tydic.order.bo.ship.UocShipDetailsQueryReqBO;
import com.tydic.order.bo.ship.UocShipDetailsQueryRspBO;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAsItemMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdAsItemPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtShipDetailsQueryAbilityService.class)
public class PebExtShipDetailsQueryAbilityServiceImpl
implements PebExtShipDetailsQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtShipDetailsQueryAbilityServiceImpl.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private UocShipDetailsQueryAbilityService uocShipDetailsQueryAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;

    public PebExtShipDetailsQueryRspBO getShipDetailsQuery(PebExtShipDetailsQueryReqBO reqBO) {
        PebExtShipDetailsQueryRspBO retBo = new PebExtShipDetailsQueryRspBO();
        UocShipDetailsQueryReqBO coreReqBo = new UocShipDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)coreReqBo);
        UocShipDetailsQueryRspBO coreRspBo = this.uocShipDetailsQueryAbilityService.getUocShipDetailsQuery(coreReqBo);
        BeanUtils.copyProperties((Object)coreRspBo, (Object)retBo);
        if (!"0000".equals(coreRspBo.getRespCode())) {
            return retBo;
        }
        ArrayList<PebExtOrdShipItemRspBO> ordShipItemList = new ArrayList<PebExtOrdShipItemRspBO>();
        List ordShipItemRspBOList = coreRspBo.getOrdShipItemRspBOList();
        if (!CollectionUtils.isEmpty((Collection)ordShipItemRspBOList)) {
            for (UocOrdShipItemRspBO ordShipItem : ordShipItemRspBOList) {
                PebExtOrdShipItemRspBO shipItem = new PebExtOrdShipItemRspBO();
                BeanUtils.copyProperties((Object)ordShipItem, (Object)shipItem);
                BigDecimal inAfterCount = this.qryInAfterCount(reqBO.getOrderId(), shipItem.getShipItemId());
                shipItem.setInAfterCount(inAfterCount);
                ordShipItemList.add(shipItem);
            }
        }
        retBo.setOrdShipItemRspBOList(ordShipItemList);
        return retBo;
    }

    private BigDecimal qryInAfterCount(Long orderId, Long shipItemId) {
        BigDecimal inAfterCount;
        block4: {
            inAfterCount = BigDecimal.ZERO;
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            if (null == ordSalePO) break block4;
            if ("2".equals(ordSalePO.getOrderSource())) {
                List ordAsItemPOS = this.ordAsItemMapper.qryInAfterItems(orderId, shipItemId, Arrays.asList(UocConstant.AFS_ORDER_STATUS.PENDING_APPROVAL, UocConstant.AFS_ORDER_STATUS.IN_PROCESS, UocConstant.AFS_ORDER_STATUS.SUCCESS));
                for (OrdAsItemPO ordAsItemPO : ordAsItemPOS) {
                    inAfterCount = inAfterCount.add(ordAsItemPO.getReturnCount());
                }
            } else {
                List ordAsItemPOS = this.ordAsItemMapper.qryInAfterItems(orderId, shipItemId, Arrays.asList(UocConstant.ZONE_AFS_STATUS.WAITE_CONFIRM, UocConstant.ZONE_AFS_STATUS.ALREADY_CONFIRM));
                for (OrdAsItemPO ordAsItemPO : ordAsItemPOS) {
                    inAfterCount = inAfterCount.add(ordAsItemPO.getReturnCount());
                }
            }
        }
        return inAfterCount;
    }
}

