/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability.ship;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.order.ability.order.bo.UocPebChildOrderAbilityBO;
import com.tydic.order.ability.order.bo.UocPebOrdShipAbilityBO;
import com.tydic.order.ability.order.bo.UocPebOrdShipItemAbilityBO;
import com.tydic.order.ability.order.bo.UocPebUpperOrderAbilityBO;
import com.tydic.order.ability.ship.UocShipDetailsListPageQueryAbilityService;
import com.tydic.order.bo.AuthorityInfoBO;
import com.tydic.order.bo.ship.UocShipDetailsListPageQueryReqBO;
import com.tydic.order.bo.ship.UocShipDetailsListPageQueryRspBO;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.impl.es.UocEsQryShipListBusiService;
import com.tydic.order.impl.es.bo.UocEsQryShipListReqBO;
import com.tydic.order.impl.es.bo.UocEsQryShipListRspBO;
import com.tydic.order.third.intf.ability.umc.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationReqBO;
import com.tydic.order.third.intf.bo.umc.QryOrgByUserStationRspBO;
import com.tydic.order.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.order.uoc.dao.po.ConfTabOrdStatePO;
import com.tydic.uoc.base.bo.other.UocProStationWebBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=UocShipDetailsListPageQueryAbilityService.class)
public class UocShipDetailsListPageQueryAbilityServiceImpl
implements UocShipDetailsListPageQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocShipDetailsListPageQueryAbilityServiceImpl.class);
    @Autowired
    private UocEsQryShipListBusiService esQryShipListBusiService;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;

    public UocShipDetailsListPageQueryRspBO getShipDetailsList(UocShipDetailsListPageQueryReqBO reqBO) {
        Boolean isPermission = this.controlPermission(reqBO);
        UocEsQryShipListRspBO esQryShipListRspBO = new UocEsQryShipListRspBO();
        if (isPermission.booleanValue()) {
            UocEsQryShipListReqBO esQryShipListReqBO = this.buildEsQryShipListReqBO(reqBO);
            esQryShipListReqBO.setShipStatusList(this.getStatueList(reqBO.getTabId()));
            esQryShipListRspBO = this.esQryShipListBusiService.esQryShipList(esQryShipListReqBO);
        }
        return this.transEsQryShipListRspBO(esQryShipListRspBO, isPermission, reqBO);
    }

    private List<Integer> getStatueList(Integer tabId) {
        ConfTabOrdStatePO confTabOrdStatePO = this.confTabOrdStateMapper.getModelById((long)tabId.intValue());
        if (null != confTabOrdStatePO) {
            ArrayList<Integer> statueItemList = new ArrayList<Integer>();
            String statueStr = confTabOrdStatePO.getOrderStatusCode();
            if (!StringUtils.isEmpty((CharSequence)statueStr)) {
                String[] statue = statueStr.contains(",") ? statueStr.split(",") : new String[]{statueStr};
                for (String state : statue) {
                    statueItemList.add(Integer.valueOf(state));
                }
            }
            return statueItemList;
        }
        throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u9875\u7b7e\uff08tabId\uff09\u914d\u7f6e\u4fe1\u606f");
    }

    private UocEsQryShipListReqBO buildEsQryShipListReqBO(UocShipDetailsListPageQueryReqBO reqBO) {
        return (UocEsQryShipListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocEsQryShipListReqBO.class);
    }

    private UocShipDetailsListPageQueryRspBO transEsQryShipListRspBO(UocEsQryShipListRspBO esQryShipListRspBO, Boolean isPermission, UocShipDetailsListPageQueryReqBO reqBO) {
        UocShipDetailsListPageQueryRspBO rspBO = new UocShipDetailsListPageQueryRspBO();
        if (isPermission.booleanValue()) {
            rspBO.setPageNo(esQryShipListRspBO.getPageNo());
            rspBO.setTotal(esQryShipListRspBO.getTotal());
            rspBO.setRecordsTotal(esQryShipListRspBO.getRecordsTotal());
            if (null != reqBO.getAfterDimension() && CollectionUtils.isNotEmpty((Collection)esQryShipListRspBO.getRows())) {
                for (UocPebUpperOrderAbilityBO upperOrderAbilityBO : esQryShipListRspBO.getRows()) {
                    for (UocPebChildOrderAbilityBO pebChildOrderAbilityBO : upperOrderAbilityBO.getChildOrderList()) {
                        for (UocPebOrdShipAbilityBO pebOrdShipAbilityBO : pebChildOrderAbilityBO.getOrdShipList()) {
                            ArrayList<UocPebOrdShipItemAbilityBO> newShipItemAbilityBOS = new ArrayList<UocPebOrdShipItemAbilityBO>();
                            for (UocPebOrdShipItemAbilityBO pebOrdShipItemAbilityBO : pebOrdShipAbilityBO.getShipItemList()) {
                                BigDecimal availableAfterServCount = new BigDecimal(0);
                                if (null == pebOrdShipItemAbilityBO.getAfterServCount()) {
                                    if (UocCoreConstant.shipAfterDimension.SHIPPING.equals(reqBO.getAfterDimension())) {
                                        availableAfterServCount = pebOrdShipItemAbilityBO.getSendCount();
                                    } else if (UocCoreConstant.shipAfterDimension.ARRIVED.equals(reqBO.getAfterDimension())) {
                                        availableAfterServCount = pebOrdShipItemAbilityBO.getArrivalCount();
                                    } else if (UocCoreConstant.shipAfterDimension.ACCEPTED.equals(reqBO.getAfterDimension())) {
                                        availableAfterServCount = pebOrdShipItemAbilityBO.getAcceptanceCount();
                                    }
                                } else if (UocCoreConstant.shipAfterDimension.SHIPPING.equals(reqBO.getAfterDimension())) {
                                    availableAfterServCount = pebOrdShipItemAbilityBO.getSendCount().subtract(pebOrdShipItemAbilityBO.getAfterServCount());
                                } else if (UocCoreConstant.shipAfterDimension.ARRIVED.equals(reqBO.getAfterDimension())) {
                                    availableAfterServCount = pebOrdShipItemAbilityBO.getArrivalCount().subtract(pebOrdShipItemAbilityBO.getAfterServCount());
                                } else if (UocCoreConstant.shipAfterDimension.ACCEPTED.equals(reqBO.getAfterDimension())) {
                                    availableAfterServCount = pebOrdShipItemAbilityBO.getAcceptanceCount().subtract(pebOrdShipItemAbilityBO.getAfterServCount());
                                }
                                if (availableAfterServCount.compareTo(BigDecimal.ZERO) <= 0) continue;
                                pebOrdShipItemAbilityBO.setAvailableAfterServCount(availableAfterServCount);
                                newShipItemAbilityBOS.add(pebOrdShipItemAbilityBO);
                            }
                            pebOrdShipAbilityBO.setShipItemList(newShipItemAbilityBOS);
                        }
                    }
                }
            }
            rspBO.setRows(esQryShipListRspBO.getRows());
        } else {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Boolean controlPermission(UocShipDetailsListPageQueryReqBO reqBO) {
        if (null != reqBO.getIsControlData() && reqBO.getIsControlData().booleanValue()) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                throw new UocProBusinessException("0001", "\u5165\u53c2\u5c97\u4f4d\u4fe1\u606f[umcStationsListWebExt]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> orderSourceList = new ArrayList<String>();
            for (UocProStationWebBO stationWebBO : reqBO.getUmcStationsListWebExt()) {
                if ("cs:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("2");
                } else if ("zq:sjg".equals(stationWebBO.getStationCode())) {
                    orderSourceList.add("1");
                }
                if (orderSourceList.size() != 2) continue;
                break;
            }
            if (orderSourceList.size() == 0) {
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList())) {
                reqBO.getOrderSourceList().removeIf(orderSource -> !orderSourceList.contains(orderSource));
            } else if (orderSourceList.size() < 2) {
                reqBO.setOrderSourceList(orderSourceList);
            }
        }
        if (null != reqBO.getIsControlPermission() && reqBO.getIsControlPermission().booleanValue()) {
            AuthorityInfoBO authorityInfoBO = this.getOrgInfo(reqBO);
            if (StringUtils.isNotBlank((CharSequence)reqBO.getIsProfessionalOrgExt())) {
                if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
                    if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                        if (!CollectionUtils.isEmpty((Collection)authorityInfoBO.getOrgList()) || !CollectionUtils.isEmpty((Collection)authorityInfoBO.getOrgListThrough())) {
                            reqBO.setOrgList(authorityInfoBO.getOrgList());
                            reqBO.setOrgListThrough(authorityInfoBO.getOrgListThrough());
                        }
                        reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
                    }
                } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                    reqBO.setSupNo(String.valueOf(reqBO.getSupId()));
                }
            } else if (!authorityInfoBO.getViewAllFlag().booleanValue()) {
                if (!CollectionUtils.isEmpty((Collection)authorityInfoBO.getOrgIdList())) {
                    reqBO.setPurNoList(authorityInfoBO.getOrgIdList());
                }
                reqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            }
        }
        return true;
    }

    private AuthorityInfoBO getOrgInfo(UocShipDetailsListPageQueryReqBO reqBO) {
        QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
        if (null == reqBO.getMemIdExt() || 0L == reqBO.getMemIdExt()) {
            throw new UocProBusinessException("0001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        qryOrgReqBO.setMemIdExt(reqBO.getMemIdExt());
        qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
        QryOrgByUserStationRspBO qryOrgRspBO = this.pebIntfQryOrgByUserStationAbilityService.qryOrgTreePathByUserStation(qryOrgReqBO);
        log.debug("\u53d1\u8d27\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)qryOrgRspBO));
        if (!"0000".equals(qryOrgRspBO.getRespCode())) {
            throw new UocProBusinessException(qryOrgRspBO.getRespCode(), qryOrgRspBO.getRespDesc());
        }
        AuthorityInfoBO authorityInfoBO = new AuthorityInfoBO();
        if (!qryOrgRspBO.getViewAllFlag().booleanValue()) {
            authorityInfoBO.setOrgList(qryOrgRspBO.getOrgList());
            authorityInfoBO.setOrgListThrough(qryOrgRspBO.getOrgListThrough());
        }
        authorityInfoBO.setViewAllFlag(qryOrgRspBO.getViewAllFlag());
        return authorityInfoBO;
    }
}

