/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.atom.impl.core;

import com.tydic.order.bo.process.UocProcessStartReqBO;
import com.tydic.order.bo.process.UocProcessStartRspBO;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.impl.atom.core.UocCoreCreateOrderAtomService;
import com.tydic.order.impl.atom.core.UocCoreExtFieldInAtomService;
import com.tydic.order.impl.atom.core.UocCoreGetOrderIdAtomService;
import com.tydic.order.impl.atom.core.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreateOrderRspBO;
import com.tydic.order.impl.atom.core.bo.UocCoreExtFieldInReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreExtFieldInRspBO;
import com.tydic.order.impl.atom.core.bo.UocCoreGetOrderIdRspBO;
import com.tydic.order.impl.atom.process.UocStartProcessAtomService;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocCoreCreateOrderAtomService")
public class UocCoreCreateOrderAtomServiceImpl
implements UocCoreCreateOrderAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreCreateOrderAtomServiceImpl.class);
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String orderSystem;
    @Autowired
    private UocCoreGetOrderIdAtomService getOrderIdAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private UocCoreExtFieldInAtomService extFieldInAtomService;
    @Autowired
    private UocStartProcessAtomService uocStartProcessAtomService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UocCoreCreateOrderRspBO dealCoreCreateOrder(AtomUocCoreCreateOrderReqBO reqBO) {
        boolean hasExtField;
        Long orderId;
        this.validParam(reqBO);
        UocCoreCreateOrderRspBO rspBO = new UocCoreCreateOrderRspBO();
        if (reqBO.getOrderId() == null) {
            UocCoreGetOrderIdRspBO getOrderIdAtomRspBO = this.getOrderIdAtomService.queryCoreGetOrderId();
            if (!"0000".equals(getOrderIdAtomRspBO.getRespCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u83b7\u53d6\u5168\u5c40\u8ba2\u5355\u53f7\u5931\u8d25");
                return rspBO;
            }
            orderId = getOrderIdAtomRspBO.getOrderId();
        } else {
            orderId = reqBO.getOrderId();
        }
        OrderPO orderPO = new OrderPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)orderPO);
        orderPO.setOrderId(orderId);
        orderPO.setTotalSaleFee(reqBO.getSaleFee());
        orderPO.setTotalPurchaseFee(reqBO.getSaleFee());
        if (reqBO.getPayState() == null) {
            orderPO.setPayState(UocConstant.PAY_ORDER_STATUS.CREATE);
        }
        orderPO.setOrderState(UocConstant.CORE_ORDER_STATUS.CREATE);
        orderPO.setFinishFlag(UocConstant.CORE_ORDER_FINISH_FLAG.TRANSIT);
        try {
            this.orderMapper.insert(orderPO);
            OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)ordStakeholderPO);
            ordStakeholderPO.setOrderId(orderId);
            ordStakeholderPO.setProRelaMobile(reqBO.getProAccountRelaMobile());
            if (StringUtils.isBlank((CharSequence)ordStakeholderPO.getPurNo())) {
                ordStakeholderPO.setPurNo(String.valueOf(reqBO.getOrgId()));
            }
            ordStakeholderPO.setProNo(reqBO.getProId());
            ordStakeholderPO.setSupNo(String.valueOf(reqBO.getSupId()));
            ordStakeholderPO.setProAccount(reqBO.getProAccount());
            this.ordStakeholderMapper.insert(ordStakeholderPO);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u521b\u5efa\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
        boolean bl = hasExtField = reqBO.getCruFieldList() != null && reqBO.getCruFieldList().size() > 0 || reqBO.getExtFieldList() != null && reqBO.getExtFieldList().size() > 0;
        if (hasExtField) {
            UocCoreExtFieldInReqBO extFieldInAtomReqBO = new UocCoreExtFieldInReqBO();
            extFieldInAtomReqBO.setOrderId(orderId);
            extFieldInAtomReqBO.setCruFieldList(reqBO.getCruFieldList());
            extFieldInAtomReqBO.setExtFieldList(reqBO.getExtFieldList());
            extFieldInAtomReqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            UocCoreExtFieldInRspBO extFieldInAtomRspBO = this.extFieldInAtomService.dealCoreExtFieldIn(extFieldInAtomReqBO);
            if (!"0000".equals(extFieldInAtomRspBO.getRespCode())) {
                rspBO.setRespCode(extFieldInAtomRspBO.getRespCode());
                rspBO.setRespDesc(extFieldInAtomRspBO.getRespDesc());
                return rspBO;
            }
        }
        rspBO.setOrderId(orderId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u521b\u5efa\u6210\u529f");
        return rspBO;
    }

    private UocProcessStartRspBO startProcess(Long orderId) {
        UocProcessStartReqBO processStartReqBO = new UocProcessStartReqBO();
        processStartReqBO.setProcDefId("SALE_ORDER");
        processStartReqBO.setProcDefKey("SALE_ORDER");
        processStartReqBO.setSysCode("UOC");
        processStartReqBO.setObjId(orderId);
        processStartReqBO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        processStartReqBO.setOrderId(orderId);
        return this.uocStartProcessAtomService.start(processStartReqBO);
    }

    private void validParam(AtomUocCoreCreateOrderReqBO reqBO) {
        if (reqBO == null || StringUtils.isBlank((CharSequence)reqBO.getOrderNo())) {
            throw new UocProBusinessException("7777", "\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSystem())) {
            reqBO.setOrderSystem(this.orderSystem);
        } else {
            if (reqBO.getOrderType() == null) {
                throw new UocProBusinessException("7777", "\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCreateOperId())) {
                throw new UocProBusinessException("7777", "\u521b\u5efa\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getPurId())) {
                throw new UocProBusinessException("7777", "\u91c7\u8d2d\u65b9\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getPurPlaceOrderId())) {
                throw new UocProBusinessException("7777", "\u4e0b\u5355\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != reqBO.getSupId()) {
                throw new UocProBusinessException("7777", "\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

