/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.atom.impl.order;

import com.tydic.order.bo.order.UocCoreStateCheckAtomReqBO;
import com.tydic.order.bo.order.UocCoreStateCheckAtomRspBO;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.impl.atom.order.UocCoreStateCheckAtomService;
import com.tydic.order.uoc.dao.ConfTacheStateMapper;
import com.tydic.order.uoc.dao.OrdAbnormalMapper;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdInspectionMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdPurchaseMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.ConfTacheStatePO;
import com.tydic.order.uoc.dao.po.OrdAbnormalPO;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdInspectionPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdPurchasePO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreStateCheckAtomService")
public class UocCoreStateCheckAtomServiceImpl
implements UocCoreStateCheckAtomService {
    @Autowired
    private ConfTacheStateMapper confTacheStateMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;

    @Override
    public UocCoreStateCheckAtomRspBO getUocCoreStateCheck(UocCoreStateCheckAtomReqBO reqBO) {
        UocCoreStateCheckAtomRspBO rspBO = new UocCoreStateCheckAtomRspBO();
        this.validateParams(reqBO);
        List<String> checkStatusList = this.getCheckStatus(reqBO);
        String objStatus = this.getObjStatus(reqBO);
        rspBO.setObjState(objStatus);
        this.checkObjStatus(checkStatusList, objStatus);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCoreStateCheckAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("0002", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getObjId()) {
            throw new UocProBusinessException("0002", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61ID\u3010objId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getObjType()) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u7c7b\u578b\u3010objType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getActionCode()) {
            throw new UocProBusinessException("0001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u52a8\u4f5c\u7f16\u7801\u3010actionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<String> getCheckStatus(UocCoreStateCheckAtomReqBO reqBO) {
        ArrayList<String> checkStatusList = new ArrayList<String>();
        ConfTacheStatePO tacheStatePO = new ConfTacheStatePO();
        tacheStatePO.setTacheCode(reqBO.getActionCode());
        tacheStatePO.setStateType(reqBO.getObjType() + "");
        try {
            List confTacheStatePOList = this.confTacheStateMapper.getList(tacheStatePO);
            if (CollectionUtils.isEmpty((Collection)confTacheStatePOList)) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u52a8\u4f5c\u7f16\u7801\u7684\u914d\u7f6e\u4fe1\u606f\uff1a" + reqBO.getActionCode());
            }
            for (ConfTacheStatePO confTacheStatePO : confTacheStatePOList) {
                checkStatusList.add(confTacheStatePO.getOrdState());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return checkStatusList;
    }

    private String getObjStatus(UocCoreStateCheckAtomReqBO reqBO) {
        String objStatus = "";
        if (UocCoreConstant.OBJ_TYPE.ORDER.equals(reqBO.getObjType())) {
            OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
            objStatus = orderPO.getOrderState() + "";
        } else if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO.setSaleVoucherId(reqBO.getObjId());
            OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(salePO);
            if (null == ordSalePO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordSalePO.getSaleState() + "";
        } else if (UocCoreConstant.OBJ_TYPE.SHIP.equals(reqBO.getObjType())) {
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setOrderId(reqBO.getOrderId());
            shipPO.setShipVoucherId(reqBO.getObjId());
            OrdShipPO ordShipPO = this.ordShipMapper.getModelBy(shipPO);
            if (null == ordShipPO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordShipPO.getShipStatus();
        } else if (UocCoreConstant.OBJ_TYPE.INSPECTION.equals(reqBO.getObjType())) {
            OrdInspectionPO inspectionPO = new OrdInspectionPO();
            inspectionPO.setOrderId(reqBO.getOrderId());
            inspectionPO.setInspectionVoucherId(reqBO.getObjId());
            OrdInspectionPO ordInspectionPO = this.ordInspectionMapper.getModelBy(inspectionPO);
            if (null == ordInspectionPO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordInspectionPO.getInspectionState() + "";
        } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
            OrdAfterServicePO ordAfterServicePO = this.ordAfterServiceMapper.getModelById(reqBO.getObjId().longValue());
            if (null == ordAfterServicePO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordAfterServicePO.getServState() + "";
        } else if (UocCoreConstant.OBJ_TYPE.PAY.equals(reqBO.getObjType())) {
            OrdPayPO payPO = new OrdPayPO();
            payPO.setOrderId(reqBO.getOrderId());
            payPO.setObjId(reqBO.getObjId());
            OrdPayPO ordPayPO = this.ordPayMapper.getModelBy(payPO);
            if (null == ordPayPO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordPayPO.getPayState() + "";
        } else if (UocCoreConstant.OBJ_TYPE.PURCHASE.equals(reqBO.getObjType())) {
            OrdPurchasePO purchasePO = new OrdPurchasePO();
            purchasePO.setOrderId(reqBO.getOrderId());
            purchasePO.setPurchaseVoucherId(reqBO.getObjId());
            OrdPurchasePO ordPurchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
            if (null == ordPurchasePO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordPurchasePO.getPurchaseState() + "";
        } else if (UocCoreConstant.OBJ_TYPE.ABNORMAL.equals(reqBO.getObjType())) {
            OrdAbnormalPO abnormalPO = new OrdAbnormalPO();
            abnormalPO.setOrderId(reqBO.getOrderId());
            abnormalPO.setAbnormalVoucherId(reqBO.getObjId());
            OrdAbnormalPO ordAbnormalPO = this.ordAbnormalMapper.getModelBy(abnormalPO);
            if (null == ordAbnormalPO) {
                throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u5355\u636e\u4fe1\u606f\uff1a" + reqBO.getOrderId());
            }
            objStatus = ordAbnormalPO.getAbnormalState() + "";
        }
        return objStatus;
    }

    private void checkObjStatus(List<String> checkStatusList, String objStatus) {
        for (String checkStatus : checkStatusList) {
            if (!objStatus.equals(checkStatus)) continue;
            return;
        }
        throw new UocProBusinessException("100031", "\u5355\u636e\u72b6\u6001\u68c0\u9a8c\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c");
    }
}

