/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.atom.order;

import com.alibaba.fastjson.JSON;
import com.tydic.order.atom.order.UocOrderRemindAtomService;
import com.tydic.order.atom.order.bo.RemindInfo;
import com.tydic.order.atom.order.bo.UocOrderRemindAtomServiceReqBO;
import com.tydic.order.atom.order.bo.UocOrderRemindAtomServiceRspBO;
import com.tydic.order.constant.PecConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.third.intf.ability.notify.PebExecuteOrderRemindAbilityService;
import com.tydic.order.third.intf.bo.notify.PebExecuteOrderRemindAbilityServiceReqBO;
import com.tydic.order.third.intf.bo.notify.PebExecuteOrderRemindAbilityServiceRspBO;
import com.tydic.order.uoc.dao.ConfStatusRemindMapper;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdAgreementMapper;
import com.tydic.order.uoc.dao.OrdPurchaseMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrdTaskMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.ConfStatusRemindPO;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdAgreementPO;
import com.tydic.order.uoc.dao.po.OrdPurchasePO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrdTaskPO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uocOrderRemindAtomService")
public class UocOrderRemindAtomServiceImpl
implements UocOrderRemindAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRemindAtomServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private ConfStatusRemindMapper confStatusRemindMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdTaskMapper ordTaskMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private PebExecuteOrderRemindAbilityService pebExecuteOrderRemindAbilityService;
    private static final String DATETIME_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";

    public UocOrderRemindAtomServiceRspBO dealRemind(UocOrderRemindAtomServiceReqBO reqBO) {
        this.validateSendType(reqBO);
        UocOrderRemindAtomServiceRspBO retBo = new UocOrderRemindAtomServiceRspBO();
        OrdSalePO ordSalePO = this.qryOrdSale(reqBO);
        List<ConfStatusRemindPO> templates = this.getTemplates(reqBO, ordSalePO);
        for (ConfStatusRemindPO template : templates) {
            RemindInfo remindInfo = this.assignParam(reqBO, ordSalePO, template);
            this.executeRemind(remindInfo, reqBO);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void executeRemind(RemindInfo remindInfo, UocOrderRemindAtomServiceReqBO reqBO) {
        PebExecuteOrderRemindAbilityServiceReqBO executeAtomReqBo = new PebExecuteOrderRemindAbilityServiceReqBO();
        BeanUtils.copyProperties((Object)remindInfo, (Object)executeAtomReqBo);
        executeAtomReqBo.setSendType(reqBO.getSendType());
        PebExecuteOrderRemindAbilityServiceRspBO executeAtomRetBo = this.pebExecuteOrderRemindAbilityService.executeRemind(executeAtomReqBo);
        if (!"0000".equals(executeAtomRetBo.getRespCode())) {
            throw new UocProBusinessException("0100", "\u8ba2\u5355id\u3010" + reqBO.getOrderId() + "\u63d0\u9192\u5931\u8d25\u3011:" + executeAtomRetBo.getRespDesc());
        }
    }

    private RemindInfo assignParam(UocOrderRemindAtomServiceReqBO reqBO, OrdSalePO ordSalePO, ConfStatusRemindPO template) {
        RemindInfo remindInfo = new RemindInfo();
        OrderPO orderPO = this.orderMapper.getModelById(ordSalePO.getOrderId().longValue());
        OrdPurchasePO purchaseInfo = new OrdPurchasePO();
        purchaseInfo.setOrderId(ordSalePO.getOrderId());
        purchaseInfo = this.ordPurchaseMapper.getModelBy(purchaseInfo);
        OrdStakeholderPO stakeholderInfo = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
        OrdAfterServicePO afterServiceInfo = new OrdAfterServicePO();
        afterServiceInfo.setOrderId(reqBO.getOrderId());
        afterServiceInfo = this.ordAfterServiceMapper.getModelBy(afterServiceInfo);
        OrdAgreementPO agreementInfo = new OrdAgreementPO();
        if (ordSalePO.getOrderSource().equals(PecConstant.ORDER_SOURCE.ELEC_AREA.toString())) {
            agreementInfo.setOrderId(ordSalePO.getOrderId());
            List agreementInfos = this.ordAgreementMapper.selectByCondition(agreementInfo);
            if (CollectionUtils.isEmpty((Collection)agreementInfos)) {
                throw new UocProBusinessException("0100", "\u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u3010" + reqBO.getOrderId() + "\u3011\u7684\u534f\u8bae\u4fe1\u606f");
            }
            agreementInfo = (OrdAgreementPO)agreementInfos.get(0);
        }
        String content = template.getContent();
        content = content.replace("ORDER_NO", ordSalePO.getSaleVoucherNo());
        content = content.replace("URL", "https://www.cnncmall.com");
        content = this.setDateTime(content, orderPO, reqBO.getActionCode(), afterServiceInfo);
        remindInfo.setContent(content);
        switch (template.getBusiType()) {
            case "1": {
                remindInfo.setMobile(agreementInfo.getVendorPhone());
                if (!ordSalePO.getOrderSource().equals(PecConstant.ORDER_SOURCE.INQUIRY_PRICE_FRAMEWORK_AGREEMENT.toString())) break;
                remindInfo.setMobile(stakeholderInfo.getSupRelaMobile());
                break;
            }
            case "2": {
                remindInfo.setMobile(stakeholderInfo.getPurMobile());
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u7ec4\u88c5\u597d\u7684\u63d0\u9192\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)remindInfo));
        }
        return remindInfo;
    }

    private String setDateTime(String content, OrderPO orderPO, String actionCode2, OrdAfterServicePO afterServiceInfo) {
        String result = content.replace("TIME", DateTime.now().toString(DATETIME_FORMAT));
        switch (actionCode2) {
            case "ACTPEB023": 
            case "ACTPEB011": {
                OrdTaskPO taskPo = new OrdTaskPO();
                taskPo.setOrderId(orderPO.getOrderId());
                taskPo.setTaskState(UocConstant.TASK_STATE.PROCESSED);
                OrdTaskPO taskPO = this.ordTaskMapper.queryLatestRecord(taskPo);
                if (taskPO == null || null == taskPO.getFinishTime()) break;
                result = content.replace("TIME", new DateTime((Object)taskPO.getFinishTime()).toString(DATETIME_FORMAT));
                break;
            }
            case "ACTPEB024": 
            case "ACTPEB012": {
                result = content.replace("TIME", new DateTime((Object)orderPO.getCreateTime()).toString(DATETIME_FORMAT));
                break;
            }
            case "ACTPEB026": {
                result = content.replace("TIME", new DateTime((Object)afterServiceInfo.getCreateTime()).toString(DATETIME_FORMAT));
                result = result.replace("SERVICE_NO", afterServiceInfo.getAfterServCode());
            }
        }
        return result;
    }

    private List<ConfStatusRemindPO> getTemplates(UocOrderRemindAtomServiceReqBO reqBO, OrdSalePO ordSalePO) {
        ConfStatusRemindPO confReqPo = new ConfStatusRemindPO();
        confReqPo.setStatus(ordSalePO.getSaleState().toString());
        confReqPo.setTemplateId(reqBO.getActionCode());
        List templates = this.confStatusRemindMapper.selectByCondition(confReqPo);
        if (CollectionUtils.isEmpty((Collection)templates)) {
            throw new UocProBusinessException("0100", "\u6ca1\u6709\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f\uff0c\u52a8\u4f5c\u7f16\u7801:" + reqBO.getActionCode() + "\uff0c\u8ba2\u5355\u72b6\u6001\uff1a" + ordSalePO.getSaleState().toString());
        }
        return templates;
    }

    private OrdSalePO qryOrdSale(UocOrderRemindAtomServiceReqBO reqBO) {
        OrdSalePO saleInfoPo = new OrdSalePO();
        saleInfoPo.setOrderId(reqBO.getOrderId());
        saleInfoPo = this.ordSaleMapper.getModelBy(saleInfoPo);
        if (null == saleInfoPo) {
            throw new UocProBusinessException("0100", "\u6839\u636e\u8ba2\u5355id\u3010" + reqBO.getOrderId() + "\u3011\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        return saleInfoPo;
    }

    private void validateSendType(UocOrderRemindAtomServiceReqBO reqBO) {
        if (null == reqBO.getSendType()) {
            reqBO.setSendType(UocCoreConstant.SEND_TYPE.SMS);
            return;
        }
        if (!(UocCoreConstant.SEND_TYPE.SMS.equals(reqBO.getSendType()) || UocCoreConstant.SEND_TYPE.MAIL.equals(reqBO.getSendType()) || UocCoreConstant.SEND_TYPE.STATION_LETTER.equals(reqBO.getSendType()))) {
            throw new UocProBusinessException("0100", "\u4e0d\u652f\u6301\u7684\u53d1\u9001\u7c7b\u578b\u3010" + reqBO.getSendType() + "\u3011");
        }
    }
}

