/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.atom.order;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.atom.order.UocPebAddSaleNumAtomService;
import com.tydic.order.atom.order.UocPebClearingARefundAtomService;
import com.tydic.order.atom.order.bo.UocPebAddSaleNumReqBO;
import com.tydic.order.atom.order.bo.UocPebClearingARefundAtomReqBO;
import com.tydic.order.atom.order.bo.UocPebClearingARefundAtomRspBO;
import com.tydic.order.atom.others.GenerateOrderPaySeqAtomService;
import com.tydic.order.constant.PecConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.impl.atom.core.UocCoreCreatePayOrderAtomService;
import com.tydic.order.impl.atom.core.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.order.impl.bo.order.UocOrderPayItemBO;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdAsItemMapper;
import com.tydic.order.uoc.dao.OrdPayItemMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdPayItemPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocPebClearingARefundAtomServiceImpl
implements UocPebClearingARefundAtomService {
    private static final Integer DEFAULT_PAY_TYPE = 3;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private GenerateOrderPaySeqAtomService generateOrderPaySeqAtomService;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private UocPebAddSaleNumAtomService uocPebAddSaleNumAtomService;

    public UocPebClearingARefundAtomRspBO dealPebClearingARefund(UocPebClearingARefundAtomReqBO reqBO) {
        RefundInfo refundInfo;
        OrdSalePO ordSalePO = this.qryOrdSale(reqBO.getOrderId(), reqBO.getSaleVoucherId());
        if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            refundInfo = this.doCountRefundFeeForCancel(reqBO);
        } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
            refundInfo = this.doCountRefundFeeForRefund(reqBO);
        } else {
            throw new UocProBusinessException("0100", "\u4f20\u5165\u5355\u636e\u7c7b\u578b\u6709\u8bef\uff01");
        }
        UocPebClearingARefundAtomRspBO rspBO = new UocPebClearingARefundAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9000\u6b3e\u6210\u529f\uff01");
        return rspBO;
    }

    private OrdSalePO qryOrdSale(Long orderId, Long saleVoucherId) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(orderId);
        ordSalePO.setSaleVoucherId(saleVoucherId);
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (ordSalePO == null) {
            throw new UocProBusinessException("0100", "\u67e5\u8be2\u65e0\u9500\u552e\u5355");
        }
        return ordSalePO;
    }

    private RefundInfo doCountRefundFeeForRefund(UocPebClearingARefundAtomReqBO reqBO) {
        OrdPayPO ordPayPO = this.qyrOrdPay(reqBO);
        RefundInfo refundInfo = this.initRefundInfo(ordPayPO);
        return refundInfo;
    }

    private RefundInfo doCountRefundFeeForCancel(UocPebClearingARefundAtomReqBO reqBO) {
        OrdPayPO ordPayPO = this.qyrOrdPay(reqBO);
        RefundInfo refundInfo = this.initRefundInfo(ordPayPO);
        Long payVoucherID = this.doCreateRefunPayInfoForCancel(reqBO, ordPayPO);
        refundInfo.setPayVoucherId(payVoucherID);
        UocPebAddSaleNumReqBO numReqBO = new UocPebAddSaleNumReqBO();
        numReqBO.setOrderId(reqBO.getOrderId());
        numReqBO.setPayVoucherId(payVoucherID);
        numReqBO.setInterType(Integer.valueOf(1));
        this.uocPebAddSaleNumAtomService.dealAddSaleNum(numReqBO);
        return refundInfo;
    }

    private RefundInfo initRefundInfo(OrdPayPO ordPayPO) {
        RefundInfo refundInfo = new RefundInfo();
        refundInfo.setPayVoucherId(ordPayPO.getPayVoucherId());
        try {
            refundInfo.setRefundAmt(MoneyUtils.Long2BigDecimal((Long)ordPayPO.getTotalFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("0100", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e);
        }
        return refundInfo;
    }

    private OrdPayPO qyrOrdPay(UocPebClearingARefundAtomReqBO reqBO) {
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(reqBO.getOrderId());
        ordPayPO.setObjId(reqBO.getObjId());
        ordPayPO.setObjType(reqBO.getObjType());
        if (UocCoreConstant.OBJ_TYPE.SALE.equals(reqBO.getObjType())) {
            ordPayPO.setInterType(PecConstant.PAY_FLAG);
        } else if (UocCoreConstant.OBJ_TYPE.AFTER_SERVICE.equals(reqBO.getObjType())) {
            ordPayPO.setInterType(PecConstant.REFUND_FLAG);
        }
        ordPayPO = this.ordPayMapper.getModelBy(ordPayPO);
        if (ordPayPO == null) {
            throw new UocProBusinessException("0100", "\u67e5\u8be2\u65e0\u652f\u4ed8\u5355\u4fe1\u606f");
        }
        return ordPayPO;
    }

    private Long doCreateRefunPayInfoForCancel(UocPebClearingARefundAtomReqBO reqBO, OrdPayPO ordPayPO) {
        UocCoreCreatePayOrderRspBO createPayOrderRsp;
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = new UocCoreCreatePayOrderReqBO();
        uocCoreCreatePayOrderReqBO.setPayVoucherNo(this.generateOrderPaySeqAtomService.generateOrderPaySeq().getPayOrderId());
        uocCoreCreatePayOrderReqBO.setPayState(PecConstant.PAY_STAT_WAIT);
        uocCoreCreatePayOrderReqBO.setCreateOperId(reqBO.getUserId() + "");
        uocCoreCreatePayOrderReqBO.setOrderId(ordPayPO.getOrderId());
        uocCoreCreatePayOrderReqBO.setObjType(ordPayPO.getObjType());
        uocCoreCreatePayOrderReqBO.setObjId(ordPayPO.getObjId());
        uocCoreCreatePayOrderReqBO.setInterType(PecConstant.REFUND_FLAG);
        uocCoreCreatePayOrderReqBO.setPayType(DEFAULT_PAY_TYPE);
        uocCoreCreatePayOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        uocCoreCreatePayOrderReqBO.setTotalFee(ordPayPO.getTotalFee());
        uocCoreCreatePayOrderReqBO.setPayFee(ordPayPO.getPayFee());
        uocCoreCreatePayOrderReqBO.setPreFee(ordPayPO.getPreFee());
        OrdPayItemPO ordPayItemPO = new OrdPayItemPO();
        ordPayItemPO.setOrderId(ordPayPO.getOrderId());
        ordPayItemPO.setPayVoucherId(ordPayPO.getPayVoucherId());
        List payItemList = this.ordPayItemMapper.getList(ordPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)payItemList)) {
            ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>(payItemList.size());
            uocCoreCreatePayOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
            for (OrdPayItemPO itemPO : payItemList) {
                UocOrderPayItemBO uocOrderPayItemBO = new UocOrderPayItemBO();
                uocOrderPayItemBO.setOrdItemId(itemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjId(itemPO.getOrdItemId());
                uocOrderPayItemBO.setPayObjType(itemPO.getPayObjType());
                uocOrderPayItemBO.setUnitName(itemPO.getUnitName());
                uocOrderPayItemBO.setPurchaseCount(itemPO.getPurchaseCount());
                uocOrderPayItemBO.setSalePrice(itemPO.getSalePrice());
                uocOrderPayItemBO.setPurchasePrice(itemPO.getPurchasePrice());
                uocOrderPayItemBO.setCurrencyType(itemPO.getCurrencyType());
                uocOrderPayItemBO.setPayCount(itemPO.getPurchaseCount());
                uocOrderPayItemBO.setTotalFee(itemPO.getTotalFee());
                uocOrderPayItemBO.setPayFee(itemPO.getPayFee());
                uocOrderPayItemBO.setPreFee(itemPO.getPreFee());
                uocOrderPayItemBOList.add(uocOrderPayItemBO);
            }
        }
        if (!"0000".equals((createPayOrderRsp = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO)).getRespCode())) {
            throw new UocProBusinessException("0100", "\u9000\u6b3e\u652f\u4ed8\u5355\u521b\u5efa\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + createPayOrderRsp.getRespDesc());
        }
        return createPayOrderRsp.getPayVoucherID();
    }

    private static class RefundInfo
    implements Serializable {
        private static final long serialVersionUID = -8292778791916263382L;
        private Long txnNo;
        private BigDecimal refundAmt;
        private Long payVoucherId;

        public Long getTxnNo() {
            return this.txnNo;
        }

        public BigDecimal getRefundAmt() {
            return this.refundAmt;
        }

        public Long getPayVoucherId() {
            return this.payVoucherId;
        }

        public void setTxnNo(Long txnNo) {
            this.txnNo = txnNo;
        }

        public void setRefundAmt(BigDecimal refundAmt) {
            this.refundAmt = refundAmt;
        }

        public void setPayVoucherId(Long payVoucherId) {
            this.payVoucherId = payVoucherId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefundInfo)) {
                return false;
            }
            RefundInfo other = (RefundInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$txnNo = this.getTxnNo();
            Long other$txnNo = other.getTxnNo();
            if (this$txnNo == null ? other$txnNo != null : !((Object)this$txnNo).equals(other$txnNo)) {
                return false;
            }
            BigDecimal this$refundAmt = this.getRefundAmt();
            BigDecimal other$refundAmt = other.getRefundAmt();
            if (this$refundAmt == null ? other$refundAmt != null : !((Object)this$refundAmt).equals(other$refundAmt)) {
                return false;
            }
            Long this$payVoucherId = this.getPayVoucherId();
            Long other$payVoucherId = other.getPayVoucherId();
            return !(this$payVoucherId == null ? other$payVoucherId != null : !((Object)this$payVoucherId).equals(other$payVoucherId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefundInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $txnNo = this.getTxnNo();
            result = result * 59 + ($txnNo == null ? 43 : ((Object)$txnNo).hashCode());
            BigDecimal $refundAmt = this.getRefundAmt();
            result = result * 59 + ($refundAmt == null ? 43 : ((Object)$refundAmt).hashCode());
            Long $payVoucherId = this.getPayVoucherId();
            result = result * 59 + ($payVoucherId == null ? 43 : ((Object)$payVoucherId).hashCode());
            return result;
        }

        public String toString() {
            return "UocPebClearingARefundAtomServiceImpl.RefundInfo(txnNo=" + this.getTxnNo() + ", refundAmt=" + this.getRefundAmt() + ", payVoucherId=" + this.getPayVoucherId() + ")";
        }
    }
}

