/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi;

import com.ohaotian.plugin.db.Page;
import com.tydic.order.ability.bo.UocProOrderEffectiveDealReqBo;
import com.tydic.order.ability.bo.UocProOrderEffectiveDealRspBo;
import com.tydic.order.busi.UocProOrderEffectiveDealBusiService;
import com.tydic.order.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.order.uoc.dao.ConfEffectiveMapper;
import com.tydic.order.uoc.dao.po.ConfEffectivePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocProOrderEffectiveDealBusiServiceImpl
implements UocProOrderEffectiveDealBusiService {
    @Autowired
    private ConfEffectiveMapper confEffectiveMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;

    public UocProOrderEffectiveDealRspBo dealOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        UocProOrderEffectiveDealRspBo rspBo = new UocProOrderEffectiveDealRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete().booleanValue()) {
            this.deleteOrderEffective(reqBo);
            return rspBo;
        }
        if (null == reqBo.getEffectiveId() || 0L == reqBo.getEffectiveId()) {
            this.addOrderEffective(reqBo);
        } else {
            this.modifyOrderEffective(reqBo);
        }
        return rspBo;
    }

    private void deleteOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        ConfEffectivePO effectivePO = new ConfEffectivePO();
        effectivePO.setEffectiveId(reqBo.getEffectiveId());
        ConfEffectivePO modelBy = this.confEffectiveMapper.getModelBy(effectivePO);
        if (null == modelBy) {
            throw new UocProBusinessException("0100", "\u5165\u53c2[effectiveId]\u67e5\u8be2\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if ("0".equals(modelBy.getSourceCode())) {
            throw new UocProBusinessException("0100", "\u8be5\u6570\u636e\u4e3a\u7cfb\u7edf\u9884\u8bbe\u503c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.confEffectiveMapper.deleteBy(effectivePO);
    }

    private void modifyOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        if ("2".equals(reqBo.getBusinessTypeCode()) && "2".equals(reqBo.getBusinessTypeCode())) {
            ConfEffectivePO effectivePO = new ConfEffectivePO();
            effectivePO.setEffectiveCode("1");
            effectivePO.setBusinessTypeCode("2");
            effectivePO.setOrderBy("aging");
            Page confEffectivePOPage = new Page();
            confEffectivePOPage.setPageNo(1);
            confEffectivePOPage.setPageSize(1);
            List effectivePOS = this.confEffectiveMapper.getListPage(effectivePO, confEffectivePOPage);
            if (CollectionUtils.isEmpty((Collection)effectivePOS)) {
                throw new UocProBusinessException("0100", "\u7531\u4e8e\u7535\u5546\u9884\u5360\u5e93\u5b58\u65f6\u9650\u6ca1\u6709\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u914d\u7f6e \u7535\u5546\u91c7\u8d2d \u7684 \u8ba2\u5355\u786e\u8ba4\u4ed8\u6b3e\u65f6\u9650");
            }
            if (0L < ((ConfEffectivePO)effectivePOS.get(0)).getAging() && reqBo.getAging() > ((ConfEffectivePO)effectivePOS.get(0)).getAging()) {
                throw new UocProBusinessException("0100", "\u53ef\u8bbe\u7f6e\u7684\u65f6\u9650\u8303\u56f4\u5728" + this.formatDuring(((ConfEffectivePO)effectivePOS.get(0)).getAging()) + "\u4e4b\u5185\uff1b");
            }
        }
        ConfEffectivePO set = new ConfEffectivePO();
        set.setAging(reqBo.getAging());
        set.setOperatingTime(new Date());
        set.setOperatorId(String.valueOf(reqBo.getUserId()));
        set.setOperatorName(reqBo.getUsername());
        ConfEffectivePO where = new ConfEffectivePO();
        where.setEffectiveId(reqBo.getEffectiveId());
        int updateBy = this.confEffectiveMapper.updateBy(set, where);
        if (updateBy != 1) {
            throw new UocProBusinessException("0100", "\u5165\u53c2[effectiveId]\u4e0d\u5bf9\uff0c\u5bfc\u81f4\u4fee\u6539\u5185\u5bb9\u4e0d\u5bf9");
        }
    }

    private void addOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        String effectiveName = this.checkCodeCorrect(reqBo);
        ConfEffectivePO effectivePO = new ConfEffectivePO();
        effectivePO.setEffectiveCode(reqBo.getEffectiveCode());
        if (!"2".equals(reqBo.getEffectiveCode())) {
            if ("1".equals(reqBo.getEffectiveCode()) && !"2".equals(reqBo.getBusinessTypeCode())) {
                throw new UocProBusinessException("0100", "\u5165\u53c2[businessTypeCode]\u4e0d\u5141\u8bb8\u589e\u52a0\u65f6\u6548\u914d\u7f6e");
            }
            effectivePO.setSupplierNo(reqBo.getSupplierNo());
            int checkBy = this.confEffectiveMapper.getCheckBy(effectivePO);
            if (checkBy > 0) {
                throw new UocProBusinessException("0100", "\u5df2\u5b58\u5728\u8be5\u7535\u5546\u7684" + effectiveName + "\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
            }
        } else {
            throw new UocProBusinessException("0100", "\u5165\u53c2[effectiveCode]\u4e0d\u5141\u8bb8\u589e\u52a0\u65f6\u6548\u914d\u7f6e");
        }
        effectivePO.setSupplierName(reqBo.getSupplierName());
        effectivePO.setEffectiveId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
        effectivePO.setBusinessTypeCode(reqBo.getBusinessTypeCode());
        effectivePO.setAging(reqBo.getAging());
        effectivePO.setSourceCode(reqBo.getSourceCode());
        effectivePO.setOperatingTime(new Date());
        effectivePO.setOperatorId(String.valueOf(reqBo.getUserId()));
        effectivePO.setOperatorName(reqBo.getUsername());
        this.confEffectiveMapper.insert(effectivePO);
    }

    private String checkCodeCorrect(UocProOrderEffectiveDealReqBo reqBo) {
        SelectSingleDictReqBO selectSingleDictReqBO = new SelectSingleDictReqBO();
        selectSingleDictReqBO.setPcode("ORDER_SOURCE");
        selectSingleDictReqBO.setCode(reqBo.getBusinessTypeCode());
        SelectSingleDictRspBO selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        if (!"0000".equals(selectSingleDictRspBO.getRespCode())) {
            throw new UocProBusinessException(selectSingleDictRspBO.getRespCode(), selectSingleDictRspBO.getRespDesc());
        }
        if (null == selectSingleDictRspBO.getDicDictionarys()) {
            throw new UocProBusinessException("0100", "\u5165\u53c2[businessTypeCode]\u4e0d\u5408\u6cd5");
        }
        selectSingleDictReqBO.setPcode("SOURCE_CODE");
        selectSingleDictReqBO.setCode(reqBo.getSourceCode());
        selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        if (!"0000".equals(selectSingleDictRspBO.getRespCode())) {
            throw new UocProBusinessException(selectSingleDictRspBO.getRespCode(), selectSingleDictRspBO.getRespDesc());
        }
        if (null == selectSingleDictRspBO.getDicDictionarys()) {
            throw new UocProBusinessException("0100", "\u5165\u53c2[sourceCode]\u4e0d\u5408\u6cd5");
        }
        selectSingleDictReqBO.setPcode("EFFECTIVE_CODE");
        selectSingleDictReqBO.setCode(reqBo.getEffectiveCode());
        selectSingleDictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(selectSingleDictReqBO);
        if (!"0000".equals(selectSingleDictRspBO.getRespCode())) {
            throw new UocProBusinessException(selectSingleDictRspBO.getRespCode(), selectSingleDictRspBO.getRespDesc());
        }
        if (null == selectSingleDictRspBO.getDicDictionarys()) {
            throw new UocProBusinessException("0100", "\u5165\u53c2[effectiveCode]\u4e0d\u5408\u6cd5");
        }
        String effectiveName = selectSingleDictRspBO.getDicDictionarys().getDescrip();
        return effectiveName;
    }

    private String formatDuring(long aging) {
        long days = aging / 86400000L;
        long hours = aging % 86400000L / 3600000L;
        long minutes = aging % 3600000L / 60000L;
        return days + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206";
    }
}

