/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.goods;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.bo.goods.PebExtCreateComparisonGoodsReqBO;
import com.tydic.order.bo.goods.PebExtCreateComparisonGoodsRspBO;
import com.tydic.order.bo.goods.UocComparisonGoodsBO;
import com.tydic.order.bo.goods.UocComparisonGoodsListBO;
import com.tydic.order.busi.goods.PebExtCreateComparisonGoodsBusiService;
import com.tydic.order.extend.dao.ComparisonGoodsMapper;
import com.tydic.order.extend.dao.po.ComparisonGoodsPO;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.order.third.intf.ability.usc.PebIntfAddComparisonGoodsNoAbilityService;
import com.tydic.order.third.intf.bo.usc.AddComparisonGoodsNoReqBO;
import com.tydic.order.third.intf.bo.usc.AddComparisonGoodsNoRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtCreateComparisonGoodsBusiServiceImpl
implements PebExtCreateComparisonGoodsBusiService {
    @Autowired
    private ComparisonGoodsMapper comparisonGoodsMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private PebIntfAddComparisonGoodsNoAbilityService pebIntfAddComparisonGoodsNoAbilityService;

    public PebExtCreateComparisonGoodsRspBO dealComparisonGoods(PebExtCreateComparisonGoodsReqBO reqBO) {
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsInfo())) {
            Long orderId = this.idUtil.nextId();
            String no = this.biuldNo("", "BJ-");
            ArrayList<ComparisonGoodsPO> list = new ArrayList<ComparisonGoodsPO>();
            for (UocComparisonGoodsBO uocComparisonGoodsBO : reqBO.getGoodsInfo()) {
                ComparisonGoodsPO goodsPO = new ComparisonGoodsPO();
                BeanUtils.copyProperties((Object)uocComparisonGoodsBO, (Object)goodsPO);
                if (null != uocComparisonGoodsBO.getSkuSalePrice()) {
                    try {
                        goodsPO.setSkuSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)uocComparisonGoodsBO.getSkuSalePrice()));
                    }
                    catch (Exception e) {
                        throw new UocProBusinessException("8888", "\u6bd4\u9009\u5355\u65b0\u589e\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
                    }
                } else {
                    goodsPO.setSkuSalePrice(Long.valueOf(0L));
                }
                goodsPO.setComparisonGoodsNo(no);
                goodsPO.setOrderId(orderId);
                goodsPO.setId(Long.valueOf(this.idUtil.nextId()));
                goodsPO.setCreateTime(new Date());
                goodsPO.setUserId(reqBO.getUserId());
                goodsPO.setName(reqBO.getUsername());
                goodsPO.setOrgId(reqBO.getOrgId());
                goodsPO.setOrgName(reqBO.getName());
                if (StringUtils.isNotBlank((CharSequence)goodsPO.getCartId())) {
                    AddComparisonGoodsNoReqBO goodsNoReqBO = new AddComparisonGoodsNoReqBO();
                    goodsNoReqBO.setComparisonGoodsNo(no);
                    goodsNoReqBO.setMemberId(String.valueOf(reqBO.getUserId()));
                    goodsNoReqBO.setSpId(Long.valueOf(uocComparisonGoodsBO.getCartId()));
                    AddComparisonGoodsNoRspBO goodsNoRspBO = this.pebIntfAddComparisonGoodsNoAbilityService.addComparisonGoodsNo(goodsNoReqBO);
                    if (!"0000".equals(goodsNoRspBO.getRespCode())) {
                        throw new UocProBusinessException("8888", goodsNoRspBO.getRespDesc());
                    }
                }
                list.add(goodsPO);
            }
            this.comparisonGoodsMapper.insertBatch(list);
        }
        PebExtCreateComparisonGoodsRspBO rspBO = new PebExtCreateComparisonGoodsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildGoodPO(PebExtCreateComparisonGoodsReqBO reqBO, BigDecimal skuSalePrice, Long orderId, String no, ComparisonGoodsPO goodsPO) {
        if (null != skuSalePrice) {
            try {
                goodsPO.setSkuSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)skuSalePrice));
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u6bd4\u9009\u5355\u65b0\u589e\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
        } else {
            goodsPO.setSkuSalePrice(Long.valueOf(0L));
        }
        goodsPO.setComparisonGoodsNo(no);
        goodsPO.setOrderId(orderId);
        goodsPO.setId(Long.valueOf(this.idUtil.nextId()));
        goodsPO.setCreateTime(new Date());
        goodsPO.setUserId(reqBO.getUserId());
        goodsPO.setName(reqBO.getUsername());
        goodsPO.setOrgId(reqBO.getOrgId());
        goodsPO.setOrgName(reqBO.getName());
    }

    private void buildChildComparisonOrder(PebExtCreateComparisonGoodsReqBO reqBO, List<ComparisonGoodsPO> list, UocComparisonGoodsListBO origin, Long orderId, String no) {
        if (CollectionUtils.isNotEmpty((Collection)origin.getGoodsInfo())) {
            List goodsInfo = origin.getGoodsInfo();
            goodsInfo.forEach(goods -> {
                ComparisonGoodsPO goodsPO = new ComparisonGoodsPO();
                BeanUtils.copyProperties((Object)goods, (Object)goodsPO);
                this.buildGoodPO(reqBO, goods.getSkuSalePrice(), orderId, no, goodsPO);
                list.add(goodsPO);
            });
        }
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        ComparisonGoodsPO cancelPO = new ComparisonGoodsPO();
        cancelPO.setComparisonGoodsNo(no);
        int count = this.comparisonGoodsMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

