/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.notify;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.order.bo.notify.UocSendMessageReqBO;
import com.tydic.order.bo.notify.UocSendMessageRspBO;
import com.tydic.order.bo.order.UocPebApprovalTaskQueryBO;
import com.tydic.order.busi.notify.UocSendMessageBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.third.intf.ability.authority.PebIntfSelectUserByStationWebService;
import com.tydic.order.third.intf.ability.umc.PebIntfMemDetailQueryAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfQrySupMemListAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfQrySupplierInfoListAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfSelectUserByRoleIdAndOrgIdAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfThirdBindQryListPageAbilityService;
import com.tydic.order.third.intf.bo.authority.QryUserByStationWebReqBO;
import com.tydic.order.third.intf.bo.authority.QryUserByStationWebRspBO;
import com.tydic.order.third.intf.bo.authority.QryUserInfoWebRspBO;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindReqBO;
import com.tydic.order.third.intf.bo.notify.PebTheOrderRemindRspBO;
import com.tydic.order.third.intf.bo.umc.MemDetailInfoBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryReqBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryRspBO;
import com.tydic.order.third.intf.bo.umc.PebIntfUserInfoListReqBO;
import com.tydic.order.third.intf.bo.umc.PebIntfUserInfoListRspBO;
import com.tydic.order.third.intf.bo.umc.QrySupMemListReqBO;
import com.tydic.order.third.intf.bo.umc.QrySupMemListRspBO;
import com.tydic.order.third.intf.bo.umc.QrySupplierInfoListReqBO;
import com.tydic.order.third.intf.bo.umc.QrySupplierInfoListRspBO;
import com.tydic.order.third.intf.bo.umc.SupplierInfoBO;
import com.tydic.order.third.intf.bo.umc.SupplierMemBO;
import com.tydic.order.third.intf.bo.umc.ThirdBindBO;
import com.tydic.order.third.intf.bo.umc.ThirdBindQryListPageAbilityReqBO;
import com.tydic.order.third.intf.bo.umc.ThirdBindQryListPageAbilityRspBO;
import com.tydic.order.third.intf.bo.umc.UserBO;
import com.tydic.order.third.intf.busi.notify.PebTheOrderRemindBusiService;
import com.tydic.order.third.intf.constant.ThirdApiCommonConstant;
import com.tydic.order.uoc.dao.OrdConfNotifyMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.OrdTaskCandidateMapper;
import com.tydic.order.uoc.dao.OrderMapper;
import com.tydic.order.uoc.dao.po.OrdConfNotifyPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.dao.po.OrdTaskCandidatePO;
import com.tydic.order.uoc.dao.po.OrderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocSendMessageBusiServiceImpl
implements UocSendMessageBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocSendMessageBusiServiceImpl.class);
    @Autowired
    private PebTheOrderRemindBusiService pebTheOrderRemindBusiService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebIntfQrySupplierInfoListAbilityService pebIntfQrySupplierInfoListAbilityService;
    @Autowired
    private PebIntfQrySupMemListAbilityService pebIntfQrySupMemListAbilityService;
    @Value(value="${WX_TEMPLATE_ID:1}")
    private String templateId;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdTaskCandidateMapper ordTaskCandidateMapper;
    @Autowired
    private PebIntfSelectUserByRoleIdAndOrgIdAbilityService pebIntfSelectUserByRoleIdAndOrgIdService;
    @Autowired
    private PebIntfSelectUserByStationWebService selectUserByStationWebService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdConfNotifyMapper ordConfNotifyMapper;
    @Autowired
    private PebIntfThirdBindQryListPageAbilityService pebIntfThirdBindQryListPageAbilityService;
    private static final int CPU = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService EXECUTORSERVICE = new ThreadPoolExecutor(CPU, 2 * CPU, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat("\u90ae\u4ef6\u901a\u77e5-notify-pool-%d").build(), new ThreadPoolExecutor.AbortPolicy());

    public UocSendMessageRspBO dealSendNotifyMessage(UocSendMessageReqBO reqBO) {
        UocSendMessageRspBO rspBO = new UocSendMessageRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<Object> ordConfNotifyList = new ArrayList();
        if (reqBO.isCheck()) {
            ordConfNotifyList = this.doGetConfigs(reqBO);
        } else {
            OrdConfNotifyPO ordConfNotify2 = (OrdConfNotifyPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getOrdNotifyConf()), OrdConfNotifyPO.class);
            ordConfNotifyList.add(ordConfNotify2);
        }
        if (CollectionUtils.isEmpty(ordConfNotifyList)) {
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPushTime())) {
            reqBO.setPushTime(DateUtils.dateToStr((Date)new Date()));
        }
        ordConfNotifyList.forEach(ordConfNotify -> {
            OrdSalePO ordSale = new OrdSalePO();
            ordSale.setSaleVoucherNo(reqBO.getSaleVoucherNo());
            ordSale.setOrderId(reqBO.getOrderId());
            ordSale = this.ordSaleMapper.getModelBy(ordSale);
            if (ordSale == null) {
                log.error("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)reqBO.getSaleVoucherNo());
                throw new UocProBusinessException("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a", reqBO.getSaleVoucherNo());
            }
            OrderPO order = this.orderMapper.getModelById(ordSale.getOrderId().longValue());
            if (order == null) {
                throw new UocProBusinessException("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a", ordSale.getSaleVoucherNo());
            }
            reqBO.setUserId(Long.valueOf(order.getCreateOperId()));
            reqBO.setSaleVoucherNo(ordSale.getSaleVoucherNo());
            reqBO.setOrderId(ordSale.getOrderId());
            List<MemDetailInfoBO> menList = this.getMemDetailInfo(reqBO, (OrdConfNotifyPO)ordConfNotify, ordSale);
            this.executeNotify(reqBO, (OrdConfNotifyPO)ordConfNotify, menList);
        });
        return rspBO;
    }

    private List<OrdConfNotifyPO> doGetConfigs(UocSendMessageReqBO reqBO) {
        OrdConfNotifyPO ordConfNotifyPO = new OrdConfNotifyPO();
        ordConfNotifyPO.setNotifyBusiness(reqBO.getNotifyBusiness());
        ordConfNotifyPO.setOrderType(reqBO.getOrderType());
        ordConfNotifyPO.setNotifyType(reqBO.getNotifyType());
        ordConfNotifyPO.setState(Integer.valueOf(1));
        try {
            List ordConfNotifyPOS = this.ordConfNotifyMapper.queryAll(ordConfNotifyPO, new Page());
            log.debug("\u67e5\u8be2\u901a\u77e5\u914d\u7f6e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)ordConfNotifyPOS));
            if (CollectionUtils.isEmpty((Collection)ordConfNotifyPOS)) {
                log.info("\u672a\u67e5\u8be2\u5230\u901a\u77e5\u914d\u7f6e\u4fe1\u606f");
            }
            return ordConfNotifyPOS;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u901a\u77e5\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return new ArrayList<OrdConfNotifyPO>();
        }
    }

    private List<MemDetailInfoBO> getMemDetailInfo(UocSendMessageReqBO reqBO, OrdConfNotifyPO ordConfNotify, OrdSalePO ordSalePO) {
        ArrayList<MemDetailInfoBO> menList = new ArrayList<MemDetailInfoBO>();
        if (StringUtils.isNotBlank((CharSequence)ordConfNotify.getReceiveRole())) {
            String[] split;
            String receiveRole = ordConfNotify.getReceiveRole();
            for (String s : split = receiveRole.split(",")) {
                Long supplierOrderAdminRoleId;
                Integer value = Integer.valueOf(s);
                if (value.equals(UocConstant.NOTIFY_RECEIVE_ROLE.CGY)) {
                    menList.addAll(this.doGetMemInfo(reqBO.getUserId()));
                    continue;
                }
                if (value.equals(UocConstant.NOTIFY_RECEIVE_ROLE.CGF_BMSP)) {
                    List<UocPebApprovalTaskQueryBO> approverList = this.getTaskOperId(reqBO.getOrderId());
                    ArrayList ids = new ArrayList();
                    approverList.forEach(id -> ids.add(Long.valueOf(id.getTaskOperId())));
                    OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
                    if (stakeholderPO == null) {
                        log.error("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7684\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)reqBO.getOrderId());
                        continue;
                    }
                    QryUserByStationWebReqBO qryUserByStationWebReqBO = new QryUserByStationWebReqBO();
                    ArrayList<Long> ordIds = new ArrayList<Long>();
                    ordIds.add(Long.valueOf(stakeholderPO.getPurNo()));
                    qryUserByStationWebReqBO.setOrgIds(ordIds);
                    qryUserByStationWebReqBO.setStationIds(ids);
                    try {
                        QryUserByStationWebRspBO selectUserByStationWebRspBO = this.selectUserByStationWebService.selectUserBy(qryUserByStationWebReqBO);
                        if (!CollectionUtils.isNotEmpty((Collection)selectUserByStationWebRspBO.getStationUsers())) continue;
                        selectUserByStationWebRspBO.getStationUsers().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<QryUserInfoWebRspBO>(Comparator.comparing(QryUserInfoWebRspBO::getUserId))), ArrayList::new)).forEach(user -> {
                            List<MemDetailInfoBO> approveList = this.doGetMemInfo(user.getUserId());
                            menList.addAll(approveList);
                        });
                    }
                    catch (Exception e) {
                        log.error("\u67e5\u8be2\u4f1a\u5458\u90e8\u95e8\u5ba1\u6279\u5c97\u4f4d\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                    }
                    continue;
                }
                if (value.equals(UocConstant.NOTIFY_RECEIVE_ROLE.CGF_QYSP)) {
                    Long enterpriseApprovalRoleId = 469954792539332608L;
                    this.getEnterpriseApproval(menList, ordSalePO, enterpriseApprovalRoleId);
                    continue;
                }
                if (value.equals(UocConstant.NOTIFY_RECEIVE_ROLE.GYS_DDGLY)) {
                    supplierOrderAdminRoleId = 434395663384109056L;
                    this.getSupplierRoleListInfo(ordSalePO, supplierOrderAdminRoleId, menList);
                    continue;
                }
                if (value.equals(UocConstant.NOTIFY_RECEIVE_ROLE.GYS_JSGLY)) {
                    supplierOrderAdminRoleId = 434396441209397248L;
                    this.getSupplierRoleListInfo(ordSalePO, supplierOrderAdminRoleId, menList);
                    continue;
                }
                if (!value.equals(UocConstant.NOTIFY_RECEIVE_ROLE.CGF_QYKGY)) continue;
                Long enterpriseAdminRoleId = 469955193753870336L;
                this.getEnterpriseApproval(menList, ordSalePO, enterpriseAdminRoleId);
            }
        }
        return menList;
    }

    private void getEnterpriseApproval(List<MemDetailInfoBO> menList, OrdSalePO ordSalePO, Long roleId) {
        try {
            PebIntfUserInfoListReqBO pebIntfUserInfoListReqBO = new PebIntfUserInfoListReqBO();
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
            if (stakeholderPO != null) {
                pebIntfUserInfoListReqBO.setOrgId(stakeholderPO.getCompanyId());
            } else {
                OrdExtMapPO comOrgId = new OrdExtMapPO();
                comOrgId.setFieldCode("companyId");
                comOrgId.setOrderId(ordSalePO.getOrderId());
                comOrgId.setObjId(ordSalePO.getSaleVoucherId());
                comOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
                OrdExtMapPO modelBy = this.ordExtMapMapper.getModelBy(comOrgId);
                if (modelBy != null) {
                    pebIntfUserInfoListReqBO.setOrgId(Long.valueOf(modelBy.getFieldValue()));
                } else {
                    log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u516c\u53f8\u673a\u6784id\uff0c\u8ba2\u5355id\uff1a{}", (Object)ordSalePO.getOrderId());
                    throw new ZTBusinessException("\u8ba2\u5355\u4e2d\u5fc3\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u516c\u53f8\u673a\u6784id");
                }
            }
            pebIntfUserInfoListReqBO.setRoleId(roleId);
            PebIntfUserInfoListRspBO pebIntfUserInfoListRspBO = this.pebIntfSelectUserByRoleIdAndOrgIdService.qryUserInfoList(pebIntfUserInfoListReqBO);
            if (!"0000".equals(pebIntfUserInfoListRspBO.getRespCode())) {
                log.error("\u67e5\u8be2\u91c7\u8d2d\u65b9\u4f01\u4e1a\u5ba1\u6279\u5c97\uff1a[{}]\u7684\u4f1a\u5458\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)roleId, (Object)pebIntfUserInfoListRspBO.getRespDesc());
            }
            if (CollectionUtils.isNotEmpty((Collection)pebIntfUserInfoListRspBO.getAllUser())) {
                pebIntfUserInfoListRspBO.getAllUser().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserBO>(Comparator.comparing(UserBO::getUserId))), ArrayList::new)).forEach(user -> {
                    List<MemDetailInfoBO> approveList = this.doGetMemInfo(user.getUserId());
                    menList.addAll(approveList);
                });
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u91c7\u8d2d\u65b9\u4f01\u4e1a\u5ba1\u6279\u5c97\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    private void executeNotify(UocSendMessageReqBO reqBO, OrdConfNotifyPO ordConfNotifyPO, List<MemDetailInfoBO> menList) {
        if (StringUtils.isNotBlank((CharSequence)ordConfNotifyPO.getNotifyWay())) {
            String[] split;
            String notifyWay = ordConfNotifyPO.getNotifyWay();
            for (String s : split = notifyWay.split(",")) {
                Integer value = Integer.valueOf(s);
                if (UocConstant.NOTIFY_WAY.ORDER_NOTIFY_MOBILE.equals(value)) {
                    this.doSendMobilMsg(reqBO, menList, ordConfNotifyPO);
                    continue;
                }
                if (UocConstant.NOTIFY_WAY.ORDER_NOTIFY_WX.equals(value)) {
                    this.doSendWX(reqBO, menList, ordConfNotifyPO);
                    continue;
                }
                if (UocConstant.NOTIFY_WAY.ORDER_NOTIFY_EMIL.equals(value)) {
                    try {
                        CompletableFuture.runAsync(() -> {
                            log.debug("\u6dfb\u52a0\u53d1\u9001\u90ae\u4ef6\u4efb\u52a1\u6210\u529f");
                            this.doSendEmailMsg(reqBO, menList, ordConfNotifyPO);
                        }, EXECUTORSERVICE);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001\u90ae\u4ef6\u63d0\u4ea4\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
                    }
                    continue;
                }
                if (UocConstant.NOTIFY_WAY.ORDER_NOTIFY_MESSAGE.equals(value)) {
                    this.doSendSiteMsg(reqBO, menList, ordConfNotifyPO);
                    continue;
                }
                log.info("\u53d1\u9001\u9489\u9489\u529f\u80fd\u6682\u672a\u5b9e\u73b0");
            }
        }
    }

    private List<UocPebApprovalTaskQueryBO> getTaskOperId(Long orderId) {
        OrdTaskCandidatePO taskCandidatePO = new OrdTaskCandidatePO();
        taskCandidatePO.setOrderId(orderId);
        taskCandidatePO.setObjType(Collections.singletonList(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007));
        List<Integer> state = Collections.singletonList(UocConstant.TASK_STATE.UNPROCESS);
        taskCandidatePO.setTaskState(state);
        return this.ordTaskCandidateMapper.getTaskOperIdList(taskCandidatePO);
    }

    private void getSupplierRoleListInfo(OrdSalePO ordSalePO, Long supplierOrderAdminRoleId, List<MemDetailInfoBO> menList) {
        try {
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
            if (stakeholderPO == null) {
                log.error("\u8ba2\u5355\u4e2d\u5fc3\u672a\u67e5\u8be2\u5230\u8ba2\u5355[{}]\u7684\u4f9b\u5e94\u5546\u4fe1\u606f", (Object)ordSalePO.getOrderId());
                throw new ZTBusinessException("\u8ba2\u5355\u4e2d\u5fc3\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u7684\u4fe1\u606f");
            }
            QrySupplierInfoListReqBO supplierInfoDetail = new QrySupplierInfoListReqBO();
            supplierInfoDetail.setSupplierIds(Collections.singletonList(Long.valueOf(stakeholderPO.getSupNo())));
            QrySupplierInfoListRspBO supplierInfoList = this.pebIntfQrySupplierInfoListAbilityService.qrySupplierInfoList(supplierInfoDetail);
            if (!"0000".equals(supplierInfoList.getRespCode())) {
                log.error("\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\uff1a[{}]\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)stakeholderPO.getSupNo(), (Object)supplierInfoList.getRespDesc());
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\u4f9b\u5e94\u5546\u7684\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
            }
            log.debug("\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\uff1a\u4f9b\u5e94\u5546\u8be6\u60c5\u51fa\u53c2\uff1a{}", JSON.toJSON((Object)supplierInfoList));
            QrySupMemListReqBO umcQrySupMem = new QrySupMemListReqBO();
            umcQrySupMem.setOrgId(((SupplierInfoBO)supplierInfoList.getRows().get(0)).getOrgCode());
            QrySupMemListRspBO supMemListRsp = this.pebIntfQrySupMemListAbilityService.qrySupplierMem(umcQrySupMem);
            if (!"0000".equals(supMemListRsp.getRespCode())) {
                log.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\uff1a[{}]\u7684\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)((SupplierInfoBO)supplierInfoList.getRows().get(0)).getOrgCode(), (Object)supMemListRsp.getRespDesc());
                throw new UocProBusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u670d\u52a1\u67e5\u8be2\u4f9b\u5e94\u5546\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
            }
            if (CollectionUtils.isNotEmpty((Collection)supMemListRsp.getRows())) {
                List rows = supMemListRsp.getRows();
                rows.stream().filter(stopState -> "01".equals(stopState.getStopStatus())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SupplierMemBO>(Comparator.comparing(SupplierMemBO::getUserId))), ArrayList::new)).forEach(umc -> {
                    if (CollectionUtils.isNotEmpty((Collection)umc.getUmcRoleBOS())) {
                        umc.getUmcRoleBOS().forEach(role -> {
                            if (supplierOrderAdminRoleId.equals(role.getRoleId())) {
                                menList.addAll(this.doGetMemInfo(umc.getUserId()));
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4f9b\u5e94\u5546\u4fa7\u89d2\u8272\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    private List<MemDetailInfoBO> doGetMemInfo(Long userId) {
        ArrayList<MemDetailInfoBO> memInfoList = new ArrayList<MemDetailInfoBO>();
        MemDetailQueryReqBO memDetailReq = new MemDetailQueryReqBO();
        memDetailReq.setUserIdWeb(userId);
        log.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)memDetailReq));
        try {
            MemDetailQueryRspBO memDetailRsp = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(memDetailReq);
            log.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}" + JSON.toJSONString((Object)memDetailRsp));
            if (!"0000".equals(memDetailRsp.getRespCode())) {
                log.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)memDetailRsp.getRespDesc());
                throw new UocProBusinessException("8888", memDetailRsp.getRespDesc());
            }
            if (memDetailRsp.getUmcMemDetailInfoAbilityRspBO() == null) {
                log.debug("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u65e0\u6570\u636e\u8fd4\u56de");
                throw new UocProBusinessException("8888", "\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u65e0\u6570\u636e\u8fd4\u56de");
            }
            memInfoList.add(memDetailRsp.getUmcMemDetailInfoAbilityRspBO());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u5458\u8be6\u60c5\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        return memInfoList;
    }

    private void doSendSiteMsg(UocSendMessageReqBO reqBO, List<MemDetailInfoBO> menList, OrdConfNotifyPO ordConfNotifyPO) {
        try {
            String title = ordConfNotifyPO.getNotifyName();
            String text = ordConfNotifyPO.getContent() + reqBO.getSaleVoucherNo() + " \u4e1a\u52a1\u65e5\u671f\uff1a" + reqBO.getPushTime();
            for (MemDetailInfoBO memBO : menList) {
                PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
                pebTheOrderRemindReqBO.setUserId(reqBO.getUserId());
                pebTheOrderRemindReqBO.setReceiveId(memBO.getUserId());
                pebTheOrderRemindReqBO.setTitel(title);
                pebTheOrderRemindReqBO.setText(text);
                pebTheOrderRemindReqBO.setToken(reqBO.getToken());
                pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_MESSAGE);
                PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
                if ("0000".equals(pebTheOrderRemindRspBO.getRespCode())) {
                    log.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u6210\u529f");
                    continue;
                }
                log.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)pebTheOrderRemindRspBO.getRespDesc());
                throw new UocProBusinessException("8888", pebTheOrderRemindRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    private void doSendEmailMsg(UocSendMessageReqBO reqBO, List<MemDetailInfoBO> menList, OrdConfNotifyPO ordConfNotifyPO) {
        try {
            String title = ordConfNotifyPO.getNotifyName();
            String text = ordConfNotifyPO.getContent() + reqBO.getSaleVoucherNo() + " \u4e1a\u52a1\u65e5\u671f\uff1a" + reqBO.getPushTime();
            for (MemDetailInfoBO memBO : menList) {
                PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
                pebTheOrderRemindReqBO.setSubject(title);
                pebTheOrderRemindReqBO.setText(text);
                if (!StringUtils.isNotBlank((CharSequence)memBO.getRegEmail())) continue;
                pebTheOrderRemindReqBO.setEmail(memBO.getRegEmail());
                pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_EMIL);
                PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
                if ("0000".equals(pebTheOrderRemindRspBO.getRespCode())) {
                    log.debug("\u53d1\u9001\u90ae\u4ef6\u6210\u529f");
                    continue;
                }
                log.debug("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)pebTheOrderRemindRspBO.getRespDesc());
                throw new UocProBusinessException("8888", pebTheOrderRemindRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    private void doSendMobilMsg(UocSendMessageReqBO reqBO, List<MemDetailInfoBO> menList, OrdConfNotifyPO ordConfNotify) {
        try {
            StringBuilder builder = new StringBuilder();
            for (MemDetailInfoBO memBO : menList) {
                if (!StringUtils.isNotBlank((CharSequence)memBO.getRegMobile())) continue;
                builder.append(memBO.getRegMobile()).append(",");
            }
            String text = ordConfNotify.getContent() + reqBO.getSaleVoucherNo() + " \u4e1a\u52a1\u65e5\u671f\uff1a" + reqBO.getPushTime();
            if (StringUtils.isBlank((CharSequence)builder.toString())) {
                throw new ZTBusinessException("\u53d1\u9001\u77ed\u4fe1\u624b\u673a\u53f7\u4e3a\u7a7a");
            }
            String mobile = builder.substring(0, builder.length() - 1);
            PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
            pebTheOrderRemindReqBO.setText(text);
            pebTheOrderRemindReqBO.setMobile(mobile);
            pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_MOBILE);
            for (int i = 1; i <= 3; ++i) {
                try {
                    PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
                    if (!"0000".equals(pebTheOrderRemindRspBO.getRespCode())) continue;
                    log.debug("\u53d1\u9001\u77ed\u4fe1\u6210\u529f");
                    break;
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\u7b2c{}\u6b21", (Object)i);
                    if (i != 3) continue;
                    throw new ZTBusinessException("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    private void doSendWX(UocSendMessageReqBO reqBO, List<MemDetailInfoBO> menList, OrdConfNotifyPO ordConfNotifyPO) {
        try {
            String title = ordConfNotifyPO.getNotifyName();
            String text = ordConfNotifyPO.getContent() + reqBO.getSaleVoucherNo() + " \u4e1a\u52a1\u65e5\u671f\uff1a" + reqBO.getPushTime();
            for (MemDetailInfoBO memBO : menList) {
                PebTheOrderRemindReqBO pebTheOrderRemindReqBO = new PebTheOrderRemindReqBO();
                ThirdBindQryListPageAbilityReqBO thirdBindQryListPageAbilityReqBO = new ThirdBindQryListPageAbilityReqBO();
                thirdBindQryListPageAbilityReqBO.setMemId(memBO.getMemId());
                thirdBindQryListPageAbilityReqBO.setAuthType(Integer.valueOf(1));
                ThirdBindQryListPageAbilityRspBO qryThirdBind = this.pebIntfThirdBindQryListPageAbilityService.qryThirdBindListPage(thirdBindQryListPageAbilityReqBO);
                if (!"0000".equals(qryThirdBind.getRespCode())) {
                    log.debug("\u67e5\u8be2\u4f1a\u5458openId\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)qryThirdBind.getRespDesc());
                    throw new UocProBusinessException("8888", qryThirdBind.getRespDesc());
                }
                pebTheOrderRemindReqBO.setOpenId(((ThirdBindBO)qryThirdBind.getRows().get(0)).getAuthId());
                pebTheOrderRemindReqBO.setTitel(title);
                pebTheOrderRemindReqBO.setText(text);
                pebTheOrderRemindReqBO.setSendType(ThirdApiCommonConstant.ORDER_SEND_WX);
                pebTheOrderRemindReqBO.setTemplateIdWX(this.templateId);
                PebTheOrderRemindRspBO pebTheOrderRemindRspBO = this.pebTheOrderRemindBusiService.dealPebTheOrderRemind(pebTheOrderRemindReqBO);
                if ("0000".equals(pebTheOrderRemindRspBO.getRespCode())) {
                    log.debug("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u6210\u529f");
                    continue;
                }
                log.debug("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0:{}", (Object)pebTheOrderRemindRspBO.getRespDesc());
                throw new UocProBusinessException("8888", pebTheOrderRemindRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }
}

