/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.order;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.bo.pay.UocPayOrderReFundReqBO;
import com.tydic.order.bo.process.UocProcessRunReqBO;
import com.tydic.order.bo.process.UocProcessRunRspBO;
import com.tydic.order.busi.order.UocPebOrderCancelBusiService;
import com.tydic.order.busi.order.UocPebPreOrderSubmitBsuiService;
import com.tydic.order.busi.order.bo.UocPebOrderCancelReqBO;
import com.tydic.order.busi.order.bo.UocPebOrderCancelRspBO;
import com.tydic.order.busi.order.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.order.busi.order.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.order.busi.pay.UocPayOrderReFundBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.impl.atom.process.UocRunProcessAtomService;
import com.tydic.order.third.intf.ability.esb.order.PebIntfConfirmOrderAbilityService;
import com.tydic.order.third.intf.bo.esb.order.ConfirmOrderReqBO;
import com.tydic.order.third.intf.bo.esb.order.ConfirmOrderRspBO;
import com.tydic.order.uoc.dao.OrdCancelMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdQueryIndexMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdCancelPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdQueryIndexPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPebPreOrderSubmitBsuiServiceImpl
implements UocPebPreOrderSubmitBsuiService {
    private static Logger logger = LoggerFactory.getLogger(UocPebPreOrderSubmitBsuiServiceImpl.class);
    @Autowired
    private PebIntfConfirmOrderAbilityService pebIntfConfirmOrderAbilityService;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Value(value="${isActivationTemp}")
    private boolean isActivationTemp;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;

    public UocPebPreOrderSubmitRspBO submit(UocPebPreOrderSubmitReqBO reqBO) {
        UocPebPreOrderSubmitRspBO rspBO = new UocPebPreOrderSubmitRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ConfirmOrderReqBO confirmOrderReqBO = this.buildConfirmOrderParmByOrderId(reqBO);
        try {
            OrdExtMapPO mapPO = new OrdExtMapPO();
            mapPO.setOrderId(reqBO.getOrderId());
            mapPO.setFieldCode("jdOrgId");
            mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            mapPO = this.ordExtMapMapper.getModelBy(mapPO);
            if (mapPO != null) {
                confirmOrderReqBO.setOrgId(mapPO.getFieldValue());
            }
            ConfirmOrderRspBO confirmOrderRspBO = this.getConfirmOrder(confirmOrderReqBO);
            logger.debug("\u9884\u5b9a\u5355\u63d0\u4ea4" + JSON.toJSONString((Object)confirmOrderRspBO));
            if (!"0000".equals(confirmOrderRspBO.getRespCode()) || !confirmOrderRspBO.getResult().booleanValue()) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc(confirmOrderRspBO.getRespDesc());
                this.cancel(reqBO, confirmOrderRspBO.getRespDesc());
                UocPayOrderReFundReqBO uocPayOrderReFundReqBO = new UocPayOrderReFundReqBO();
                uocPayOrderReFundReqBO.setOperType("SUBMIT");
                uocPayOrderReFundReqBO.setOrderId(reqBO.getOrderId());
                this.uocPayOrderReFundBusiService.dealOrderReFund(uocPayOrderReFundReqBO);
                return rspBO;
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u9884\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1" + e.getMessage());
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u9884\u8ba2\u5355\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u5904\u7406\u6d41\u7a0b\u5931\u8d25");
        }
        return rspBO;
    }

    private ConfirmOrderRspBO getConfirmOrder(ConfirmOrderReqBO confirmOrderReqBO) {
        ConfirmOrderRspBO confirmOrderRspBO;
        if (this.isActivationTemp) {
            confirmOrderRspBO = new ConfirmOrderRspBO();
            confirmOrderRspBO.setResult(Boolean.valueOf(true));
            confirmOrderRspBO.setRespCode("0000");
            confirmOrderRspBO.setRespDesc("\u6210\u529f");
        } else {
            confirmOrderRspBO = this.pebIntfConfirmOrderAbilityService.confirmOrder(confirmOrderReqBO);
        }
        return confirmOrderRspBO;
    }

    private void cancel(UocPebPreOrderSubmitReqBO reqBO, String desc) {
        UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
        cancelReqBO.setOrderId(reqBO.getOrderId());
        cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        cancelReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
        cancelReqBO.setIsCancelWF(Boolean.valueOf(false));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approvalResult", "0");
        cancelReqBO.setCancelDesc("\u7535\u5546\u9884\u8ba2\u5355\u786e\u8ba4\u5931\u8d25\uff1a" + desc);
        cancelReqBO.setCancelReason("\u7535\u5546\u9884\u8ba2\u5355\u786e\u8ba4\u5931\u8d25\uff1a" + desc);
        cancelReqBO.setVariables(map);
        UocPebOrderCancelRspBO rspBO = this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u8ba2\u5355\u53d6\u6d88\u5931\u8d25" + rspBO.getRespDesc());
        }
        this.save(cancelReqBO);
    }

    private void save(UocPebOrderCancelReqBO reqBO) {
        try {
            OrdCancelPO cancelPO = new OrdCancelPO();
            cancelPO.setCancelNo(this.biuldNo("", "QXSQ"));
            cancelPO.setCancelReason(reqBO.getCancelDesc());
            cancelPO.setOrderId(reqBO.getOrderId());
            cancelPO.setSaleVoucherId(reqBO.getSaleVoucherId());
            cancelPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            cancelPO.setCreateOperName(reqBO.getUsername());
            cancelPO.setCreateTime(new Date());
            cancelPO.setOrderStatus(UocConstant.SALE_ORDER_STATUS.CREATE);
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_SUCCESS);
            this.ordCancelMapper.insert(cancelPO);
        }
        catch (Exception ignored) {
            logger.error("\u67e5\u8be2\u53d6\u6d88\u539f\u56e0\u5931\u8d25!!");
        }
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdCancelPO cancelPO = new OrdCancelPO();
        cancelPO.setCancelNo(no);
        int count = this.ordCancelMapper.getCheckBy(cancelPO);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }

    private ConfirmOrderReqBO buildConfirmOrderParmByOrderId(UocPebPreOrderSubmitReqBO reqBO) {
        OrdStakeholderPO stakeholderPO = new OrdStakeholderPO();
        stakeholderPO.setOrderId(reqBO.getOrderId());
        try {
            stakeholderPO = this.ordStakeholderMapper.getModelBy(stakeholderPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u4e09\u65b9\u8868\u5931\u8d25");
        }
        ConfirmOrderReqBO confirmOrderReqBO = new ConfirmOrderReqBO();
        confirmOrderReqBO.setSupplierId(Long.valueOf(stakeholderPO.getSupNo()));
        OrdQueryIndexPO ordQueryIndexModel = new OrdQueryIndexPO();
        ordQueryIndexModel.setOrderId(reqBO.getOrderId());
        OrdQueryIndexPO result = null;
        try {
            result = this.ordQueryIndexMapper.getModelBy(ordQueryIndexModel);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5185\u5916\u90e8\u8ba2\u5355\u5173\u8054\u8868\u5931\u8d25");
        }
        if (result == null) {
            throw new UocProBusinessException("10000", "\u6ca1\u6709\u67e5\u8be2\u5230\u5185\u5916\u90e8\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
        }
        confirmOrderReqBO.setOrderId(result.getOutOrderNo());
        return confirmOrderReqBO;
    }
}

