/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.others;

import com.tydic.order.ability.bo.PebDealOrderBO;
import com.tydic.order.busi.other.PebUpdateSaleStatusBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.UocOrdPayConfMapper;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.UocOrdPayConfPO;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebUpdateSaleStatusBusiServiceImpl
implements PebUpdateSaleStatusBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdPayConfMapper uocOrdPayConfMapper;

    public void dealUpdate(PebDealOrderBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleState(UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER);
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        this.ordSaleMapper.updateById(ordSalePO);
    }

    public void updatePayConfig(PebDealOrderBO reqBO) {
        UocOrdPayConfPO uocOrdPayConfPO = new UocOrdPayConfPO();
        uocOrdPayConfPO.setOrderId(reqBO.getPorderId());
        List list = this.uocOrdPayConfMapper.selectByCondition(uocOrdPayConfPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        uocOrdPayConfPO = (UocOrdPayConfPO)list.get(0);
        if (uocOrdPayConfPO.getPrePayFee() == null || uocOrdPayConfPO.getPrePayFee() == 0L) {
            return;
        }
        UocOrdPayConfPO confPO = new UocOrdPayConfPO();
        confPO.setOrderId(reqBO.getPorderId());
        List childs = this.uocOrdPayConfMapper.selectByPorder(confPO);
        if (CollectionUtils.isEmpty((Collection)childs)) {
            return;
        }
        long total = 0L;
        for (UocOrdPayConfPO payConfPO : childs) {
            if (UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(payConfPO.getSaleState()) || payConfPO.getPrePayFee() == null || payConfPO.getPrePayFee() == 0L) continue;
            if (total + payConfPO.getPrePayFee() > uocOrdPayConfPO.getPrePayFee()) {
                UocOrdPayConfPO update = new UocOrdPayConfPO();
                update.setPrePayFee(Long.valueOf(uocOrdPayConfPO.getPrePayFee() - total));
                update.setId(payConfPO.getId());
                update.setOrderId(payConfPO.getOrderId());
                this.uocOrdPayConfMapper.update(update);
                break;
            }
            total += payConfPO.getPrePayFee().longValue();
        }
    }
}

