/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.plan;

import com.tydic.order.bo.PebExtExecuteSyncPlanReqBO;
import com.tydic.order.bo.PebExtExecuteSyncPlanRspBO;
import com.tydic.order.bo.plan.PebExtPlanBO;
import com.tydic.order.bo.plan.PebExtPlanDetailQueryQueryReqBO;
import com.tydic.order.bo.plan.PebExtPlanDetailQueryQueryRspBO;
import com.tydic.order.bo.plan.PebExtPlanreturnReqBO;
import com.tydic.order.bo.plan.PebExtPlanreturnRspBO;
import com.tydic.order.busi.PebExtExecuteSyncPlanBusiService;
import com.tydic.order.busi.plan.PebExtPlanDetailQueryBusiService;
import com.tydic.order.busi.plan.PebExtPlanreturnBusiService;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.order.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.dic.bo.SelectSingleDictRspBO;
import com.tydic.order.extend.dao.OrdEcpPlanMapper;
import com.tydic.order.extend.dao.OrdServMapper;
import com.tydic.order.extend.dao.po.OrdEcpPlanPO;
import com.tydic.order.third.intf.ability.esb.ecp.PebIntfCancelPurchaseOrderAbilityService;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCancelPurchaseOrderAbilityReqBo;
import com.tydic.order.third.intf.bo.esb.ecp.PebIntfCancelPurchaseOrderAbilityRspBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebExtPlanreturnBusiService")
public class PebExtPlanreturnBusiServiceImpl
implements PebExtPlanreturnBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPlanreturnBusiServiceImpl.class);
    @Autowired
    private PebIntfCancelPurchaseOrderAbilityService pebIntfCancelPurchaseOrderAbilityService;
    @Autowired
    private OrdEcpPlanMapper ordEcpPlanMapper;
    @Autowired
    private OrdServMapper ordServMapper;
    @Autowired
    private PebExtExecuteSyncPlanBusiService pebExtExecuteSyncPlanBusiService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private PebExtPlanDetailQueryBusiService pebExtPlanDetailQueryBusiService;

    public PebExtPlanreturnRspBO dealPlanReturn(PebExtPlanreturnReqBO reqBO) {
        PebExtPlanreturnRspBO retBo = new PebExtPlanreturnRspBO();
        PebExtPlanBO planInfo = this.checkStatus(reqBO);
        this.updateStatus(reqBO);
        this.callEcb(reqBO, planInfo.getZxlsjhbh());
        this.syncPlanInfo(planInfo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void callEcb(PebExtPlanreturnReqBO reqBO, String projectNumber) {
        PebIntfCancelPurchaseOrderAbilityReqBo callEcbReqBo = new PebIntfCancelPurchaseOrderAbilityReqBo();
        callEcbReqBo.setXTBS("DZSC");
        callEcbReqBo.setJKBS("DZSC_JHJK");
        callEcbReqBo.setYWBH(projectNumber);
        callEcbReqBo.setCZBS("TH");
        callEcbReqBo.setCZSJ(new DateTime((Object)new Date()).toString("yyyy-MM-dd HH:mm:ss"));
        PebIntfCancelPurchaseOrderAbilityRspBo callEcbRetBo = this.pebIntfCancelPurchaseOrderAbilityService.cancelPurchaseOrder(callEcbReqBo);
        if (!"0000".equals(callEcbRetBo.getRespCode())) {
            String returnMsg = StringUtils.isEmpty((Object)callEcbRetBo.getMsg()) ? callEcbRetBo.getRespDesc() : callEcbRetBo.getMsg();
            throw new UocProBusinessException("0100", "\u8c03\u7528ECP\u5931\u8d25\uff1a" + returnMsg);
        }
    }

    private void updateStatus(PebExtPlanreturnReqBO reqBO) {
        OrdEcpPlanPO updatePlanStatusPo = new OrdEcpPlanPO();
        updatePlanStatusPo.setPlanId(reqBO.getPlanId());
        updatePlanStatusPo.setOrderId(reqBO.getOrderId());
        updatePlanStatusPo.setReturnOperId(String.valueOf(reqBO.getUserId()));
        updatePlanStatusPo.setReturnOperName(reqBO.getName());
        updatePlanStatusPo.setStatus(PebExtConstant.PlanStatus.RETURN);
        updatePlanStatusPo.setStatusStr(this.getPlanStatusStr(PebExtConstant.PlanStatus.RETURN));
        updatePlanStatusPo.setUpdateTime(this.ordServMapper.getDbDate());
        int result = this.ordEcpPlanMapper.updateById(updatePlanStatusPo);
        if (result < 1) {
            throw new UocProBusinessException("0100", "\u66f4\u65b0\u8ba1\u5212\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String getPlanStatusStr(Integer status) {
        SelectSingleDictReqBO dicReqBo = new SelectSingleDictReqBO();
        dicReqBo.setCode(status.toString());
        dicReqBo.setPcode("CNNC_PLAN_STATUS");
        SelectSingleDictRspBO dicRetBo = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dicReqBo);
        if (!"0000".equals(dicRetBo.getRespCode())) {
            throw new UocProBusinessException("0002", "\u6267\u884c\u72b6\u6001\u66f4\u65b0\u65f6\uff0c\u72b6\u6001\u503c(status= " + status + ")\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8ba1\u5212\u72b6\u6001\u5e94\u4e3a:1700\uff08\u672a\u6267\u884c\uff09\uff0c1701\uff08\u6267\u884c\u4e2d\uff09\uff0c1702\uff08\u5df2\u9000\u56de\uff09\uff0c1703\uff08\u5df2\u5b8c\u7ed3\uff09");
        }
        return dicRetBo.getDicDictionarys().getDescrip();
    }

    private PebExtPlanBO checkStatus(PebExtPlanreturnReqBO reqBO) {
        PebExtPlanDetailQueryQueryReqBO queryReqBo = new PebExtPlanDetailQueryQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryReqBo);
        queryReqBo.setQryItem(Integer.valueOf(0));
        PebExtPlanDetailQueryQueryRspBO queryRetBo = this.pebExtPlanDetailQueryBusiService.getPebExtPlanDetailQuery(queryReqBo);
        PebExtPlanBO planBo = queryRetBo.getOrdPlanRspBO();
        if (null == planBo) {
            throw new UocProBusinessException("0200", "\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u4fe1\u606f\uff1a" + reqBO);
        }
        if (!PebExtConstant.PlanStatus.TODO.equals(queryRetBo.getOrdPlanRspBO().getStatus())) {
            throw new UocProBusinessException("0200", "\u8ba1\u5212\u5355\u72b6\u6001\u975e\u5f85\u6267\u884c\uff0c\u4e0d\u53ef\u6267\u884c\u9000\u56de\u64cd\u4f5c");
        }
        return planBo;
    }

    private void syncPlanInfo(PebExtPlanBO planBo) {
        PebExtExecuteSyncPlanReqBO syncPlanReqBo = new PebExtExecuteSyncPlanReqBO();
        BeanUtils.copyProperties((Object)planBo, (Object)syncPlanReqBo);
        PebExtExecuteSyncPlanRspBO syncPlanRetBo = new PebExtExecuteSyncPlanRspBO();
        try {
            syncPlanRetBo = this.pebExtExecuteSyncPlanBusiService.executeSync(syncPlanReqBo);
        }
        catch (Exception e) {
            throw new UocProBusinessException("0100", "\u540c\u6b65ES\u6570\u636e\u5931\u8d25\uff0c\u5165\u53c2\uff1a" + syncPlanRetBo.getRespDesc());
        }
    }
}

