/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.plan;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.tydic.order.bo.other.UocCoreCommCreateIntfLogReqBO;
import com.tydic.order.busi.plan.UocCallPlanCenterBusiService;
import com.tydic.order.busi.plan.bo.UocCallPlanCenterBusiServiceItemBo;
import com.tydic.order.busi.plan.bo.UocCallPlanCenterBusiServiceReqBo;
import com.tydic.order.busi.plan.bo.UocCallPlanCenterBusiServiceRspBo;
import com.tydic.order.impl.atom.other.UocPebCommCreateIntfLogAtomService;
import com.tydic.order.impl.utils.UocMoneyUtil;
import com.tydic.order.third.intf.impl.atom.mock.UocProMockConfigQryAtomService;
import com.tydic.order.third.intf.impl.atom.mock.UocProMockSwitch;
import com.tydic.order.third.intf.impl.atom.mock.UocProRpcMockAtomService;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.ppc.ability.api.PpcOrderFeedbackAbilityService;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityRspBO;
import com.tydic.ppc.ability.bo.purchasePlanSscBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocCallPlanCenterBusiServiceImpl
implements UocCallPlanCenterBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocCallPlanCenterBusiServiceImpl.class);
    @HSFConsumer(serviceVersion="2.1.0", serviceGroup="PLAN_GROUP_DEV")
    private PpcOrderFeedbackAbilityService ppcOrderFeedbackAbilityService;
    @Autowired
    private UocPebCommCreateIntfLogAtomService uocPebCommCreateIntfLogAtomService;
    @Autowired
    private UocProMockSwitch uocProMockSwitch;
    @Autowired
    private UocProMockConfigQryAtomService uocProMockConfigQryAtomService;
    @Autowired
    private UocProRpcMockAtomService uocProRpcMockAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    public UocCallPlanCenterBusiServiceRspBo updatePlanData(UocCallPlanCenterBusiServiceReqBo reqBo) {
        Long orderId = reqBo.getOrderId();
        Boolean reverse = reqBo.getDirection();
        this.validateArg(reqBo);
        OrdSalePO qryOrdSale = new OrdSalePO();
        qryOrdSale.setOrderId(orderId);
        OrdSalePO ordSalePo = this.ordSaleMapper.getModelBy(qryOrdSale);
        if (ordSalePo == null) {
            throw new UocProBusinessException("0001", "\u8be5\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
        }
        List qryItem = null;
        Map<Object, Object> countMap = new HashMap();
        if (!ObjectUtil.isEmpty((Object)reqBo.getOrderItems())) {
            qryItem = reqBo.getOrderItems().stream().map(UocCallPlanCenterBusiServiceItemBo::getOrderItemId).collect(Collectors.toList());
            countMap = reqBo.getOrderItems().stream().collect(Collectors.toMap(UocCallPlanCenterBusiServiceItemBo::getOrderItemId, UocCallPlanCenterBusiServiceItemBo::getCount));
        }
        String saleVoucherNo = ordSalePo.getSaleVoucherNo();
        OrdItemPO qryOrdItemPo = new OrdItemPO();
        qryOrdItemPo.setOrderId(orderId);
        if (!ObjectUtil.isEmpty(qryItem)) {
            qryOrdItemPo.setOrdItemIdList(qryItem);
        }
        List itemList = this.ordItemMapper.getList(qryOrdItemPo);
        PpcOrderFeedbackAbilityReqBO feedbackReqBo = new PpcOrderFeedbackAbilityReqBO();
        ArrayList<purchasePlanSscBO> feedbackList = new ArrayList<purchasePlanSscBO>();
        feedbackReqBo.setPurchasePlanSscBOS(feedbackList);
        for (OrdItemPO ordItemPO : itemList) {
            if (ordItemPO.getPlanId() == null || ordItemPO.getPlanItemId() == null) continue;
            purchasePlanSscBO tmpBo = new purchasePlanSscBO();
            feedbackList.add(tmpBo);
            tmpBo.setPurchasePlanId(ordItemPO.getPlanId());
            tmpBo.setPurchasePlanItemId(ordItemPO.getPlanItemId());
            tmpBo.setOrderId(orderId);
            tmpBo.setOrderCode(saleVoucherNo);
            if (!ObjectUtil.isEmpty(qryItem)) {
                if (reverse.booleanValue()) {
                    tmpBo.setPurchaserNumber((BigDecimal)countMap.get(ordItemPO.getOrdItemId()));
                } else {
                    tmpBo.setPurchaserNumber(((BigDecimal)countMap.get(ordItemPO.getOrdItemId())).negate());
                }
                try {
                    if (reverse.booleanValue()) {
                        tmpBo.setAllPrice(UocMoneyUtil.Long2BigDecimal(ordItemPO.getSalePrice()).multiply((BigDecimal)countMap.get(ordItemPO.getOrdItemId())));
                        continue;
                    }
                    tmpBo.setAllPrice(UocMoneyUtil.Long2BigDecimal(ordItemPO.getSalePrice()).multiply((BigDecimal)countMap.get(ordItemPO.getOrdItemId())).negate());
                    continue;
                }
                catch (Exception e) {
                    throw new UocProBusinessException("0001", "Long2BigDecimal\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (reverse.booleanValue()) {
                tmpBo.setPurchaserNumber(ordItemPO.getPurchaseCount());
            } else {
                tmpBo.setPurchaserNumber(ordItemPO.getPurchaseCount().negate());
            }
            try {
                if (reverse.booleanValue()) {
                    tmpBo.setAllPrice(UocMoneyUtil.Long2BigDecimal(ordItemPO.getTotalSaleFee()));
                    continue;
                }
                tmpBo.setAllPrice(UocMoneyUtil.Long2BigDecimal(ordItemPO.getTotalSaleFee()).negate());
            }
            catch (Exception e) {
                throw new UocProBusinessException("0001", "Long2BigDecimal\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        if (feedbackList.size() > 0) {
            log.info("\u8c03\u7528\u8ba1\u5212\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)feedbackReqBo));
            UocCoreCommCreateIntfLogReqBO reqBoLog = new UocCoreCommCreateIntfLogReqBO();
            reqBoLog.setCallTime(new Date());
            PpcOrderFeedbackAbilityRspBO ppcOrderFeedbackAbilityRspBO = null;
            ppcOrderFeedbackAbilityRspBO = this.uocProMockSwitch.isPlan() ? this.ppcOrderFeedbackAbilityService.orderFeedback(feedbackReqBo) : (this.uocProMockSwitch.isPlanDb() ? (PpcOrderFeedbackAbilityRspBO)this.uocProMockConfigQryAtomService.qryMockData(PpcOrderFeedbackAbilityService.class.getName(), PpcOrderFeedbackAbilityRspBO.class) : (PpcOrderFeedbackAbilityRspBO)this.uocProRpcMockAtomService.rpcMockData(PpcOrderFeedbackAbilityService.class.getName(), "orderFeedback", (Object)feedbackReqBo, PpcOrderFeedbackAbilityRspBO.class));
            log.info("\u8c03\u7528\u8ba1\u5212\u4e2d\u5fc3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)ppcOrderFeedbackAbilityRspBO));
            reqBoLog.setOrderId(orderId);
            reqBoLog.setRetTime(new Date());
            reqBoLog.setCallstate(ordSalePo.getSaleState().toString());
            reqBoLog.setCreateLoginId("system");
            reqBoLog.setInContent(JSON.toJSONString((Object)feedbackReqBo));
            reqBoLog.setOutContent(JSON.toJSONString((Object)ppcOrderFeedbackAbilityRspBO));
            reqBoLog.setInterCode(PpcOrderFeedbackAbilityService.class.getSimpleName());
            this.uocPebCommCreateIntfLogAtomService.dealCommCreateIntfLog(reqBoLog);
            if (!"0000".equals(ppcOrderFeedbackAbilityRspBO.getRespCode())) {
                return (UocCallPlanCenterBusiServiceRspBo)UocProRspBoUtil.failed((String)ppcOrderFeedbackAbilityRspBO.getRespDesc(), UocCallPlanCenterBusiServiceRspBo.class);
            }
            return (UocCallPlanCenterBusiServiceRspBo)UocProRspBoUtil.success(UocCallPlanCenterBusiServiceRspBo.class);
        }
        log.info("\u8be5\u8ba2\u5355\uff08" + reqBo.getOrderId() + "\uff09\u65e0\u9700\u8c03\u7528\u8ba1\u5212\u4e2d");
        return (UocCallPlanCenterBusiServiceRspBo)UocProRspBoUtil.success(UocCallPlanCenterBusiServiceRspBo.class);
    }

    private void validateArg(UocCallPlanCenterBusiServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("0001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getDirection() == null) {
            throw new UocProBusinessException("0001", "direction\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderItems = reqBo.getOrderItems();
        if (!ObjectUtil.isEmpty((Object)orderItems)) {
            for (UocCallPlanCenterBusiServiceItemBo orderItem : orderItems) {
                if (orderItem == null) {
                    throw new UocProBusinessException("0001", "orderItems\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getOrderItemId() == null || orderItem.getOrderItemId() == 0L) {
                    throw new UocProBusinessException("0001", "orderItems\u4e2d\u5bf9\u8c61\u5c5e\u6027orderItemId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getCount() != null && !orderItem.getCount().equals(BigDecimal.ZERO)) continue;
                throw new UocProBusinessException("0001", "orderItems\u4e2d\u5bf9\u8c61\u5c5e\u6027count\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

