/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.order.bo.common.UocPebOrderCancellationReqBO;
import com.tydic.order.bo.common.UocPebOrderCancellationRspBO;
import com.tydic.order.bo.pay.UocPayOrderReFundReqBO;
import com.tydic.order.bo.pay.UocPayOrderReFundRspBO;
import com.tydic.order.bo.process.UocProcessRunReqBO;
import com.tydic.order.bo.process.UocProcessRunRspBO;
import com.tydic.order.bo.saleorder.PebExtApprovalCancelReqBO;
import com.tydic.order.bo.saleorder.PebExtApprovalCancelRspBO;
import com.tydic.order.busi.order.UocPebOrderCancelBusiService;
import com.tydic.order.busi.order.UocPebOrderCancellationBusiService;
import com.tydic.order.busi.order.bo.UocPebOrderCancelReqBO;
import com.tydic.order.busi.pay.UocPayOrderReFundBusiService;
import com.tydic.order.busi.saleorder.PebExtApprovalCancelBusiService;
import com.tydic.order.constant.PecConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.impl.atom.process.UocRunProcessAtomService;
import com.tydic.order.third.intf.ability.esb.order.PebIntfConfirmCancelOrderAbilityService;
import com.tydic.order.third.intf.bo.esb.order.PebIntfConfirmCancelOrderReqBO;
import com.tydic.order.third.intf.bo.esb.order.PebIntfConfirmCancelOrderRspBO;
import com.tydic.order.uoc.dao.OrdCancelMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdPayMapper;
import com.tydic.order.uoc.dao.OrdQueryIndexMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdCancelPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdPayPO;
import com.tydic.order.uoc.dao.po.OrdQueryIndexPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebExtApprovalCancelBusiServiceImpl
implements PebExtApprovalCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtApprovalCancelBusiServiceImpl.class);
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private PebIntfConfirmCancelOrderAbilityService pebIntfConfirmCancelOrderAbilityService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocPebOrderCancellationBusiService uocPebOrderCancellationBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private UocPayOrderReFundBusiService uocPayOrderReFundBusiService;
    private static final String REVOCATION = "1";

    public PebExtApprovalCancelRspBO dealApprovalCancelled(PebExtApprovalCancelReqBO reqBO) {
        PebExtApprovalCancelRspBO rspBO = new PebExtApprovalCancelRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdCancelPO cancelPO = this.ordCancelMapper.getModelById(reqBO.getCancelId().longValue());
        boolean finish = this.dealAudit(reqBO, cancelPO);
        if (!finish) {
            return rspBO;
        }
        boolean push = true;
        if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(cancelPO.getOrderStatus())) {
            push = false;
        }
        this.update(cancelPO, reqBO);
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null == ordSalePO) {
            throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u9500\u552e\u5355\u4fe1\u606f");
        }
        if (reqBO.getFlag().equals(REVOCATION)) {
            this.run(reqBO, push);
        } else {
            this.cancel(reqBO, cancelPO, ordSalePO);
        }
        if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(ordSalePO.getOrderSource()) || UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString().equals(ordSalePO.getOrderSource())) {
            push = false;
        }
        this.push(reqBO, push);
        return rspBO;
    }

    private void cancel(PebExtApprovalCancelReqBO reqBO, OrdCancelPO cancelPO, OrdSalePO ordSalePO) {
        if (PecConstant.ORDER_SOURCE.ELEC_AREA.toString().equals(ordSalePO.getOrderSource()) || PecConstant.ORDER_SOURCE.INQUIRY_PRICE_FRAMEWORK_AGREEMENT.toString().equals(ordSalePO.getOrderSource())) {
            UocPebOrderCancellationReqBO cancellationReqBO = (UocPebOrderCancellationReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocPebOrderCancellationReqBO.class);
            cancellationReqBO.setUserId(reqBO.getUserId());
            cancellationReqBO.setUsername(reqBO.getUsername());
            cancellationReqBO.setDealName(reqBO.getUsername());
            cancellationReqBO.setDealCode("ACTPEB030");
            cancellationReqBO.setCancelDesc("\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u9a73\u56de");
            cancellationReqBO.setCancelReson("\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u9a73\u56de");
            cancellationReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
            cancellationReqBO.setOrderId(reqBO.getOrderId());
            cancellationReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
            cancellationReqBO.setAuthCtrl(PecConstant.AuthCtrl.NO_CTRL);
            cancellationReqBO.setIsCancel(Boolean.valueOf(true));
            UocPebOrderCancellationRspBO cancellationRspBO = this.uocPebOrderCancellationBusiService.dealPebOrderCancellation(cancellationReqBO);
            if (!"0000".equals(cancellationRspBO.getRespCode())) {
                throw new UocProBusinessException(cancellationRspBO.getRespCode(), cancellationRspBO.getRespDesc());
            }
            OrdPayPO ordPay = new OrdPayPO();
            ordPay.setOrderId(reqBO.getOrderId());
            ordPay.setInterType(Integer.valueOf(0));
            List ordPayPOS = this.ordPayMapper.getList(ordPay);
            if (!CollectionUtils.isEmpty((Collection)ordPayPOS)) {
                UocPayOrderReFundReqBO uocPayOrderReFundReqBO = new UocPayOrderReFundReqBO();
                uocPayOrderReFundReqBO.setOrderId(reqBO.getOrderId());
                uocPayOrderReFundReqBO.setOperType("SUBMIT");
                UocPayOrderReFundRspBO uocPayOrderReFundRspBO = this.uocPayOrderReFundBusiService.dealOrderReFund(uocPayOrderReFundReqBO);
                log.info("\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocPayOrderReFundRspBO));
                if (!"0000".equals(uocPayOrderReFundRspBO.getRespCode())) {
                    log.debug("\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a{}", (Object)uocPayOrderReFundRspBO.getRespDesc());
                    throw new UocProBusinessException("8888", "\u8c03\u7528\u9000\u6b3e\u670d\u52a1\u5931\u8d25,\u5f02\u5e38\u63cf\u8ff0\uff1a" + uocPayOrderReFundRspBO.getRespDesc());
                }
            }
        } else {
            UocPebOrderCancelReqBO cancelReqBO = new UocPebOrderCancelReqBO();
            cancelReqBO.setOrderId(reqBO.getOrderId());
            cancelReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
            cancelReqBO.setNotInterface(Boolean.valueOf(true));
            cancelReqBO.setCancelDesc(cancelPO.getCancelReason());
            cancelReqBO.setCancelReason(cancelPO.getCancelReason());
            this.uocPebOrderCancelBusiService.dealOrderCancel(cancelReqBO);
        }
    }

    private void run(PebExtApprovalCancelReqBO reqBO, boolean push) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("approvalResult", push ? REVOCATION : "2");
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void update(OrdCancelPO cancelPO, PebExtApprovalCancelReqBO reqBO) {
        cancelPO.setDealTime(new Date());
        cancelPO.setDealOperId(String.valueOf(reqBO.getUserId()));
        cancelPO.setDealOperName(reqBO.getUsername());
        if (reqBO.getFlag().equals("0")) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_SUCCESS);
        } else if (REVOCATION.equals(reqBO.getRevocation())) {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_REVOKE);
        } else {
            cancelPO.setStatus(UocConstant.CANCEL_ORDER_STATUS.CANCEL_FAILED);
        }
        this.ordCancelMapper.updateById(cancelPO);
    }

    private void push(PebExtApprovalCancelReqBO reqBO, boolean push) {
        PebIntfConfirmCancelOrderRspBO rspBO;
        if (!push) {
            return;
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdQueryIndexPO indexPO = new OrdQueryIndexPO();
        indexPO.setOrderId(reqBO.getOrderId());
        indexPO.setObjType(UocConstant.OBJ_TYPE.SALE);
        indexPO.setObjId(reqBO.getSaleVoucherId());
        indexPO = this.ordQueryIndexMapper.getModelBy(indexPO);
        PebIntfConfirmCancelOrderReqBO orderReqBO = new PebIntfConfirmCancelOrderReqBO();
        orderReqBO.setOrderId(indexPO.getOutOrderNo());
        orderReqBO.setSupId(Long.valueOf(stakeholderPO.getSupNo()));
        orderReqBO.setCancelFlag(Integer.valueOf(Integer.parseInt(reqBO.getFlag())));
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(reqBO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            orderReqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((rspBO = this.pebIntfConfirmCancelOrderAbilityService.confirmCancelOrder(orderReqBO)).getRespCode())) {
            throw new UocProBusinessException("8888", rspBO.getRespDesc());
        }
    }

    private boolean dealAudit(PebExtApprovalCancelReqBO reqBO, OrdCancelPO cancelPO) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getStepId())) {
            uacNoTaskAuditOrderAuditReqBO.setStepId(reqBO.getStepId());
        } else {
            uacNoTaskAuditOrderAuditReqBO.setStepId(cancelPO.getStepId());
        }
        if (cancelPO.getStepId() == null) {
            throw new UocProBusinessException("8888", "\u5ba1\u6279\u5df2\u7ed3\u675f");
        }
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(Integer.parseInt(reqBO.getFlag())));
        uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getUsername());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getDealDesc());
        uacNoTaskAuditOrderAuditReqBO.setObjType(UocConstant.OBJ_TYPE.CANCEL);
        ArrayList<Long> objIds = new ArrayList<Long>();
        objIds.add(cancelPO.getId());
        uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("8888", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
        }
        if (!uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
            cancelPO.setStepId(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId());
            this.ordCancelMapper.updateById(cancelPO);
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }
}

