/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.serv;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.bo.afterservice.CategoryBO;
import com.tydic.order.bo.afterservice.ExtendSupplierInfoBO;
import com.tydic.order.bo.afterservice.PebExtCreateServOrderReqBO;
import com.tydic.order.bo.afterservice.PebExtCreateServOrderRspBO;
import com.tydic.order.bo.common.AccessoryBO;
import com.tydic.order.bo.common.OrdAccessoryPO;
import com.tydic.order.busi.serc.PebExtCreateServOrderBusiService;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.extend.dao.OrdCategoryMapper;
import com.tydic.order.extend.dao.OrdServMapper;
import com.tydic.order.extend.dao.po.OrdCategoryPO;
import com.tydic.order.extend.dao.po.OrdServPO;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtCreateServOrderBusiService")
public class PebExtCreateServOrderBusiServiceImpl
implements PebExtCreateServOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtCreateServOrderBusiServiceImpl.class);
    @Autowired
    private OrdServMapper ordServMapper;
    @Autowired
    private OrdCategoryMapper ordCategoryMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    public PebExtCreateServOrderRspBO dealCreateServOrder(PebExtCreateServOrderReqBO reqBo) {
        PebExtCreateServOrderRspBO retBo = new PebExtCreateServOrderRspBO();
        ArrayList<OrdServPO> ordServPos = new ArrayList<OrdServPO>();
        ArrayList<OrdCategoryPO> ordCategoryPos = new ArrayList<OrdCategoryPO>();
        ArrayList<OrdAccessoryPO> accessoryPos = new ArrayList<OrdAccessoryPO>();
        this.getPos(ordServPos, ordCategoryPos, accessoryPos, reqBo);
        this.ordServMapper.insertBatch(ordServPos);
        this.ordCategoryMapper.insertBatch(ordCategoryPos);
        this.ordAccessoryMapper.insertBatch(accessoryPos);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void getPos(List<OrdServPO> ordServPos, List<OrdCategoryPO> ordCategoryPos, List<OrdAccessoryPO> accessoryPos, PebExtCreateServOrderReqBO reqBo) {
        Date nowTime = this.ordServMapper.getDbDate();
        for (ExtendSupplierInfoBO supplierInfo : reqBo.getSupplierInfo()) {
            OrdCategoryPO ordCategoryPo;
            Long ordServKeyId = this.idUtil.nextId();
            Long orderId = this.idUtil.nextId();
            String servNo = this.biuldNo("", "FWD-SP-");
            OrdServPO ordServPo = new OrdServPO();
            BeanUtils.copyProperties((Object)reqBo, (Object)ordServPo);
            ordServPo.setId(ordServKeyId);
            ordServPo.setOrgId(reqBo.getOrgId().toString());
            ordServPo.setOrderId(orderId);
            ordServPo.setServNo(servNo);
            ordServPo.setCreateOperId(String.valueOf(reqBo.getUserId()));
            ordServPo.setAcceptOperName(reqBo.getName());
            ordServPo.setCreateOperName(reqBo.getUsername());
            ordServPo.setStatus(PebExtConstant.OrdServeStatus.WAIT_ACCEPT);
            ordServPo.setCreateTime(nowTime);
            ordServPo.setSupplierId(Long.valueOf(supplierInfo.getSupplierId()));
            ordServPo.setSupplierName(supplierInfo.getSupplierName());
            ordServPos.add(ordServPo);
            for (CategoryBO category : reqBo.getFlCategory()) {
                ordCategoryPo = new OrdCategoryPO();
                BeanUtils.copyProperties((Object)category, (Object)ordCategoryPo);
                ordCategoryPo.setType("2");
                ordCategoryPo.setId(Long.valueOf(this.idUtil.nextId()));
                ordCategoryPo.setSevrId(ordServKeyId);
                ordCategoryPo.setOrderId(orderId);
                ordCategoryPos.add(ordCategoryPo);
            }
            if (!CollectionUtils.isEmpty((Collection)reqBo.getSlCategory())) {
                for (CategoryBO category : reqBo.getFlCategory()) {
                    ordCategoryPo = new OrdCategoryPO();
                    BeanUtils.copyProperties((Object)category, (Object)ordCategoryPo);
                    ordCategoryPo.setType("1");
                    ordCategoryPo.setId(Long.valueOf(this.idUtil.nextId()));
                    ordCategoryPo.setSevrId(ordServKeyId);
                    ordCategoryPo.setOrderId(orderId);
                    ordCategoryPos.add(ordCategoryPo);
                }
            }
            if (CollectionUtils.isEmpty((Collection)reqBo.getAccessoryList())) continue;
            for (AccessoryBO accessoryBO : reqBo.getAccessoryList()) {
                OrdAccessoryPO ordAccessoryPo = new OrdAccessoryPO();
                ordAccessoryPo.setId(Long.valueOf(this.idUtil.nextId()));
                ordAccessoryPo.setCreateTime(new Date());
                ordAccessoryPo.setOrderId(orderId);
                ordAccessoryPo.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
                ordAccessoryPo.setObjectType(PebExtConstant.OBJ_TYPE.SERV);
                ordAccessoryPo.setAccessoryName(accessoryBO.getAccessoryName());
                ordAccessoryPo.setAccessoryUrl(accessoryBO.getAccessoryUrl());
                ordAccessoryPo.setAccessoryId(accessoryBO.getAccessoryId());
                ordAccessoryPo.setCreateOperId(String.valueOf(reqBo.getUserId()));
                ordAccessoryPo.setObjectId(ordServKeyId);
                ordAccessoryPo.setRemark("\u670d\u52a1\u5355\u521b\u5efa");
                accessoryPos.add(ordAccessoryPo);
            }
        }
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((String)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        OrdServPO ordServPo = new OrdServPO();
        ordServPo.setServNo(no);
        int count = this.ordServMapper.getCheckBy(ordServPo);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

