/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.serv;

import com.tydic.order.bo.afterservice.PebExtFinishServOrderReqBO;
import com.tydic.order.bo.afterservice.PebExtFinishServOrderRspBO;
import com.tydic.order.bo.common.AccessoryBO;
import com.tydic.order.bo.common.OrdAccessoryPO;
import com.tydic.order.busi.serc.PebExtFinishServOrderBusiService;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.extend.dao.OrdServMapper;
import com.tydic.order.extend.dao.po.OrdServPO;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtFinishServOrderAbilityService")
public class PebExtFinishServOrderBusiServiceImpl
implements PebExtFinishServOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtFinishServOrderBusiServiceImpl.class);
    @Autowired
    private OrdServMapper ordServMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    public PebExtFinishServOrderRspBO dealFinishServOrder(PebExtFinishServOrderReqBO reqBo) {
        PebExtFinishServOrderRspBO retBo = new PebExtFinishServOrderRspBO();
        Long orderId = this.changeOrdServInfo(reqBo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAccessoryList())) {
            this.saveAccessoryInfo(reqBo, orderId);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void saveAccessoryInfo(PebExtFinishServOrderReqBO reqBo, Long orderId) {
        ArrayList<OrdAccessoryPO> accessoryPos = new ArrayList<OrdAccessoryPO>();
        for (AccessoryBO accessoryBO : reqBo.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPo = new OrdAccessoryPO();
            ordAccessoryPo.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPo.setCreateTime(new Date());
            ordAccessoryPo.setOrderId(orderId);
            ordAccessoryPo.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPo.setObjectType(PebExtConstant.OBJ_TYPE.SERV);
            ordAccessoryPo.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPo.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPo.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPo.setCreateOperId(String.valueOf(reqBo.getUserId()));
            ordAccessoryPo.setObjectId(reqBo.getServId());
            ordAccessoryPo.setRemark("\u670d\u52a1\u5355\u5b8c\u6210");
            accessoryPos.add(ordAccessoryPo);
        }
        this.ordAccessoryMapper.insertBatch(accessoryPos);
    }

    private Long changeOrdServInfo(PebExtFinishServOrderReqBO reqBo) {
        Date nowTime = this.ordServMapper.getDbDate();
        OrdServPO ordServPo = this.ordServMapper.getModelById(reqBo.getServId().longValue());
        if (null == ordServPo) {
            throw new UocProBusinessException("0200", "\u6839\u636e\u670d\u52a1\u5355ID(" + reqBo.getServId() + ")\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        ordServPo.setStatus(PebExtConstant.OrdServeStatus.FINISHED);
        ordServPo.setFinishOperId(reqBo.getUserId().toString());
        ordServPo.setFinishOperName(reqBo.getUsername());
        ordServPo.setFinishTime(nowTime);
        ordServPo.setSkuId(StringUtils.join((Object[])reqBo.getShuIds().toArray(), (String)","));
        int result = this.ordServMapper.updateById(ordServPo);
        if (result < 1) {
            throw new UocProBusinessException("0100", "\u66f4\u65b0\u670d\u52a1\u5355\u72b6\u6001\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return ordServPo.getOrderId();
    }
}

