/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.ship;

import com.tydic.order.bo.process.UocProcessRunReqBO;
import com.tydic.order.bo.process.UocProcessRunRspBO;
import com.tydic.order.bo.ship.UocPebShipArrivalConfirmReqBO;
import com.tydic.order.bo.ship.UocPebShipArrivalConfirmRspBO;
import com.tydic.order.busi.ship.UocPebShipArrivalConfirmBusiService;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.impl.atom.afterservice.UocCoreArriveRegistAtomService;
import com.tydic.order.impl.atom.process.UocRunProcessAtomService;
import com.tydic.order.impl.bo.afterservice.ArriveInfoBO;
import com.tydic.order.impl.bo.afterservice.UocCoreArriveRegistReqBO;
import com.tydic.order.impl.bo.afterservice.UocCoreArriveRegistRspBO;
import com.tydic.order.impl.busi.ship.UocPebOrderDelieveredRejectBusiServiceImpl;
import com.tydic.order.impl.utils.OrderPropertiesUtil;
import com.tydic.order.third.intf.ability.esb.delivery.PebIntfArrivalConfirmCheckAbilityService;
import com.tydic.order.third.intf.bo.esb.delivery.ArrivalConfirmCheckReqBO;
import com.tydic.order.third.intf.bo.esb.delivery.ArrivalConfirmCheckRspBO;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebShipArrivalConfirmBusiService")
public class UocPebShipArrivalConfirmBusiServiceImpl
implements UocPebShipArrivalConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderDelieveredRejectBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private PebIntfArrivalConfirmCheckAbilityService arrivalConfirmCheckAbilityService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;

    public UocPebShipArrivalConfirmRspBO dealShipArrivalConfirm(UocPebShipArrivalConfirmReqBO reqBO) {
        this.validateParam(reqBO);
        UocPebShipArrivalConfirmRspBO rspBO = new UocPebShipArrivalConfirmRspBO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO modelBy = new OrdSalePO();
        try {
            modelBy = this.ordSaleMapper.getModelBy(ordSalePO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u6839\u636eorderId\u67e5\u8be2\u9500\u552e\u5355\u83b7\u53d6saleVoucherId\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e);
        }
        rspBO.setSaleVoucherId(modelBy.getSaleVoucherId());
        if (!UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(modelBy.getSaleState())) {
            throw new UocProBusinessException("8888", "\u8be5\u8ba2\u5355\u9500\u552e\u72b6\u6001\u4e0d\u4e3a\u53d1\u8d27\u4e2d\uff0c\u4e0d\u80fd\u8fdb\u884c\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\uff0c\u5165\u53c2\uff1a" + reqBO.toString());
        }
        OrdShipPO ordShipPO = this.buildOrdShipMapperParam(reqBO);
        List ordShipPOList = new ArrayList();
        try {
            ordShipPOList = this.ordShipMapper.getList(ordShipPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u6839\u636eorderId\u67e5\u8be2\u53d1\u8d27\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e);
        }
        if (ordShipPOList != null && !ordShipPOList.isEmpty()) {
            ArrayList<Long> shipVoucherIdList = new ArrayList<Long>(ordShipPOList.size());
            for (OrdShipPO shipPO : ordShipPOList) {
                shipVoucherIdList.add(shipPO.getShipVoucherId());
                OrdShipItemPO ordShipItemPO = this.buildOrdShipItemMapperParam(shipPO);
                List ordShipItemPOList = new ArrayList();
                try {
                    ordShipItemPOList = this.ordShipItemMapper.getList(ordShipItemPO);
                }
                catch (Exception e) {
                    throw new UocProBusinessException("8888", "\u6839\u636eorderId\u548c\u53d1\u8d27\u5355ID\u67e5\u8be2\u53d1\u8d27\u660e\u7ec6\u8868\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e);
                }
                if (ordShipItemPOList == null || ordShipItemPOList.isEmpty()) continue;
                ArrayList<ArriveInfoBO> arriveInfoBOList = new ArrayList<ArriveInfoBO>();
                for (OrdShipItemPO shipItemPO : ordShipItemPOList) {
                    ArriveInfoBO arriveInfoBO = new ArriveInfoBO();
                    arriveInfoBO.setShipItemId(shipItemPO.getShipItemId());
                    arriveInfoBO.setArriveCount(shipItemPO.getSendCount());
                    arriveInfoBOList.add(arriveInfoBO);
                }
                UocCoreArriveRegistReqBO arriveRegistReqBO = new UocCoreArriveRegistReqBO();
                arriveRegistReqBO.setShipVoucherId(shipPO.getShipVoucherId());
                arriveRegistReqBO.setOrderId(shipPO.getOrderId());
                arriveRegistReqBO.setCreateOperId(reqBO.getOperId());
                arriveRegistReqBO.setArriveInfoList(arriveInfoBOList);
                arriveRegistReqBO.setShipStatus(Integer.parseInt("1203"));
                UocCoreArriveRegistRspBO arriveRegistRspBO = this.uocCoreArriveRegistAtomService.dealCoreArriveRegist(arriveRegistReqBO);
                if (!"0000".equals(arriveRegistRspBO.getRespCode())) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
                    }
                    throw new UocProBusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
                }
                OrdShipPO ordShipModel = new OrdShipPO();
                ordShipModel.setArriveTime(new Date());
                ordShipModel.setShipVoucherId(shipPO.getShipVoucherId());
                ordShipModel.setOrderId(shipPO.getOrderId());
                if (StringUtils.isNotBlank((CharSequence)reqBO.getArriveRemark())) {
                    ordShipModel.setArriveRemark(reqBO.getArriveRemark());
                }
                int updateArriveTimeResult = 0;
                try {
                    updateArriveTimeResult = this.ordShipMapper.updateById(ordShipModel);
                }
                catch (Exception e) {
                    throw new UocProBusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e);
                }
                if (updateArriveTimeResult != 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug("\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
                }
                throw new UocProBusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u5230\u8d27\u65f6\u95f4\u5931\u8d25!");
            }
            rspBO.setShipVoucherIdList(shipVoucherIdList);
        }
        this.arrivalConfirmCheck(reqBO);
        HashMap<String, Object> saleMap = new HashMap<String, Object>();
        saleMap.put("rejectFlag", 3);
        this.runProcess(rspBO.getSaleVoucherId(), reqBO.getOrderId(), reqBO.getOperId(), UocConstant.OBJ_TYPE.SALE, saleMap);
        HashMap<String, Object> shipMap = new HashMap<String, Object>();
        shipMap.put("rejectFlag", 0);
        this.runProcess(((OrdShipPO)ordShipPOList.get(0)).getShipVoucherId(), reqBO.getOrderId(), reqBO.getOperId(), UocConstant.OBJ_TYPE.SHIP, shipMap);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }

    private void validateParam(UocPebShipArrivalConfirmReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("7777", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("7777", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\uff08orderId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOperId()) {
            throw new UocProBusinessException("7777", "\u7535\u5b50\u8d85\u5e02\u81ea\u4e3b\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u4eba\uff08operId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void runProcess(Long objId, Long orderId, String operId, Integer objType, Map<String, Object> map) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId(operId);
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u901a\u8fc7\u5165\u53c2\uff1a" + processRunReqBO.toString() + "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private OrdShipPO buildOrdShipMapperParam(UocPebShipArrivalConfirmReqBO reqBO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        return ordShipPO;
    }

    private OrdShipItemPO buildOrdShipItemMapperParam(OrdShipPO shipPO) {
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(shipPO.getOrderId());
        ordShipItemPO.setShipVoucherId(shipPO.getShipVoucherId());
        return ordShipItemPO;
    }

    private void arrivalConfirmCheck(UocPebShipArrivalConfirmReqBO reqBO) {
        ArrivalConfirmCheckRspBO arrivalConfirmCheckRspBO;
        ArrivalConfirmCheckReqBO arrivalConfirmCheckReqBO = new ArrivalConfirmCheckReqBO();
        arrivalConfirmCheckReqBO.setJdOrderId(Long.valueOf(reqBO.getExtOrderId()));
        arrivalConfirmCheckReqBO.setSupplierId(Long.valueOf(OrderPropertiesUtil.getProperty("SUPPLIER_JD_ID")));
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(reqBO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            arrivalConfirmCheckReqBO.setOrgId(mapPO.getFieldValue());
        }
        if (!"0000".equals((arrivalConfirmCheckRspBO = this.arrivalConfirmCheckAbilityService.confirmGoods(arrivalConfirmCheckReqBO)).getRespCode())) {
            throw new UocProBusinessException("\u4eac\u4e1c\u786e\u8ba4\u6536\u8d27\u5931\u8d25\uff1a", arrivalConfirmCheckRspBO.getRespCode() + arrivalConfirmCheckRspBO.getRespDesc());
        }
    }
}

