/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.comb.abnormal;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.ability.order.bo.UocPebAbnormalAuditReqBO;
import com.tydic.order.ability.order.bo.UocPebAbnormalAuditRspBO;
import com.tydic.order.bo.abnormal.UocPebAbnormalBO;
import com.tydic.order.bo.order.OrdSaleRspBO;
import com.tydic.order.busi.abnormal.UocPebAbnormalAuditBusiService;
import com.tydic.order.comb.abnormal.UocPebAbnormalAuditCombService;
import com.tydic.order.comb.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.constant.UocConstant;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebAbnormalAuditCombService")
public class UocPebAbnormalAuditCombServiceImpl
implements UocPebAbnormalAuditCombService {
    @Autowired
    private UocPebAbnormalAuditBusiService uocPebAbnormalAuditBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    private Logger logger = LoggerFactory.getLogger(UocPebAbnormalAuditCombServiceImpl.class);

    public UocPebAbnormalAuditRspBO audit(UocPebAbnormalAuditReqBO reqBO) {
        for (UocPebAbnormalBO abnormalBO : reqBO.getAbnormalList()) {
            UocPebAbnormalAuditReqBO auditReqBO = new UocPebAbnormalAuditReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)auditReqBO);
            ArrayList<UocPebAbnormalBO> abnormalList = new ArrayList<UocPebAbnormalBO>(1);
            abnormalList.add(abnormalBO);
            auditReqBO.setAbnormalList(abnormalList);
            UocPebAbnormalAuditRspBO rspBO = this.uocPebAbnormalAuditBusiService.dealAudit(auditReqBO);
            if ("0000".equals(rspBO.getRespCode())) {
                this.uocPebOrdIdxSync(abnormalBO.getOrderId(), abnormalBO.getAbnormalVoucherId(), UocConstant.OBJ_TYPE.ABNORMAL);
                if (!CollectionUtils.isNotEmpty((Collection)rspBO.getSaleIds())) continue;
                for (OrdSaleRspBO saleRspBO : rspBO.getSaleIds()) {
                    this.uocPebOrdIdxSync(saleRspBO.getOrderId(), saleRspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
                }
                continue;
            }
            return rspBO;
        }
        UocPebAbnormalAuditRspBO rspBO = new UocPebAbnormalAuditRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void uocPebOrdIdxSync(Long orderId, Long objId, Integer type) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setOrderId(orderId);
        reqBO.setObjId(objId);
        reqBO.setObjType(type);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)reqBO)));
    }
}

