/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.comb.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.order.bo.order.UocPebAccessoryBO;
import com.tydic.order.busi.order.UocProPurchaseArriveConfirmRejectBusiService;
import com.tydic.order.comb.order.UocProPurchaseArriveConfirmRejectCombService;
import com.tydic.order.comb.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.comb.order.bo.UocProPurchaseArriveConfirmRejectCombReqBo;
import com.tydic.order.comb.order.bo.UocProPurchaseArriveConfirmRejectCombRspBo;
import com.tydic.order.constant.PecConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UocProPurchaseArriveConfirmRejectCombServiceImpl
implements UocProPurchaseArriveConfirmRejectCombService {
    @Autowired
    private UocProPurchaseArriveConfirmRejectBusiService uocProPurchaseArriveConfirmRejectBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    public UocProPurchaseArriveConfirmRejectCombRspBo confirmRejectArrive(UocProPurchaseArriveConfirmRejectCombReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProPurchaseArriveConfirmRejectCombRspBo rspBo = this.uocProPurchaseArriveConfirmRejectBusiService.dealConfirmReject(reqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            return rspBo;
        }
        UocPebOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBo.getSaleVourcherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        for (Long shipId : reqBo.getShipVoucherIds()) {
            UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            ordIdxSyncReqBO.setObjId(shipId);
            ordIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            ordIdxSyncReqBO.setOrderId(reqBo.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)ordIdxSyncReqBO)));
        }
        return rspBo;
    }

    private void validateArgs(UocProPurchaseArriveConfirmRejectCombReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getOrderId() == null) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBo.getSaleVourcherId() == null) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u9500\u552e\u8ba2\u5355ID\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (PecConstant.AuthCtrl.SELF.equals(reqBo.getAuthCtrl()) && reqBo.getMemId() == null) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u64cd\u4f5c\u4eba\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (PecConstant.AuthCtrl.STATION.equals(reqBo.getAuthCtrl()) && StringUtils.isEmpty((Object)reqBo.getStationId())) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u5c97\u4f4d\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getConsignee())) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u6536\u8d27\u4eba\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getConsignee())) {
            throw new UocProBusinessException("214004", "\u5165\u53c2[consignee]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAccessoryList())) {
            for (UocPebAccessoryBO accessoryBO : reqBo.getAccessoryList()) {
                if (StringUtils.isEmpty((Object)accessoryBO.getAccessoryName())) {
                    throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u9644\u4ef6\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)accessoryBO.getAccessoryUrl())) continue;
                throw new UocProBusinessException("214004", "\u5165\u53c2\u3010\u9644\u4ef6URL\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipVoucherIds())) {
            throw new UocProBusinessException("214004", "\u5165\u53c2\u5c5e\u6027\u3010shipVoucherIds\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

