/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.comb.plan;

import com.alibaba.fastjson.JSON;
import com.tydic.order.bo.PebExtEsPlanListQueryDataBo;
import com.tydic.order.bo.PebExtEsPlanListQueryReqBO;
import com.tydic.order.bo.PebExtEsPlanListQueryRspBO;
import com.tydic.order.bo.plan.PebExtPlanBO;
import com.tydic.order.bo.plan.PebExtPlanListQueryReqBO;
import com.tydic.order.bo.plan.PebExtPlanListQueryRspBO;
import com.tydic.order.bo.saleorder.UocTabsNumberQueryBO;
import com.tydic.order.busi.PebExtEsPlanListQueryBusiService;
import com.tydic.order.comb.plan.PebExtPlanListQueryCombService;
import com.tydic.order.third.intf.ability.umc.PebIntfMemDetailQueryAbilityService;
import com.tydic.order.third.intf.ability.umc.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryReqBO;
import com.tydic.order.third.intf.bo.umc.MemDetailQueryRspBO;
import com.tydic.order.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.order.uoc.dao.po.ConfTabOrdStatePO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtPlanListQueryCombService")
public class PebExtPlanListQueryCombServiceImpl
implements PebExtPlanListQueryCombService {
    private static final Logger log = LoggerFactory.getLogger(PebExtPlanListQueryCombServiceImpl.class);
    @Autowired
    private PebExtEsPlanListQueryBusiService pebExtEsPlanListQueryBusiService;
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;

    public PebExtPlanListQueryRspBO getPlanListQuery(PebExtPlanListQueryReqBO reqBO) {
        String name;
        PebExtPlanListQueryRspBO retBo = new PebExtPlanListQueryRspBO();
        Boolean isPermission = this.controlPermission(reqBO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCgzxrbh()) && StringUtils.isNotBlank((CharSequence)(name = this.getEmpCod(reqBO.getUserId())))) {
            reqBO.setCgzxrbh(name);
        }
        PebExtEsPlanListQueryReqBO esQryPlanListReqBO = (PebExtEsPlanListQueryReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtEsPlanListQueryReqBO.class);
        PebExtEsPlanListQueryRspBO esQryPlanListRspBO = new PebExtEsPlanListQueryRspBO();
        if (null != reqBO.getStatus()) {
            esQryPlanListReqBO.setStatus(reqBO.getStatus());
            if (isPermission.booleanValue()) {
                esQryPlanListRspBO = this.pebExtEsPlanListQueryBusiService.qryEsPlanInfo(esQryPlanListReqBO);
            }
            if (!"0000".equals(esQryPlanListRspBO.getRespCode())) {
                throw new UocProBusinessException(esQryPlanListRspBO.getRespCode(), esQryPlanListRspBO.getRespDesc());
            }
            this.assignRetBo(esQryPlanListRspBO, retBo, isPermission, reqBO);
        } else if (null != reqBO.getTabId()) {
            esQryPlanListReqBO.setStateList(this.getStatueList(Collections.singletonList(reqBO.getTabId())).get(reqBO.getTabId()).getStatueList());
            if (isPermission.booleanValue()) {
                esQryPlanListRspBO = this.pebExtEsPlanListQueryBusiService.qryEsPlanInfo(esQryPlanListReqBO);
            }
            if (!"0000".equals(esQryPlanListRspBO.getRespCode())) {
                throw new UocProBusinessException(esQryPlanListRspBO.getRespCode(), esQryPlanListRspBO.getRespDesc());
            }
            this.assignRetBo(esQryPlanListRspBO, retBo, isPermission, reqBO);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getTabIdList())) {
            esQryPlanListReqBO.setIsQueryTab(Boolean.valueOf(true));
            Map<Integer, ConfTabOrdStatePO> tabInfoMap = this.getStatueList(reqBO.getTabIdList());
            if (null != reqBO.getStatus()) {
                esQryPlanListReqBO.setStateList(Collections.singletonList(reqBO.getStatus()));
            } else {
                esQryPlanListReqBO.setStateList(tabInfoMap.get(0).getStatueList());
            }
            if (isPermission.booleanValue()) {
                esQryPlanListRspBO = this.pebExtEsPlanListQueryBusiService.qryEsPlanInfo(esQryPlanListReqBO);
            }
            if (!"0000".equals(esQryPlanListRspBO.getRespCode())) {
                throw new UocProBusinessException(esQryPlanListRspBO.getRespCode(), esQryPlanListRspBO.getRespDesc());
            }
            this.assignTabInfo(esQryPlanListRspBO, retBo, tabInfoMap, isPermission);
        }
        return retBo;
    }

    private String getEmpCod(Long userId) {
        MemDetailQueryReqBO reqBO = new MemDetailQueryReqBO();
        reqBO.setUserIdWeb(userId);
        MemDetailQueryRspBO rspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(reqBO);
        return rspBO.getUmcMemDetailInfoAbilityRspBO().getOccupation();
    }

    private void assignTabInfo(PebExtEsPlanListQueryRspBO esQryPlanListRspBO, PebExtPlanListQueryRspBO retBo, Map<Integer, ConfTabOrdStatePO> tabInfoMap, Boolean isPermission) {
        ArrayList<UocTabsNumberQueryBO> saleTabCountList = new ArrayList<UocTabsNumberQueryBO>();
        Map tabCountsMap = esQryPlanListRspBO.getTabCountsMap();
        for (Map.Entry<Integer, ConfTabOrdStatePO> m : tabInfoMap.entrySet()) {
            if (m.getKey().equals(0)) continue;
            ConfTabOrdStatePO tabOrdStatePO = m.getValue();
            UocTabsNumberQueryBO tabsNumberQueryBO = new UocTabsNumberQueryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId() + "");
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            if (isPermission.booleanValue()) {
                for (Integer statue : tabOrdStatePO.getStatueList()) {
                    Integer tabMapCounts = (Integer)tabCountsMap.get(statue);
                    if (tabMapCounts == null) continue;
                    tabsCount += tabMapCounts.intValue();
                }
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            saleTabCountList.add(tabsNumberQueryBO);
        }
        retBo.setPlanTabCountList(saleTabCountList);
    }

    private void assignRetBo(PebExtEsPlanListQueryRspBO esQryPlanListRspBO, PebExtPlanListQueryRspBO retBo, Boolean isPermission, PebExtPlanListQueryReqBO reqBO) {
        if (isPermission.booleanValue()) {
            retBo.setPageNo(esQryPlanListRspBO.getPageNo());
            retBo.setTotal(esQryPlanListRspBO.getTotal());
            retBo.setRecordsTotal(esQryPlanListRspBO.getRecordsTotal());
            ArrayList<PebExtPlanBO> rows = new ArrayList<PebExtPlanBO>();
            if (CollectionUtils.isNotEmpty((Collection)esQryPlanListRspBO.getRows())) {
                for (PebExtEsPlanListQueryDataBo planDataBo : esQryPlanListRspBO.getRows()) {
                    rows.add(planDataBo.getOrdPlanRspBO());
                }
            }
            retBo.setRows(rows);
        } else {
            retBo.setPageNo(1);
            retBo.setTotal(0);
            retBo.setRecordsTotal(0);
            retBo.setRows(new ArrayList(0));
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
    }

    private Map<Integer, ConfTabOrdStatePO> getStatueList(List<Integer> tabIds) {
        ConfTabOrdStatePO tabOrdStatePO = new ConfTabOrdStatePO();
        LinkedHashMap<Integer, ConfTabOrdStatePO> tabInfoMap = new LinkedHashMap<Integer, ConfTabOrdStatePO>();
        ArrayList<Integer> statueList = new ArrayList<Integer>();
        tabOrdStatePO.setTabIdList(tabIds);
        List confTabOrdStatePOList = this.confTabOrdStateMapper.getList(tabOrdStatePO);
        if (CollectionUtils.isNotEmpty((Collection)confTabOrdStatePOList)) {
            for (ConfTabOrdStatePO confTabOrdStatePO : confTabOrdStatePOList) {
                ArrayList<Integer> statueItemList = new ArrayList<Integer>();
                String statueStr = confTabOrdStatePO.getOrderStatusCode();
                if (!StringUtils.isEmpty((CharSequence)statueStr)) {
                    String[] statue = statueStr.contains(",") ? statueStr.split(",") : new String[]{statueStr};
                    for (String state : statue) {
                        statueItemList.add(Integer.valueOf(state));
                        statueList.add(Integer.valueOf(state));
                    }
                }
                confTabOrdStatePO.setStatueList(statueItemList);
                tabInfoMap.put(confTabOrdStatePO.getTabId(), confTabOrdStatePO);
            }
        } else {
            throw new UocProBusinessException("0100", "\u672a\u67e5\u8be2\u5230\u9875\u7b7e\uff08tabId\uff09\u914d\u7f6e\u4fe1\u606f");
        }
        ConfTabOrdStatePO confTabOrdStatePO = new ConfTabOrdStatePO();
        confTabOrdStatePO.setStatueList(statueList.stream().distinct().collect(Collectors.toList()));
        tabInfoMap.put(0, confTabOrdStatePO);
        return tabInfoMap;
    }

    private Boolean controlPermission(PebExtPlanListQueryReqBO reqBO) {
        return true;
    }
}

