/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.dic;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.order.dic.DicDictionaryService;
import com.tydic.order.dic.SelectDicValByPcodeAndCode;
import com.tydic.order.dic.bo.DicDictionaryBO;
import com.tydic.order.dic.bo.SelectSingleDictReqBO;
import com.tydic.order.dic.bo.SelectSingleDictRspBO;
import com.tydic.uoc.base.bo.UocProRspListBo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectDicValByPcodeAndCode")
public class SelectDicValByPcodeAndCodeImpl
implements SelectDicValByPcodeAndCode {
    private static final Logger log = LoggerFactory.getLogger(SelectDicValByPcodeAndCodeImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Resource
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private CacheClient cacheService;

    public SelectSingleDictRspBO selectDicValByPcodeAndCode(SelectSingleDictReqBO selectSingleDictReqBO) {
        SelectSingleDictRspBO repBO;
        block10: {
            String pcode = selectSingleDictReqBO.getPcode();
            String code = selectSingleDictReqBO.getCode();
            repBO = new SelectSingleDictRspBO();
            if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)pcode)) {
                repBO.setRespCode("8888");
                repBO.setRespDesc("\u5b57\u5178\u503c\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
                return repBO;
            }
            try {
                Object object = this.cacheService.get(pcode);
                if (object != null) {
                    UocProRspListBo dicDictionaries = (UocProRspListBo)object;
                    for (DicDictionaryBO dicDictionary : dicDictionaries.getList()) {
                        if (!code.equals(dicDictionary.getCode())) continue;
                        if (this.isDebugEnabled.booleanValue()) {
                            log.info("redis\u7f13\u5b58\u4e2d\u83b7\u53d6\u5b57\u5178\u503c" + JSON.toJSONString((Object)dicDictionary));
                        }
                        repBO.setRespCode("0000");
                        repBO.setDicDictionarys(dicDictionary);
                        return repBO;
                    }
                    break block10;
                }
                DicDictionaryBO dicDictionary = this.dicDictionaryService.selectdictionaryByCodeAndCode(code, pcode);
                if (this.isDebugEnabled.booleanValue()) {
                    // empty if block
                }
                if (dicDictionary != null) {
                    repBO.setRespCode("0000");
                    repBO.setDicDictionarys(dicDictionary);
                } else {
                    repBO.setRespCode("8888");
                    repBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u503c\u4e0d\u5b58\u5728");
                }
                return repBO;
            }
            catch (Exception e) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.error("\u83b7\u53d6\u5b57\u5178\u503c\u5931\u8d25", (Throwable)e);
                }
                repBO.setRespCode("8888");
                repBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u503c\u5931\u8d25");
                return repBO;
            }
        }
        repBO.setRespCode("8888");
        repBO.setRespDesc("\u5b57\u5178\u503c\u4e0d\u5b58\u5728");
        return repBO;
    }
}

