/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.dic;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.order.dic.DicDictionaryService;
import com.tydic.order.dic.SelectDicValBypCodesBusiService;
import com.tydic.order.dic.bo.DicValAndpCodeBO;
import com.tydic.order.dic.bo.SelectDicValBypCodesReqBO;
import com.tydic.order.dic.bo.SelectDicValBypCodesRspBO;
import com.tydic.order.impl.dic.SelectDictValByCodeImpl;
import com.tydic.uoc.base.bo.UocProRspListBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectDicValBypCodesBusiService")
public class SelectDicValBypCodesBusiServiceImpl
implements SelectDicValBypCodesBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectDictValByCodeImpl.class);
    @Autowired
    private DicDictionaryService pecDicDictionaryService;
    @Autowired
    private CacheClient cacheService;

    public SelectDicValBypCodesRspBO selectDicValBypCodes(SelectDicValBypCodesReqBO selectDicValBypCodesReqBO) {
        if (selectDicValBypCodesReqBO == null) {
            throw new UocProBusinessException("7777", "\u5165\u53c2\u3010selectDicValBypCodesReqBO\u3011\u5fc5\u586b");
        }
        if (selectDicValBypCodesReqBO.getpCodes() == null || selectDicValBypCodesReqBO.getpCodes().isEmpty()) {
            throw new UocProBusinessException("7777", "\u5165\u53c2\u3010pCodes\u3011\u5fc5\u586b");
        }
        SelectDicValBypCodesRspBO dicValBypCodesRspBO = new SelectDicValBypCodesRspBO();
        try {
            HashMap<String, DicValAndpCodeBO> dicValAndpCodeBOMap = new HashMap<String, DicValAndpCodeBO>();
            LinkedList<HashMap<String, DicValAndpCodeBO>> maps = new LinkedList<HashMap<String, DicValAndpCodeBO>>();
            for (String pCode : selectDicValBypCodesReqBO.getpCodes()) {
                if (StringUtils.isBlank((CharSequence)pCode)) continue;
                Object object = this.cacheService.get(pCode);
                log.debug("\u7f13\u5b58\u4e2d\u7684\u503c====" + JSON.toJSONString((Object)object));
                if (object == null) {
                    this.getDicDictionariesFromDB(pCode, dicValAndpCodeBOMap);
                    continue;
                }
                UocProRspListBo redisRsp = (UocProRspListBo)object;
                List redisBackList = redisRsp.getList();
                log.debug("\u7f13\u5b58\u4e2d\u6709\u503c\uff0c\u76f4\u63a5\u8fd4\u56de");
                if (redisBackList != null && redisBackList.size() > 0) {
                    DicValAndpCodeBO dicValAndpCodeBO = new DicValAndpCodeBO();
                    dicValAndpCodeBO.setpCode(pCode);
                    dicValAndpCodeBO.setDicDictionaries(redisBackList);
                    dicValAndpCodeBOMap.put(pCode, dicValAndpCodeBO);
                    continue;
                }
                this.getDicDictionariesFromDB(pCode, dicValAndpCodeBOMap);
            }
            maps.add(dicValAndpCodeBOMap);
            dicValBypCodesRspBO.setDicValAndpCodeBOs(maps);
            dicValBypCodesRspBO.setRespCode("0000");
            dicValBypCodesRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            dicValBypCodesRspBO.setRespCode("8888");
            dicValBypCodesRspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25");
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        return dicValBypCodesRspBO;
    }

    private void getDicDictionariesFromDB(String pCode, Map<String, DicValAndpCodeBO> dicValAndpCodeBOMap) {
        log.debug("\u7f13\u5b58\u4e2d\u6ca1\u6709\u503c\uff0c\u6570\u636e\u5e93\u83b7\u53d6\u4fe1\u606f\uff0c\u5e76\u5b58\u5165redis");
        UocProRspListBo dicDictionaries = this.pecDicDictionaryService.selectDictValByCode(pCode);
        this.cacheService.set(pCode, (Object)dicDictionaries, 7200);
        if (dicDictionaries != null && !dicDictionaries.getList().isEmpty()) {
            DicValAndpCodeBO dicValAndpCodeBO = new DicValAndpCodeBO();
            dicValAndpCodeBO.setpCode(pCode);
            dicValAndpCodeBO.setDicDictionaries(dicDictionaries.getList());
            dicValAndpCodeBOMap.put(pCode, dicValAndpCodeBO);
        }
    }
}

