/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.download;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.order.ability.saleorder.PebExtOrderListExportAbilityService;
import com.tydic.order.ability.saleorder.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.order.bo.saleorder.PebExtOrderListExportAbilityBo;
import com.tydic.order.bo.saleorder.PebExtOrderListExportAbilityRspBO;
import com.tydic.order.bo.saleorder.PebExtOrderListExportReqBO;
import com.tydic.order.bo.saleorder.PebExtOrderListExportRspBo;
import com.tydic.order.bo.saleorder.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.order.bo.saleorder.PebExtSalesSingleDetailsListQueryRspBO;
import com.tydic.order.bo.saleorder.PebExtUpperOrderAbilityBO;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.uoc.base.bo.other.UocProStationWebBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV", serviceInterface=PebExtOrderListExportAbilityService.class)
public class PebExtOrderListExportAbilityServiceImpl
implements PebExtOrderListExportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtOrderListExportAbilityServiceImpl.class);
    @Value(value="${es.max.query.number:10000}")
    private Integer maxQryNums;
    @Value(value="${es.max.query.count:2000}")
    private Integer max;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UOC_GROUP_DEV")
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;

    public PebExtOrderListExportAbilityRspBO dealOrderListExport(PebExtOrderListExportReqBO reqBO) {
        String jsonReq = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO = (PebExtSalesSingleDetailsListQueryReqBO)JSON.parseObject((String)jsonReq, PebExtSalesSingleDetailsListQueryReqBO.class);
        PebExtOrderListExportAbilityRspBO abilityRspBO = new PebExtOrderListExportAbilityRspBO();
        abilityRspBO.setCode("0");
        abilityRspBO.setMessage("\u6210\u529f");
        PebExtOrderListExportRspBo rspBo = new PebExtOrderListExportRspBo();
        boolean pageNo = true;
        AtomicInteger total = new AtomicInteger();
        ArrayList<PebExtOrderListExportAbilityBo> pebExtOrderList = new ArrayList<PebExtOrderListExportAbilityBo>();
        this.buildRequestParams(pebExtSalesSingleDetailsListQueryReqBO, reqBO);
        try {
            pebExtSalesSingleDetailsListQueryReqBO.setPageNo(reqBO.getPageNo());
            pebExtSalesSingleDetailsListQueryReqBO.setPageSize(reqBO.getPageSize());
            PebExtSalesSingleDetailsListQueryRspBO orderList = this.pebExtSalesSingleDetailsListQueryAbilityService.getPebExtSalesSingleDetailsListQuery(pebExtSalesSingleDetailsListQueryReqBO);
            List rows = orderList.getRows();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)rows)) {
                log.info("\u67e5\u8be2\u9500\u552e\u5355\u6570\u636e\u6210\u529f\uff0c\u7b2c{}\u9875\uff0c\u603b\u5171{}\u6761", (Object)reqBO.getPageNo(), (Object)rows.size());
                total = this.getExportOrderDataList(total, pebExtOrderList, rows);
            } else {
                log.info("\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u7684\u4fe1\u606f");
            }
            log.info("\u4e0b\u8f7d\u8ba2\u5355\u603b\u6761\u6570\uff1a{}", (Object)orderList.getRecordsTotal());
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setRows(pebExtOrderList);
            rspBo.setRecordsTotal(orderList.getRecordsTotal());
            rspBo.setTotal(orderList.getTotal());
        }
        catch (Exception e) {
            abilityRspBO.setCode("1");
            abilityRspBO.setMessage("\u5931\u8d25");
            log.error("\u8c03\u7528\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException(String.format("\u8c03\u7528\u8ba2\u5355\u67e5\u8be2\u670d\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u8be6\u60c5\uff1a%s", e.getMessage()));
        }
        abilityRspBO.setData(rspBo);
        return abilityRspBO;
    }

    private void buildRequestParams(PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO, PebExtOrderListExportReqBO reqBO) {
        Integer exportFlag = reqBO.getExportFlag();
        if (PebExtConstant.EXPORT_FLAG.ORDER_ALL.equals(exportFlag)) {
            if (StringUtils.isNotBlank((CharSequence)pebExtSalesSingleDetailsListQueryReqBO.getSupName())) {
                pebExtSalesSingleDetailsListQueryReqBO.setSupName(null);
            }
        } else if (PebExtConstant.EXPORT_FLAG.ORDER_MY.equals(exportFlag)) {
            pebExtSalesSingleDetailsListQueryReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        } else if (PebExtConstant.EXPORT_FLAG.ORDER_MY_CANCEL.equals(exportFlag)) {
            pebExtSalesSingleDetailsListQueryReqBO.setCancelOperId(String.valueOf(reqBO.getUserId()));
        } else if (PebExtConstant.EXPORT_FLAG.ORDER_MY_ARRIVAL.equals(exportFlag)) {
            Integer arriveConfirmTabId;
            pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(true));
            if (null != reqBO.getTabId() && (arriveConfirmTabId = Integer.valueOf(30022)).equals(reqBO.getTabId())) {
                pebExtSalesSingleDetailsListQueryReqBO.setSupNo(String.valueOf(100055L));
            }
        } else if (PebExtConstant.EXPORT_FLAG.ORDER_MY_PURCHASE.equals(exportFlag)) {
            if (reqBO.getSupId() != null && reqBO.getSupId() != 0L) {
                pebExtSalesSingleDetailsListQueryReqBO.setSupNo(String.valueOf(reqBO.getSupId()));
            }
            pebExtSalesSingleDetailsListQueryReqBO.setOrderSourceList(Collections.singletonList("2"));
        } else if (PebExtConstant.EXPORT_FLAG.ACTIVITY_MY_ORDER_ALL.equals(exportFlag)) {
            pebExtSalesSingleDetailsListQueryReqBO.setOrderCategory(Integer.valueOf(1));
            pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(true));
            pebExtSalesSingleDetailsListQueryReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        } else if (PebExtConstant.EXPORT_FLAG.CANCEL_ORDER_ALL.equals(exportFlag)) {
            Integer allApprove;
            pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(true));
            ArrayList<String> taskOperIdList = new ArrayList<String>();
            if (null != reqBO.getTabId() && (allApprove = Integer.valueOf(70003)).equals(reqBO.getTabId())) {
                if (!CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
                    for (UocProStationWebBO stationWebBO : reqBO.getUmcStationsListWebExt()) {
                        taskOperIdList.add(String.valueOf(stationWebBO.getStationId()));
                    }
                    pebExtSalesSingleDetailsListQueryReqBO.setCancelTaskOperIdList(taskOperIdList);
                }
                String userId = String.valueOf(reqBO.getUserId());
                pebExtSalesSingleDetailsListQueryReqBO.setCancelApproverId(userId);
                pebExtSalesSingleDetailsListQueryReqBO.setCancelTaskUserId(userId);
            }
            pebExtSalesSingleDetailsListQueryReqBO.setTabIdList(null);
        } else if (PebExtConstant.EXPORT_FLAG.SUP_ORDER_ALL.equals(exportFlag)) {
            pebExtSalesSingleDetailsListQueryReqBO.setSupNo(String.valueOf(reqBO.getSupId()));
            pebExtSalesSingleDetailsListQueryReqBO.setOrderSourceList(Collections.singletonList("1"));
        }
    }

    private AtomicInteger getExportOrderDataList(AtomicInteger total, List<PebExtOrderListExportAbilityBo> pebExtOrderList, List<PebExtUpperOrderAbilityBO> rows) {
        rows.forEach(pebExtUpperOrderAbilityBO -> {
            List childOrderList = pebExtUpperOrderAbilityBO.getChildOrderList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)childOrderList)) {
                childOrderList.forEach(order -> {
                    List orderItemList = order.getOrderItemList();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderItemList)) {
                        total.addAndGet(orderItemList.size());
                        orderItemList.forEach(item -> {
                            PebExtOrderListExportAbilityBo exportAbilityBo = (PebExtOrderListExportAbilityBo)JSON.parseObject((String)JSON.toJSONString((Object)pebExtUpperOrderAbilityBO), PebExtOrderListExportAbilityBo.class);
                            BeanUtils.copyProperties((Object)order, (Object)exportAbilityBo);
                            BeanUtils.copyProperties((Object)item, (Object)exportAbilityBo);
                            pebExtOrderList.add(exportAbilityBo);
                        });
                    }
                });
            }
        });
        return total;
    }

    private void buildReqBO(PebExtOrderListExportReqBO reqBO, Integer tabId, PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO) {
    }
}

