/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.es.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.order.config.UocEsConfig;
import com.tydic.order.impl.es.UocEsQryAbnormalListBusiService;
import com.tydic.order.impl.es.bo.UocEsQryAbnormalListReqBO;
import com.tydic.order.impl.es.bo.UocEsQryAbnormalListRspBO;
import com.tydic.order.impl.es.bo.UocEsQryAbnormalListSingleBO;
import com.tydic.order.impl.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.order.impl.utils.UocElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryAbnormalListBusiService")
public class UocEsQryAbnormalListBusiServiceImpl
implements UocEsQryAbnormalListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryAbnormalListBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryAbnormalListBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryAbnormalListRspBO esQryAbnormalList(UocEsQryAbnormalListReqBO reqBO) {
        UocEsQryAbnormalListRspBO rspBO = new UocEsQryAbnormalListRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryAbnormalEsSql(reqBO);
        LOGGER.debug("ES\u67e5\u8be2\u5f02\u5e38\u5355\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.uocEsConfig.getAbnormalIndexName() + "/" + this.uocEsConfig.getAbnormalIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getAbnormalIndexName());
                if (!index) {
                    LOGGER.error("\u81ea\u52a8\u521b\u5efa\u5f02\u5e38\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("0100");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u5f02\u5e38\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    LOGGER.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u5f02\u5e38\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBO;
                }
            }
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u5f02\u5e38\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            return rspBO;
        }
        System.out.println("ES\u67e5\u8be2\u5f02\u5e38\u5355result---->" + result);
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            this.resovelRetrunCounts(result, rspBO);
        } else {
            this.resovelRetrunData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        }
        return rspBO;
    }

    private void resovelRetrunData(String result, UocEsQryAbnormalListRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f02\u5e38\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<UocEsQryAbnormalListSingleBO> rows = new ArrayList<UocEsQryAbnormalListSingleBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            UocEsQryAbnormalListSingleBO esQryAbnormalListSingleBO = (UocEsQryAbnormalListSingleBO)JSON.toJavaObject((JSON)objJson, UocEsQryAbnormalListSingleBO.class);
            rows.add(esQryAbnormalListSingleBO);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u5f02\u5e38\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }

    public void resovelRetrunCounts(String result, UocEsQryAbnormalListRspBO rspBO) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<Integer, Integer> tabCountsMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            tabCountsMap.put(bucketsObj.getInteger("key"), bucketsObj.getInteger("doc_count"));
        }
        rspBO.setTabCountsMap(tabCountsMap);
    }
}

