/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.es.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.config.UocEsConfig;
import com.tydic.order.impl.es.UocEsQryAbnormalTabNumberBusiService;
import com.tydic.order.impl.es.bo.UocEsQryAbnormalTabNumberReqBO;
import com.tydic.order.impl.es.bo.UocEsQryAbnormalTabNumberRspBO;
import com.tydic.order.impl.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.order.impl.utils.UocElasticsearchUtil;
import java.io.IOException;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryAbnormalTabNumberBusiService")
public class UocEsQryAbnormalTabNumberBusiServiceImpl
implements UocEsQryAbnormalTabNumberBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryAbnormalTabNumberBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryAbnormalTabNumberBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryAbnormalTabNumberRspBO getEsQryAbnormalTabNumber(UocEsQryAbnormalTabNumberReqBO reqBO) {
        UocEsQryAbnormalTabNumberRspBO rspBO = new UocEsQryAbnormalTabNumberRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.countAbnormalTabNumber(reqBO);
        String endPoint = "/" + this.uocEsConfig.getAbnormalIndexName() + "/" + this.uocEsConfig.getAbnormalIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        try {
            LOGGER.debug("ES\u7edf\u8ba1\u5f02\u5e38\u5355\u5217\u8868\u9875\u7b7e\u6570\u91cf\u7ed3\u679csql---->" + qryString);
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("ES\u7edf\u8ba1\u5f02\u5e38\u5355\u5217\u8868\u9875\u7b7e\u6570\u91cf\u7ed3\u679cresult---->" + result);
            rspBO = this.resovelRetrunData(result, rspBO);
        }
        catch (IOException e) {
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("ES\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u7edf\u8ba1\u6570\u91cf\u5f02\u5e38!");
        }
        return rspBO;
    }

    private UocEsQryAbnormalTabNumberRspBO resovelRetrunData(String result, UocEsQryAbnormalTabNumberRspBO rspBO) {
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7edf\u8ba1\u6210\u529f!");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        rspBO.setTabCounts(total);
        return rspBO;
    }
}

