/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.es.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.config.UocEsConfig;
import com.tydic.order.impl.es.UocEsQryOrderTabNumberBusiService;
import com.tydic.order.impl.es.bo.UocEsQryOrderTabNumberReqBO;
import com.tydic.order.impl.es.bo.UocEsQryOrderTabNumberRspBO;
import com.tydic.order.impl.es.impl.UocEsQryOrderListBusiServiceImpl;
import com.tydic.order.impl.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.order.impl.utils.UocElasticsearchUtil;
import java.io.IOException;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryOrderTabNumberBusiService")
public class UocEsQryOrderTabNumberBusiServiceImpl
implements UocEsQryOrderTabNumberBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryOrderListBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryOrderTabNumberBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryOrderTabNumberRspBO getEsQryOrderTabNumber(UocEsQryOrderTabNumberReqBO reqBO) {
        UocEsQryOrderTabNumberRspBO rspBO = new UocEsQryOrderTabNumberRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.countOrderTabNumber(reqBO);
        String endPoint = "/" + this.uocEsConfig.getOrderIndexName() + "/" + this.uocEsConfig.getOrderIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        try {
            LOGGER.debug("ES\u7edf\u8ba1\u8ba2\u5355\u5217\u8868\u9875\u7b7e\u6570\u91cf\u7ed3\u679csql---->" + qryString);
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("ES\u7edf\u8ba1\u8ba2\u5355\u5217\u8868\u9875\u7b7e\u6570\u91cf\u7ed3\u679cresult---->" + result);
            rspBO = this.resovelRetrunData(result, rspBO);
        }
        catch (IOException e) {
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("ES\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u7edf\u8ba1\u6570\u91cf\u5f02\u5e38!");
        }
        return rspBO;
    }

    private UocEsQryOrderTabNumberRspBO resovelRetrunData(String result, UocEsQryOrderTabNumberRspBO rspBO) {
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7edf\u8ba1\u6210\u529f!");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        rspBO.setTabCounts(total);
        return rspBO;
    }
}

