/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.es.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.order.config.UocEsConfig;
import com.tydic.order.impl.es.UocEsQryStatisticsBusiService;
import com.tydic.order.impl.es.bo.UocEsQryStatisticsReqBO;
import com.tydic.order.impl.es.bo.UocEsQryStatisticsRspBO;
import com.tydic.order.impl.es.bo.UocEsStatisticsQueryBO;
import com.tydic.order.impl.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.order.impl.utils.UocElasticsearchUtil;
import com.tydic.order.uoc.dao.StatisticsMapper;
import com.tydic.order.uoc.dao.po.StatisticsPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryStatisticsBusiService")
public class UocEsQryStatisticsBusiServiceImpl
implements UocEsQryStatisticsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocEsQryStatisticsBusiServiceImpl.class);
    private final UocEsConfig uocEsConfig;
    private final UocElasticsearchUtil uocElasticsearchUtil;
    private final UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;
    private final StatisticsMapper statisticsMapper;

    public UocEsQryStatisticsBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil, UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil, StatisticsMapper statisticsMapper) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = buildEsQrySqlContidiontUtil;
        this.statisticsMapper = statisticsMapper;
    }

    @Override
    public UocEsQryStatisticsRspBO esStatisticsQuery(UocEsQryStatisticsReqBO reqBO) {
        UocEsQryStatisticsRspBO rspBO = new UocEsQryStatisticsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String queryString = this.buildEsQrySqlContidiontUtil.buildQryStatisticsEsSql(reqBO);
        log.debug("\u7edf\u8ba1ES\u67e5\u8be2\u8bed\u53e5\u4e3a\uff1a" + queryString);
        String endPoint = "/" + this.uocEsConfig.getStatisticsIndexName() + "/" + this.uocEsConfig.getStatisticsIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getStatisticsIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u7edf\u8ba1\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u7edf\u8ba1\u7d22\u5f15\u5931\u8d25");
                    this.queryBuildRspBO(reqBO, rspBO);
                    return rspBO;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ES\u8c03\u7528\u67e5\u8be2\u7edf\u8ba1\u5217\u8868\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7edf\u8ba1\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    this.queryBuildRspBO(reqBO, rspBO);
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            this.queryBuildRspBO(reqBO, rspBO);
            return rspBO;
        }
        this.resovelRetrunData(result, rspBO, reqBO);
        return rspBO;
    }

    private void resovelRetrunData(String result, UocEsQryStatisticsRspBO rspBO, UocEsQryStatisticsReqBO reqBO) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setRows(new ArrayList(0));
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f!");
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            return;
        }
        ArrayList<UocEsStatisticsQueryBO> rows = new ArrayList<UocEsStatisticsQueryBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            UocEsStatisticsQueryBO statisticsQueryBO = (UocEsStatisticsQueryBO)JSON.toJavaObject((JSON)data, UocEsStatisticsQueryBO.class);
            rows.add(statisticsQueryBO);
        }
        int pageSize = reqBO.getPageSize();
        int pageNo = reqBO.getPageNo();
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }

    private void queryBuildRspBO(UocEsQryStatisticsReqBO reqBO, UocEsQryStatisticsRspBO rspBO) {
        StatisticsPO statisticsPO = new StatisticsPO();
        if (null != reqBO.getStatisticsType()) {
            statisticsPO.setStatisticsType(reqBO.getStatisticsType());
        }
        statisticsPO.setStatisticsQuantityMore(Integer.valueOf(0));
        statisticsPO.setOrderBy("statistics_amount desc");
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        List statisticsPOS = this.statisticsMapper.getListPage(statisticsPO, page);
        if (CollectionUtils.isNotEmpty((Collection)statisticsPOS)) {
            rspBO.setRows(JSONObject.parseArray((String)JSON.toJSONString((Object)statisticsPOS), UocEsStatisticsQueryBO.class));
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
    }
}

