/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.es.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.order.bo.es.UocEsSyncStatisticsReqBO;
import com.tydic.order.config.UocEsConfig;
import com.tydic.order.impl.es.UocEsSyncStatisticsBusiService;
import com.tydic.order.impl.es.bo.UocEsSyncStatisticsRspBO;
import com.tydic.order.impl.utils.UocElasticsearchUtil;
import com.tydic.order.uoc.dao.StatisticsMapper;
import com.tydic.order.uoc.dao.po.StatisticsPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsSyncStatisticsBusiService")
public class UocEsSyncStatisticsBusiServiceImpl
implements UocEsSyncStatisticsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncStatisticsBusiServiceImpl.class);
    private final UocEsConfig uocEsConfig;
    private final UocElasticsearchUtil uocElasticsearchUtil;
    private final StatisticsMapper statisticsMapper;

    @Autowired
    public UocEsSyncStatisticsBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil, StatisticsMapper statisticsMapper) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.statisticsMapper = statisticsMapper;
    }

    @Override
    public UocEsSyncStatisticsRspBO syncStatistics(UocEsSyncStatisticsReqBO reqBO) {
        StatisticsPO po;
        UocEsSyncStatisticsRspBO rspBO = new UocEsSyncStatisticsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (0L == reqBO.getId()) {
            StatisticsPO statisticsPO = new StatisticsPO();
            this.statisticsMapper.deleteBy(statisticsPO);
            boolean index = this.uocElasticsearchUtil.deleteIndex(this.uocEsConfig.getStatisticsIndexName());
            if (!index) {
                log.error("\u5168\u91cf\u540c\u6b65\uff0c\u5220\u9664\u7edf\u8ba1ES\u7d22\u5f15\u5931\u8d25");
                rspBO.setRespCode("0100");
                rspBO.setRespDesc("\u5168\u91cf\u540c\u6b65\uff0c\u5220\u9664\u7edf\u8ba1ES\u7d22\u5f15\u5931\u8d25");
                return rspBO;
            }
            return rspBO;
        }
        StatisticsPO statisticsPO = new StatisticsPO();
        statisticsPO.setId(reqBO.getId());
        int checkBy = this.statisticsMapper.getCheckBy(statisticsPO);
        if (checkBy > 0) {
            po = (StatisticsPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), StatisticsPO.class);
            this.statisticsMapper.updateById(po);
        } else {
            po = (StatisticsPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), StatisticsPO.class);
            try {
                this.statisticsMapper.insert(po);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u6570\u636e\u5e93\u7edf\u8ba1\u4e00\u6b21\u540c\u6b65\u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
                checkBy = this.statisticsMapper.getCheckBy(statisticsPO);
                if (checkBy > 0) {
                    this.statisticsMapper.updateById(po);
                }
                log.error("\u540c\u6b65\u6570\u636e\u5e93\u7edf\u8ba1\u4e8c\u6b21\u540c\u6b65\u5931\u8d25");
                rspBO.setRespCode("0100");
                rspBO.setRespDesc("\u540c\u6b65\u6570\u636e\u5e93\u7edf\u8ba1\u4e8c\u6b21\u540c\u6b65\u5931\u8d25");
                return rspBO;
            }
        }
        statisticsPO = this.statisticsMapper.getModelBy(statisticsPO);
        if (null == statisticsPO) {
            log.error("\u540c\u6b65ES\u7edf\u8ba1\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u540c\u6b65ES\u7edf\u8ba1\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        Boolean aBoolean = this.addStatisticsList(statisticsPO);
        if (!aBoolean.booleanValue()) {
            log.error("\u540c\u6b65ES\u7edf\u8ba1\u5931\u8d25");
            rspBO.setRespCode("0100");
            rspBO.setRespDesc("\u540c\u6b65ES\u7edf\u8ba1\u5931\u8d25");
            return rspBO;
        }
        return rspBO;
    }

    private Boolean addStatisticsList(StatisticsPO statisticsPO) {
        boolean addResult = false;
        String jsonStr = JSONObject.toJSONString((Object)statisticsPO);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String id = this.uocElasticsearchUtil.addData(this.uocEsConfig.getStatisticsIndexName(), this.uocEsConfig.getStatisticsIndexType(), String.valueOf(statisticsPO.getId()), jsonObject);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            addResult = true;
        }
        return addResult;
    }
}

