/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.annotation.OrderFlowLog;
import com.tydic.uoc.common.ability.api.PebExtApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.api.PebOrderApprovalAbilityService;
import com.tydic.uoc.common.ability.api.UocApprovalOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebExtApprovalOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebExtDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtSendMessageReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderApprovalRspBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderReqBO;
import com.tydic.uoc.common.ability.bo.UocApprovalOrderRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtApprovalOrderAbilityService"})
public class PebExtApprovalOrderAbilityServiceImpl
implements PebExtApprovalOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtApprovalOrderAbilityServiceImpl.class);
    @Autowired
    private PebOrderApprovalAbilityService pebOrderApprovalAbilityService;
    @Autowired
    private UocApprovalOrderAbilityService uocApprovalOrderAbilityService;
    @Value(value="${UOC_NOTIFY_ORDER_TOPIC}")
    private String notifyTopic;
    @Value(value="${UOC_NOTIFY_ORDER_TAG}")
    private String notifyTag;
    @Resource(name="notifyOrderMsgProvider")
    private ProxyMessageProducer notifyOrderMsgProvider;

    @OrderFlowLog(operationLink="\u8ba2\u5355\u5ba1\u6279", description="\u8ba2\u5355\u5ba1\u6279")
    @PostMapping(value={"dealApprovalOrder"})
    public PebExtApprovalOrderRspBO dealApprovalOrder(@RequestBody PebExtApprovalOrderReqBO reqBO) {
        this.val(reqBO);
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        PebExtApprovalOrderRspBO rspBO = new PebExtApprovalOrderRspBO();
        String jsonStr = JSON.toJSONString((Object)reqBO);
        PebExtSendMessageReqBO pebExtSendMessageReqBO = (PebExtSendMessageReqBO)JSON.parseObject((String)jsonStr, PebExtSendMessageReqBO.class);
        if (PebExtConstant.pageType.ZONE_SALE.equals(reqBO.getPageType()) || PebExtConstant.pageType.NOT_AGR.equals(reqBO.getPageType())) {
            PebOrderApprovalReqBO pebOrderApprovalReqBO = (PebOrderApprovalReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebOrderApprovalReqBO.class);
            if ("1".equals(reqBO.getFlag())) {
                pebOrderApprovalReqBO.setAuditResult(Integer.valueOf("0"));
            } else if ("0".equals(reqBO.getFlag())) {
                pebOrderApprovalReqBO.setAuditResult(Integer.valueOf("1"));
            }
            pebOrderApprovalReqBO.setActionCode("ACTPEB007");
            pebOrderApprovalReqBO.setApprovalRemark(reqBO.getDealDesc());
            pebOrderApprovalReqBO.setOperId(reqBO.getUserId() + "");
            pebOrderApprovalReqBO.setOperName(reqBO.getUsername());
            pebOrderApprovalReqBO.setOperDept(reqBO.getOrgName());
            ArrayList<PebDealOrderBO> orderApprovalList = new ArrayList<PebDealOrderBO>();
            for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
                PebDealOrderBO pebDealOrderBO = new PebDealOrderBO();
                BeanUtils.copyProperties((Object)pebExtDealOrderBO, (Object)pebDealOrderBO);
                if (null != pebExtDealOrderBO.getStepId() && 0L != pebExtDealOrderBO.getStepId()) {
                    pebDealOrderBO.setStepId(pebExtDealOrderBO.getStepId().toString());
                }
                orderApprovalList.add(pebDealOrderBO);
            }
            pebOrderApprovalReqBO.setOrderApprovalList(orderApprovalList);
            PebOrderApprovalRspBO pebOrderApprovalRspBO = this.pebOrderApprovalAbilityService.dealPebOrderApproval(pebOrderApprovalReqBO);
            if (!"0000".equals(pebOrderApprovalRspBO.getRespCode())) {
                throw new UocProBusinessException(pebOrderApprovalRspBO.getRespCode(), pebOrderApprovalRspBO.getRespDesc());
            }
            pebExtSendMessageReqBO.setOrderType(reqBO.getPageType());
        } else if (PebExtConstant.pageType.ES_SALE.equals(reqBO.getPageType())) {
            UocApprovalOrderReqBO uocApprovalOrderReqBO = (UocApprovalOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), UocApprovalOrderReqBO.class);
            UocApprovalOrderRspBO uocApprovalOrderRspBO = this.uocApprovalOrderAbilityService.dealApprovalOrder(uocApprovalOrderReqBO);
            if (!"0000".equals(uocApprovalOrderRspBO.getRespCode())) {
                throw new UocProBusinessException(uocApprovalOrderRspBO.getRespCode(), uocApprovalOrderRspBO.getRespDesc());
            }
            pebExtSendMessageReqBO.setOrderType(PebExtConstant.NOTIFY_ORDER_TYPE.ORDER_STORE);
        }
        List orderInfo = reqBO.getOrderInfo();
        orderInfo.forEach(order -> {
            pebExtSendMessageReqBO.setOrderId(order.getOrderId());
            if ("1".equals(reqBO.getFlag())) {
                pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_APPROVE);
            } else {
                pebExtSendMessageReqBO.setNotifyBusiness(PebExtConstant.NOTIFY_BUSINESS.ORDER_APPROVE_REFUSED);
            }
            pebExtSendMessageReqBO.setNotifyType(PebExtConstant.NOTIFY_TYPE.ORDER_NOTIFY);
            pebExtSendMessageReqBO.setUserId(reqBO.getUserId());
            pebExtSendMessageReqBO.setPushTime(DateUtil.formatDate((Date)new Date()));
            this.notifyOrderMsgProvider.send(new ProxyMessage(this.notifyTopic, this.notifyTag, JSONObject.toJSONString((Object)pebExtSendMessageReqBO)));
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(PebExtApprovalOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPageType()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2pageType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFlag())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2flag\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderInfo())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2orderInfo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (PebExtDealOrderBO pebExtDealOrderBO : reqBO.getOrderInfo()) {
            if (null == pebExtDealOrderBO.getOrderId() || 0L == pebExtDealOrderBO.getOrderId()) {
                throw new UocProBusinessException("100001", "\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != pebExtDealOrderBO.getSaleVoucherId() && 0L != pebExtDealOrderBO.getSaleVoucherId()) continue;
            throw new UocProBusinessException("100001", "\u5165\u53c2saleVoucherId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

