/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderAdjustPriceAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderAdjustPriceReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderAdjustPriceRspBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemAdjustBO;
import com.tydic.uoc.common.busi.api.PebOrderAdjustPriceBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderAdjustPriceAbilityService"})
public class PebOrderAdjustPriceAbilityServiceImpl
implements PebOrderAdjustPriceAbilityService {
    private static final Integer CONFIRM = 1;
    @Autowired
    private PebOrderAdjustPriceBusiService pebOrderAdjustPriceBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;

    @PostMapping(value={"dealPebOrderAdjustPrice"})
    public PebOrderAdjustPriceRspBO dealPebOrderAdjustPrice(@RequestBody PebOrderAdjustPriceReqBO reqBO) {
        PebOrderAdjustPriceRspBO rspBO;
        this.val(reqBO);
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        if ("0000".equals((rspBO = this.pebOrderAdjustPriceBusiService.dealPebOrderAdjustPrice(reqBO)).getRespCode())) {
            this.idxSync(reqBO);
        }
        return rspBO;
    }

    private void idxSync(PebOrderAdjustPriceReqBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
    }

    private void val(PebOrderAdjustPriceReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new UocProBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmFlag() == null) {
            reqBO.setConfirmFlag(CONFIRM);
        }
        if (CONFIRM.equals(reqBO.getConfirmFlag())) {
            List orderItemAdjustList = reqBO.getOrderItemAdjustList();
            if (CollectionUtils.isEmpty((Collection)orderItemAdjustList)) {
                throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (PebOrderItemAdjustBO bo : orderItemAdjustList) {
                if (ObjectUtil.isEmpty((Object)bo.getMarkUpRateNew())) {
                    throw new UocProBusinessException("100001", "markUpRateNew\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)bo.getPurchasingPriceNew())) {
                    throw new UocProBusinessException("100001", "purchasingPriceNew\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)bo.getSaleOrderItemId())) {
                    throw new UocProBusinessException("100001", "saleOrderItemId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)bo.getSalePriceNew())) continue;
                throw new UocProBusinessException("100001", "salePriceNew\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

