/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocProOrderEffectiveListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.ability.bo.UocProOrderEffectiveInfoBo;
import com.tydic.uoc.common.ability.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.uoc.common.atom.bo.DicValAndpCodeBO;
import com.tydic.uoc.common.atom.bo.SelectDicValBypCodesReqBO;
import com.tydic.uoc.common.atom.bo.SelectDicValBypCodesRspBO;
import com.tydic.uoc.common.busi.api.SelectDicValBypCodesBusiService;
import com.tydic.uoc.dao.ConfEffectiveMapper;
import com.tydic.uoc.po.ConfEffectivePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderEffectiveListPageQueryAbilityService"})
public class UocProOrderEffectiveListPageQueryAbilityServiceImpl
implements UocProOrderEffectiveListPageQueryAbilityService {
    @Autowired
    private ConfEffectiveMapper confEffectiveMapper;
    @Autowired
    private SelectDicValBypCodesBusiService selectDicValBypCodesBusiService;

    @PostMapping(value={"queryOrderEffectiveListPage"})
    public UocProOrderEffectiveListPageQueryRspBo queryOrderEffectiveListPage(@RequestBody UocProOrderEffectiveListPageQueryReqBo reqBo) {
        UocProOrderEffectiveListPageQueryRspBo rspBo = new UocProOrderEffectiveListPageQueryRspBo();
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        ConfEffectivePO effectivePOWhere = new ConfEffectivePO();
        Map<String, String> effectiveNameMap = null;
        if (null != reqBo.getEffectiveId() && 0L != reqBo.getEffectiveId()) {
            effectivePOWhere.setEffectiveId(reqBo.getEffectiveId());
        } else {
            if (StringUtils.hasText((String)reqBo.getEffectiveName())) {
                DicValAndpCodeBO effectiveName = this.getEffectiveCodeListByEffectiveName();
                if (null == effectiveName || CollectionUtils.isEmpty(effectiveName.getDicDictionaries())) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList(0));
                    return rspBo;
                }
                effectiveNameMap = new HashMap<String, String>(effectiveName.getDicDictionaries().size());
                ArrayList<String> effectiveCodeList = new ArrayList<String>();
                for (DicDictionaryBO dicDictionaryBO : effectiveName.getDicDictionaries()) {
                    if (null == dicDictionaryBO.getDescrip() || !dicDictionaryBO.getDescrip().contains(reqBo.getEffectiveName())) continue;
                    effectiveCodeList.add(dicDictionaryBO.getCode());
                    effectiveNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                }
                if (CollectionUtils.isEmpty(effectiveCodeList)) {
                    rspBo.setTotal(0);
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList(0));
                    return rspBo;
                }
                effectivePOWhere.setEffectiveCodeList(effectiveCodeList);
            }
            effectivePOWhere.setBusinessTypeCode(reqBo.getBusinessTypeCode());
            effectivePOWhere.setSupplierNo(reqBo.getSupplierNo());
            effectivePOWhere.setSourceCode(reqBo.getSourceCode());
            effectivePOWhere.setOperatingTimeStart(DateUtils.strToDateLong((String)reqBo.getOperatingTimeStart()));
            effectivePOWhere.setOperatingTimeEnd(DateUtils.strToDateLong((String)reqBo.getOperatingTimeEnd()));
            effectivePOWhere.setOperatorName(reqBo.getOperatorName());
        }
        effectivePOWhere.setOrderBy("effective_code, source_code,case business_type_code when '2' then 1 when '1' then 2 else 3 end");
        Page confEffectivePOPage = new Page();
        confEffectivePOPage.setPageNo(reqBo.getPageNo());
        confEffectivePOPage.setPageSize(reqBo.getPageSize());
        List effectivePOList = this.confEffectiveMapper.getListPage(effectivePOWhere, confEffectivePOPage);
        if (CollectionUtils.isEmpty((Collection)effectivePOList)) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList(0));
        } else {
            rspBo.setTotal(confEffectivePOPage.getTotalPages());
            rspBo.setRecordsTotal(confEffectivePOPage.getTotalCount());
            ArrayList<UocProOrderEffectiveInfoBo> rows = new ArrayList<UocProOrderEffectiveInfoBo>(effectivePOList.size());
            List<Map<String, String>> dicValName = this.getDicValName(effectiveNameMap);
            effectiveNameMap = dicValName.get(0);
            Map<String, String> businessTypeMap = dicValName.get(1);
            Map<String, String> sourceNameMap = dicValName.get(2);
            ConfEffectivePO effective1PO = new ConfEffectivePO();
            effective1PO.setEffectiveCode("1");
            effective1PO.setBusinessTypeCode("2");
            effective1PO.setOrderBy("aging");
            Page confEffective1POPage = new Page();
            confEffective1POPage.setPageNo(1);
            confEffective1POPage.setPageSize(1);
            List effectivePOS = this.confEffectiveMapper.getListPage(effective1PO, confEffective1POPage);
            Long minAge = effectivePOS.stream().map(ConfEffectivePO::getAging).min(new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            }).get();
            for (ConfEffectivePO effectivePO : effectivePOList) {
                UocProOrderEffectiveInfoBo orderEffectiveInfoBo = new UocProOrderEffectiveInfoBo();
                orderEffectiveInfoBo.setEffectiveId(effectivePO.getEffectiveId());
                orderEffectiveInfoBo.setEffectiveCode(effectivePO.getEffectiveCode());
                orderEffectiveInfoBo.setBusinessTypeCode(effectivePO.getBusinessTypeCode());
                orderEffectiveInfoBo.setSupplierNo(effectivePO.getSupplierNo());
                orderEffectiveInfoBo.setSupplierName(effectivePO.getSupplierName());
                orderEffectiveInfoBo.setAging(effectivePO.getAging());
                orderEffectiveInfoBo.setSourceCode(effectivePO.getSourceCode());
                orderEffectiveInfoBo.setOperatingTime(effectivePO.getOperatingTime());
                orderEffectiveInfoBo.setOperatorId(effectivePO.getOperatorId());
                orderEffectiveInfoBo.setOperatorName(effectivePO.getOperatorName());
                if (orderEffectiveInfoBo.getEffectiveCode().equals("2") && orderEffectiveInfoBo.getBusinessTypeCode().equals("2")) {
                    orderEffectiveInfoBo.setMinAging(minAge);
                }
                if (null != effectiveNameMap) {
                    orderEffectiveInfoBo.setEffectiveName(effectiveNameMap.get(effectivePO.getEffectiveCode()));
                }
                if (null != businessTypeMap) {
                    orderEffectiveInfoBo.setBusinessTypeName(businessTypeMap.get(effectivePO.getBusinessTypeCode()));
                }
                if (null != sourceNameMap) {
                    orderEffectiveInfoBo.setSourceName(sourceNameMap.get(effectivePO.getSourceCode()));
                }
                rows.add(orderEffectiveInfoBo);
            }
            rspBo.setRows(rows);
        }
        return rspBo;
    }

    private DicValAndpCodeBO getEffectiveCodeListByEffectiveName() {
        SelectDicValBypCodesReqBO selectDicValBypCodesReqBO = new SelectDicValBypCodesReqBO();
        selectDicValBypCodesReqBO.setPCodes(Collections.singletonList("EFFECTIVE_CODE"));
        SelectDicValBypCodesRspBO selectDicValBypCodesRspBO = this.selectDicValBypCodesBusiService.selectDicValBypCodes(selectDicValBypCodesReqBO);
        if (!"0000".equals(selectDicValBypCodesRspBO.getRespCode())) {
            throw new UocProBusinessException(selectDicValBypCodesRspBO.getRespCode(), selectDicValBypCodesRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty(selectDicValBypCodesRspBO.getDicValAndpCodeBOs())) {
            return null;
        }
        return selectDicValBypCodesRspBO.getDicValAndpCodeBOs().get(0).get("EFFECTIVE_CODE");
    }

    private List<Map<String, String>> getDicValName(Map<String, String> effectiveNameMap) {
        HashMap<String, String> businessTypeMap = null;
        HashMap<String, String> sourceNameMap = null;
        SelectDicValBypCodesReqBO selectDicValBypCodesReqBO = new SelectDicValBypCodesReqBO();
        ArrayList<String> pCodes = new ArrayList<String>();
        if (null == effectiveNameMap) {
            pCodes.add("EFFECTIVE_CODE");
        }
        pCodes.add("ORDER_SOURCE");
        pCodes.add("SOURCE_CODE");
        selectDicValBypCodesReqBO.setPCodes(pCodes);
        SelectDicValBypCodesRspBO selectDicValBypCodesRspBO = this.selectDicValBypCodesBusiService.selectDicValBypCodes(selectDicValBypCodesReqBO);
        if (!"0000".equals(selectDicValBypCodesRspBO.getRespCode())) {
            throw new UocProBusinessException(selectDicValBypCodesRspBO.getRespCode(), selectDicValBypCodesRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty(selectDicValBypCodesRspBO.getDicValAndpCodeBOs())) {
            for (Map<String, DicValAndpCodeBO> dicValAndpCodeBOMap : selectDicValBypCodesRspBO.getDicValAndpCodeBOs()) {
                if (null == dicValAndpCodeBOMap || dicValAndpCodeBOMap.size() <= 0) continue;
                for (Map.Entry<String, DicValAndpCodeBO> dicValAndpCodeBO : dicValAndpCodeBOMap.entrySet()) {
                    DicValAndpCodeBO value = dicValAndpCodeBO.getValue();
                    if (CollectionUtils.isEmpty(value.getDicDictionaries())) continue;
                    if ("EFFECTIVE_CODE".equals(dicValAndpCodeBO.getKey())) {
                        if (null == effectiveNameMap) {
                            effectiveNameMap = new HashMap<String, String>(value.getDicDictionaries().size());
                        }
                        for (DicDictionaryBO dicDictionaryBO : value.getDicDictionaries()) {
                            effectiveNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                        }
                        continue;
                    }
                    if ("ORDER_SOURCE".equals(dicValAndpCodeBO.getKey())) {
                        if (null == businessTypeMap) {
                            businessTypeMap = new HashMap<String, String>(value.getDicDictionaries().size());
                        }
                        for (DicDictionaryBO dicDictionaryBO : value.getDicDictionaries()) {
                            businessTypeMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                        }
                        continue;
                    }
                    if (!"SOURCE_CODE".equals(dicValAndpCodeBO.getKey())) continue;
                    if (null == sourceNameMap) {
                        sourceNameMap = new HashMap<String, String>(value.getDicDictionaries().size());
                    }
                    for (DicDictionaryBO dicDictionaryBO : value.getDicDictionaries()) {
                        sourceNameMap.put(dicDictionaryBO.getCode(), dicDictionaryBO.getDescrip());
                    }
                }
            }
        }
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(3);
        mapList.add(effectiveNameMap);
        mapList.add(businessTypeMap);
        mapList.add(sourceNameMap);
        return mapList;
    }
}

