/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocCoreCompletePayOrderAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreCompletePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCompletePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrderPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreCompletePayOrderAtomService")
public class UocCoreCompletePayOrderAtomServiceImpl
implements UocCoreCompletePayOrderAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocCoreCompletePayOrderAtomServiceImpl.class);
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private OrdPayItemMapper ordPayItemMapper;
    @Autowired
    private OrderMapper orderMapper;

    @Override
    public UocCoreCompletePayOrderRspBO dealCoreCompletePayOrder(UocCoreCompletePayOrderReqBO reqBO) {
        this.validParam(reqBO);
        UocCoreCompletePayOrderRspBO rspBO = new UocCoreCompletePayOrderRspBO();
        OrdPayPO selectPayPO = new OrdPayPO();
        selectPayPO.setOrderId(reqBO.getOrderId());
        selectPayPO.setPayVoucherId(reqBO.getPayVoucherId());
        try {
            boolean validState;
            selectPayPO = this.ordPayMapper.getModelBy(selectPayPO);
            if (selectPayPO == null) {
                rspBO.setRespCode("101013");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u652f\u4ed8\u8ba2\u5355");
                return rspBO;
            }
            boolean bl = validState = UocConstant.PAY_ORDER_STATUS.CREATE.equals(selectPayPO.getPayState()) || UocConstant.PAY_ORDER_STATUS.UNPAID.equals(selectPayPO.getPayState()) || UocConstant.PAY_ORDER_STATUS.IN_PAYMENT.equals(selectPayPO.getPayState());
            if (!validState) {
                rspBO.setRespCode("101013");
                rspBO.setRespDesc("\u8be5\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u6709\u8bef\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
                return rspBO;
            }
            OrdPayPO updatePayPO = new OrdPayPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)updatePayPO);
            updatePayPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            updatePayPO.setPayOperId(reqBO.getCreateOperId());
            updatePayPO.setPayTime(new Date());
            this.ordPayMapper.updateById(updatePayPO);
            if (reqBO.getUocOrderPayItemList() != null && reqBO.getUocOrderPayItemList().size() > 0) {
                for (UocOrderPayItemBO itemBO : reqBO.getUocOrderPayItemList()) {
                    OrdPayItemPO ordPayItemPO = new OrdPayItemPO();
                    BeanUtils.copyProperties((Object)itemBO, (Object)ordPayItemPO);
                    this.ordPayItemMapper.updateById(ordPayItemPO);
                }
            }
            OrderPO orderPO = new OrderPO();
            orderPO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
            orderPO.setOrderId(reqBO.getOrderId());
            this.orderMapper.updateById(orderPO);
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u5b8c\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("101013");
            rspBO.setRespDesc("\u652f\u4ed8\u5b8c\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u652f\u4ed8\u5b8c\u6210");
        return rspBO;
    }

    private void validParam(UocCoreCompletePayOrderReqBO reqBO) {
        if (reqBO == null || reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPayVoucherId() == null) {
            throw new UocProBusinessException("100002", "\u652f\u4ed8\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("100002", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUocOrderPayItemList() != null && reqBO.getUocOrderPayItemList().size() > 0) {
            for (UocOrderPayItemBO itemBO : reqBO.getUocOrderPayItemList()) {
                if (itemBO.getPayItemId() == null) {
                    throw new UocProBusinessException("100002", "\u652f\u4ed8\u660e\u7ec6Id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBO.getOrdItemId() == null) {
                    throw new UocProBusinessException("100002", "\u9500\u552e\u660e\u7ec6Id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBO.getPayVoucherId() == null) {
                    throw new UocProBusinessException("100002", "\u660e\u7ec6\u5217\u8868\u4e2d\u652f\u4ed8\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (itemBO.getOrderId() != null) continue;
                throw new UocProBusinessException("100002", "\u660e\u7ec6\u5217\u8868\u4e2d\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

