/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfOrderPayAbilityService;
import com.tydic.uoc.busibase.busi.bo.FscOrderPayReqBO;
import com.tydic.uoc.busibase.busi.bo.FscOrderPayRspBO;
import com.tydic.uoc.common.ability.bo.OrdStakeholderRspBO;
import com.tydic.uoc.common.atom.api.UocCoreQryOrderDetailAtomService;
import com.tydic.uoc.common.atom.api.UocCreateOrderConsumerReflectAtomService;
import com.tydic.uoc.common.atom.api.UocPebACPayAtomService;
import com.tydic.uoc.common.atom.api.UocPebAddSaleNumAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocPebCommCallIntfRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreOryOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreQryOrderDetailRspBO;
import com.tydic.uoc.common.atom.bo.UocPebAddSaleNumReqBO;
import com.tydic.uoc.common.atom.bo.UocPebAddSaleNumRespBO;
import com.tydic.uoc.common.atom.bo.UocPebCommCallIntfReqAtomBO;
import com.tydic.uoc.common.atom.impl.InterfaceLogBase;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocPebACPayAtomServiceImpl
extends InterfaceLogBase
implements UocPebACPayAtomService,
UocCreateOrderConsumerReflectAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UocPebACPayAtomServiceImpl.class);
    @Autowired
    private UocCoreQryOrderDetailAtomService qryOrderDetailAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Autowired
    private PebIntfOrderPayAbilityService pebIntfOrderPayAbilityService;
    @Autowired
    private UocPebAddSaleNumAtomService uocPebAddSaleNumAtomService;

    @Override
    public AtomUocPebCommCallIntfRspBO dealACPay(UocPebCommCallIntfReqAtomBO reqBO) {
        Long orderId = reqBO.getOrderId();
        if (orderId == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new UocProBusinessException("100002", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AtomUocPebCommCallIntfRspBO rspBO = new AtomUocPebCommCallIntfRspBO();
        try {
            FscOrderPayRspBO orderPayRspBO;
            OrdSalePO ordSalePo = new OrdSalePO();
            ordSalePo.setOrderId(orderId);
            ordSalePo = this.ordSaleMapper.getModelBy(ordSalePo);
            if (ordSalePo == null) {
                rspBO.setRespCode("101055");
                rspBO.setRespDesc("\u6839\u636eorderId\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355");
                return rspBO;
            }
            OrdPayPO ordPayPo = new OrdPayPO();
            ordPayPo.setOrderId(orderId);
            if (UocConstant.OBJ_TYPE.ABNORMAL.equals(reqBO.getObjType())) {
                ordPayPo.setObjId(reqBO.getObjId());
            } else {
                ordPayPo.setObjId(ordSalePo.getSaleVoucherId());
            }
            OrdPayPO modelBy = null;
            try {
                modelBy = this.ordPayMapper.getModelBy(ordPayPo);
            }
            catch (Exception e) {
                e.printStackTrace();
                rspBO.setRespCode("101055");
                rspBO.setRespDesc("\u6839\u636eorderId\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u5355");
                return rspBO;
            }
            if (modelBy == null) {
                rspBO.setRespCode("101055");
                rspBO.setRespDesc("\u6839\u636eorderId\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u5355");
                return rspBO;
            }
            if (!StringUtils.isBlank((CharSequence)reqBO.getReqContentJson())) {
                FscOrderPayReqBO orderPayReqBO = (FscOrderPayReqBO)JSONObject.parseObject((String)reqBO.getReqContentJson(), FscOrderPayReqBO.class);
                this.callIntfLogBegin(reqBO, orderPayReqBO);
                orderPayRspBO = this.pebIntfOrderPayAbilityService.makingOrderPay(orderPayReqBO);
                this.insertCallIntfLog(orderPayRspBO.getRespCode(), orderPayRspBO);
            } else {
                UocCoreOryOrderReqBO qryOrderReqBO = new UocCoreOryOrderReqBO();
                qryOrderReqBO.setOrderId(orderId);
                qryOrderReqBO.setSaleVoucherId(ordSalePo.getSaleVoucherId());
                UocCoreQryOrderDetailRspBO qryOrderRspBO = this.qryOrderDetailAtomService.qryCoreQryOrderDetail(qryOrderReqBO);
                if ("0000".equals(qryOrderRspBO.getRespCode())) {
                    OrdStakeholderRspBO stakeholderRspBO = qryOrderRspBO.getOrdStakeholderRspBO();
                    FscOrderPayReqBO orderPayReqBO = new FscOrderPayReqBO();
                    orderPayReqBO.setSaleOrderCode(ordSalePo.getSaleVoucherNo());
                    orderPayReqBO.setOrderNo(String.valueOf(qryOrderRspBO.getOrdSaleRspBO().getSaleVoucherId()));
                    if (UocConstant.OBJ_TYPE.ABNORMAL.equals(reqBO.getObjType())) {
                        orderPayReqBO.setOrderAmt(reqBO.getFee());
                    } else {
                        orderPayReqBO.setOrderAmt(qryOrderRspBO.getOrderRspBO().getTotalSaleMoney());
                    }
                    if (modelBy.getPreFee() != null && modelBy.getPreFee() != 0L) {
                        orderPayReqBO.setOrderAmt(UocMoneyUtil.long2BigDecimal((Long)modelBy.getPreFee()));
                    }
                    orderPayReqBO.setSource(qryOrderRspBO.getOrdSaleRspBO().getOrderSource());
                    orderPayReqBO.setSupplierNo(stakeholderRspBO.getSupNo());
                    orderPayReqBO.setPurchaseUnitNo(Long.valueOf(stakeholderRspBO.getPurAccountOwnId()));
                    orderPayReqBO.setPurchaseBookNo(Long.valueOf(stakeholderRspBO.getPurAccount()));
                    orderPayReqBO.setOperatingUnitNo(Long.valueOf(stakeholderRspBO.getProNo()));
                    orderPayReqBO.setBusinessType(PecConstant.BUSINESS_TYPE_PAY);
                    orderPayReqBO.setAnyPayFlag(Integer.valueOf(1));
                    if (logger.isDebugEnabled()) {
                        // empty if block
                    }
                    this.callIntfLogBegin(reqBO, orderPayReqBO);
                    orderPayRspBO = this.pebIntfOrderPayAbilityService.makingOrderPay(orderPayReqBO);
                    this.insertCallIntfLog(orderPayRspBO.getRespCode(), orderPayRspBO);
                } else {
                    rspBO.setRespCode("101055");
                    rspBO.setRespDesc(qryOrderRspBO.getRespDesc());
                    return rspBO;
                }
            }
            if (logger.isDebugEnabled()) {
                // empty if block
            }
            if (null != orderPayRspBO.getIsSuccess() && orderPayRspBO.getIsSuccess().booleanValue()) {
                OrdPayPO updatePO = new OrdPayPO();
                updatePO.setOrderId(orderId);
                updatePO.setOutPayOrderNo(orderPayRspBO.getTxnNo());
                updatePO.setPayTime(new Date());
                updatePO.setPayVoucherId(modelBy.getPayVoucherId());
                int i = this.ordPayMapper.updateById(updatePO);
                if (i <= 0) {
                    rspBO.setRespCode("101055");
                    rspBO.setRespDesc("\u66f4\u65b0\u652f\u4ed8\u5916\u90e8\u6d41\u6c34\u5931\u8d25");
                    return rspBO;
                }
                UocPebAddSaleNumReqBO uocPebAddSaleNumReqBO = new UocPebAddSaleNumReqBO();
                uocPebAddSaleNumReqBO.setOrderId(orderId);
                uocPebAddSaleNumReqBO.setPayVoucherId(modelBy.getPayVoucherId());
                uocPebAddSaleNumReqBO.setInterType(0);
                UocPebAddSaleNumRespBO uocPebAddSaleNumRespBO = this.uocPebAddSaleNumAtomService.dealAddSaleNum(uocPebAddSaleNumReqBO);
                if (!"0000".equals(uocPebAddSaleNumRespBO.getRespCode())) {
                    this.insertCallIntfLog(uocPebAddSaleNumRespBO.getRespCode(), (Object)uocPebAddSaleNumRespBO);
                    logger.error("\u7535\u5b50\u8d85\u5e02\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u6210\u529f,\u4f46\u8c03\u7528\u5546\u54c1\u9500\u552e\u7edf\u8ba1\u539f\u5b50\u670d\u52a1\u5931\u8d25");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u6210\u529f");
            } else {
                rspBO.setRespCode("101055");
                rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5f02\u5e38!" + orderPayRspBO.getRespDesc());
            }
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("101055");
            rspBO.setRespDesc("\u7535\u5b50\u8d85\u5e02\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
    }

    @Override
    public AtomUocPebCommCallIntfRspBO invokeMethod(UocPebCommCallIntfReqAtomBO reqBo) {
        return this.dealACPay(reqBo);
    }

    @Override
    public String getInterCode() {
        return "PcChargebacksRequest";
    }
}

