/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.AccessoryBO;
import com.tydic.uoc.common.ability.bo.PebOrderAdjustPriceReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderAdjustPriceRspBO;
import com.tydic.uoc.common.ability.bo.PebOrderItemAdjustBO;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.PebOrderAdjustPriceBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdItemWtLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdSaleMtLogMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdItemWtLogPO;
import com.tydic.uoc.po.OrdSaleMtLogPO;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebOrderAdjustPriceBusiServiceImpl
implements PebOrderAdjustPriceBusiService {
    private static final Integer CONFIRM = 1;
    private static final Integer SKIP_ADJUST_PRICE_TYPE_YES = 1;
    private static final Integer SKIP_ADJUST_PRICE_TYPE_NO = 0;
    @Autowired
    PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private OrderGenerateIdUtil orderGenerateIdUtil;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdItemWtLogMapper ordItemWtLogMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdSaleMtLogMapper ordSaleMtLogMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;

    @Override
    public PebOrderAdjustPriceRspBO dealPebOrderAdjustPrice(PebOrderAdjustPriceReqBO reqBO) {
        if (reqBO.getConfirmFlag() == null) {
            reqBO.setConfirmFlag(CONFIRM);
        }
        if (reqBO.getAuthCtrl() == null) {
            reqBO.setAuthCtrl(UocCoreConstant.AuthCtrl.NOT);
        }
        reqBO.setActionCode("ACTPEB009");
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getSaleVoucherId());
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheckAtomRspBO = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheckAtomRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        if (!UocCoreConstant.AuthCtrl.NOT.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO checkingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            checkingAtomReqBO.setAuthCtrl(reqBO.getAuthCtrl());
            checkingAtomReqBO.setMemId(reqBO.getMemId());
            checkingAtomReqBO.setStationId(reqBO.getStationId());
            checkingAtomReqBO.setActionCode(reqBO.getActionCode());
            PebOperationPermissionsCheckingAtomRspBO checkingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(checkingAtomReqBO);
            if (!"0000".equals(checkingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("102029", "\u6743\u9650\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
        }
        OrdSalePO updatePo = new OrdSalePO();
        if (reqBO.getConfirmFlag().equals(CONFIRM)) {
            this.saveAdjustPrice(reqBO);
            this.saveAccessory(reqBO);
            this.audit(reqBO);
            updatePo.setSkipPriceType(SKIP_ADJUST_PRICE_TYPE_NO);
        } else {
            updatePo.setSkipPriceType(SKIP_ADJUST_PRICE_TYPE_YES);
        }
        this.run(reqBO);
        updatePo.setOrderId(reqBO.getOrderId());
        updatePo.setSaleVoucherId(reqBO.getSaleVoucherId());
        updatePo.setAdjustPriceOper(reqBO.getUserId() + "");
        updatePo.setAdjustPriceOperName(reqBO.getUsername());
        updatePo.setAdjustPriceTime(new Date());
        this.ordSaleMapper.updateById(updatePo);
        PebOrderAdjustPriceRspBO rspBO = new PebOrderAdjustPriceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(PebOrderAdjustPriceReqBO reqBO) {
        UocCoreBusiOperRecordReqBO uocCoreBusiOperRecordReqBO = new UocCoreBusiOperRecordReqBO();
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(reqBO.getActionCode());
        dictReqBO.setPcode("ACTION_CODE");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if (dictRspBO != null && dictRspBO.getDicDictionarys() != null) {
            String describe = dictRspBO.getDicDictionarys().getDescrip();
            uocCoreBusiOperRecordReqBO.setDealName(describe);
            uocCoreBusiOperRecordReqBO.setDealTypeName(describe);
            uocCoreBusiOperRecordReqBO.setDealDesc(describe);
            uocCoreBusiOperRecordReqBO.setTaskId(describe);
            uocCoreBusiOperRecordReqBO.setTaskName(describe);
            uocCoreBusiOperRecordReqBO.setDealReason(describe);
        }
        uocCoreBusiOperRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.TASK_OPER_RECORD);
        uocCoreBusiOperRecordReqBO.setOrderId(reqBO.getOrderId());
        uocCoreBusiOperRecordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocCoreBusiOperRecordReqBO.setObjId(reqBO.getSaleVoucherId());
        uocCoreBusiOperRecordReqBO.setCreateTime(new Date());
        uocCoreBusiOperRecordReqBO.setDealOperId(String.valueOf(reqBO.getUserId()));
        uocCoreBusiOperRecordReqBO.setDealOperName(reqBO.getUsername());
        uocCoreBusiOperRecordReqBO.setDealDeptId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealDeptName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealPostId(String.valueOf(reqBO.getOrgId()));
        uocCoreBusiOperRecordReqBO.setDealPostName(reqBO.getOrgName());
        uocCoreBusiOperRecordReqBO.setDealCode(reqBO.getActionCode());
        UocCoreBusiOperRecordRspBO busiOperRecord = this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(uocCoreBusiOperRecordReqBO);
        if (!"0000".equals(busiOperRecord.getRespCode())) {
            throw new UocProBusinessException("100001", "\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + busiOperRecord.getRespDesc());
        }
    }

    private void run(PebOrderAdjustPriceReqBO reqBO) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(reqBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(reqBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getMemId()));
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        processRunReqBO.setVariables(map);
        if (reqBO.getConfirmFlag().equals(CONFIRM)) {
            map.put("skipFlag", "0");
        } else {
            map.put("skipFlag", "1");
        }
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102029", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void audit(PebOrderAdjustPriceReqBO reqBO) {
        UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        noTaskAuditCreateReqBO.setProcDefKey("peb_el_adjust_price_audit");
        noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        noTaskAuditCreateReqBO.setCreateOperId(String.valueOf(reqBO.getMemId()));
        noTaskAuditCreateReqBO.setCreateOperName(reqBO.getUsername());
        UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        infoReqBO.setUsername(reqBO.getUsername());
        infoReqBO.setCreateOperId(String.valueOf(reqBO.getMemId()));
        infoReqBO.setRemark("\u8ba2\u5355\u8c03\u4ef7\u6838\u5b9e\u53d1\u8d77\u5ba1\u6279");
        infoReqBO.setOrderId(reqBO.getOrderId());
        infoReqBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB008);
        infoReqBO.setObjNum("1");
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB008);
        approvalObjBO.setObjId(String.valueOf(reqBO.getSaleVoucherId()));
        ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
        objBOS.add(approvalObjBO);
        infoReqBO.setApprovalObjInfo(objBOS);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
        infoReqBOS.add(infoReqBO);
        noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new UocProBusinessException("102029", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setTbOrderId(uacNoTaskAuditCreateRspBO.getStepId());
        this.ordSaleMapper.updateById(ordSalePO);
    }

    private void saveAdjustPrice(PebOrderAdjustPriceReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        OrdSaleMtLogPO ordSaleMtLogPO = new OrdSaleMtLogPO();
        BeanUtils.copyProperties((Object)salePO, (Object)ordSaleMtLogPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        ArrayList<OrdItemWtLogPO> list = new ArrayList<OrdItemWtLogPO>(reqBO.getOrderItemAdjustList().size());
        Long saleFee = 0L;
        Long purFee = 0L;
        Long adjustSaleFee = 0L;
        Long adjustPurFee = 0L;
        block2: for (PebOrderItemAdjustBO adjustBO : reqBO.getOrderItemAdjustList()) {
            for (OrdItemPO itemPO : itemPOS) {
                if (!itemPO.getOrdItemId().equals(adjustBO.getSaleOrderItemId())) continue;
                OrdItemWtLogPO po = new OrdItemWtLogPO();
                BeanUtils.copyProperties((Object)itemPO, (Object)po);
                try {
                    po.setId(Long.valueOf(this.idUtil.nextId()));
                    po.setIsNew(UocConstant.IS_NEW.NEW);
                    po.setSalePrice(itemPO.getSalePrice());
                    po.setPurchasePrice(itemPO.getPurchasePrice());
                    po.setTotalSaleFee(Long.valueOf(new BigDecimal(itemPO.getSalePrice()).multiply(itemPO.getPurchaseCount()).longValue()));
                    po.setTotalPurchaseFee(Long.valueOf(new BigDecimal(itemPO.getPurchasePrice()).multiply(itemPO.getPurchaseCount()).longValue()));
                    po.setMarkUpRate(Double.valueOf(adjustBO.getMarkUpRateNew().doubleValue()));
                    po.setAdjustSalePrice(UocMoneyUtil.bigDecimal2Long((BigDecimal)adjustBO.getSalePriceNew()));
                    po.setAdjustPurchasePrice(UocMoneyUtil.bigDecimal2Long((BigDecimal)adjustBO.getPurchasingPriceNew()));
                    po.setAdjustTotalSaleFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)adjustBO.getSalePriceNew().multiply(itemPO.getPurchaseCount())));
                    po.setAdjustTotalPurchaseFee(UocMoneyUtil.bigDecimal2Long((BigDecimal)adjustBO.getPurchasingPriceNew().multiply(itemPO.getPurchaseCount())));
                    po.setOldAdjustRate(itemPO.getMarkUpRate());
                    po.setNewAdjustRate(Double.valueOf(adjustBO.getMarkUpRateNew().doubleValue()));
                    po.setAdjustTime(new Date());
                    saleFee = saleFee + po.getTotalSaleFee();
                    purFee = purFee + po.getTotalPurchaseFee();
                    adjustSaleFee = adjustSaleFee + po.getAdjustTotalSaleFee();
                    adjustPurFee = adjustPurFee + po.getAdjustTotalPurchaseFee();
                }
                catch (Exception e) {
                    throw new UocProBusinessException("102029", "\u8ba2\u5355\u660e\u7ec6\u8c03\u4ef7\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                }
                list.add(po);
                continue block2;
            }
        }
        ordSaleMtLogPO.setAdjustOper(reqBO.getUserId().toString());
        ordSaleMtLogPO.setAdjustOperName(reqBO.getUsername());
        ordSaleMtLogPO.setAdjustTime(new Date());
        ordSaleMtLogPO.setSaleFee(saleFee);
        ordSaleMtLogPO.setPurchaseFee(purFee);
        ordSaleMtLogPO.setAdjustSaleFee(adjustSaleFee);
        ordSaleMtLogPO.setAdjustPurchaseFee(adjustPurFee);
        ordSaleMtLogPO.setIsNew(UocConstant.IS_NEW.NEW);
        ordSaleMtLogPO.setId(Long.valueOf(this.idUtil.nextId()));
        ordSaleMtLogPO.setPlaAgreementCode(reqBO.getRemark());
        this.ordSaleMtLogMapper.insert(ordSaleMtLogPO);
        this.ordItemWtLogMapper.insertBatch(list);
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        ordExtMapPO.setObjId(reqBO.getOrderId());
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        ordExtMapPO.setFieldCode("adjust_price_time");
        OrdExtMapPO extMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
        String time = reqBO.getAdjustPriceTime() == null ? DateUtils.dateToStrLong((Date)new Date()) : DateUtils.dateToStrLong((Date)reqBO.getAdjustPriceTime());
        if (extMapPO == null) {
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldName("\u8c03\u4ef7\u65f6\u95f4");
            ordExtMapPO.setFieldValue(time);
            this.ordExtMapMapper.insert(ordExtMapPO);
        } else {
            ordExtMapPO.setId(extMapPO.getId());
            ordExtMapPO.setFieldValue(time);
            this.ordExtMapMapper.updateById(ordExtMapPO);
        }
        OrdExtMapPO orRemarkMapPO = new OrdExtMapPO();
        orRemarkMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        orRemarkMapPO.setObjId(reqBO.getOrderId());
        orRemarkMapPO.setOrderId(reqBO.getOrderId());
        orRemarkMapPO.setFieldCode("adjust_price_remark");
        OrdExtMapPO extMapRemarkPO = this.ordExtMapMapper.getModelBy(orRemarkMapPO);
        if (extMapRemarkPO == null) {
            orRemarkMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            orRemarkMapPO.setFieldName("\u8c03\u4ef7\u5907\u6ce8");
            orRemarkMapPO.setFieldValue(reqBO.getRemark());
            this.ordExtMapMapper.insert(orRemarkMapPO);
        } else {
            orRemarkMapPO.setId(extMapRemarkPO.getId());
            orRemarkMapPO.setFieldName("\u8c03\u4ef7\u5907\u6ce8");
            orRemarkMapPO.setFieldValue(reqBO.getRemark());
            this.ordExtMapMapper.updateById(orRemarkMapPO);
        }
    }

    private void saveAccessory(PebOrderAdjustPriceReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryAdjustList())) {
            return;
        }
        Long orderId = reqBO.getOrderId();
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryAdjustList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryAdjustList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.orderGenerateIdUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.TIAO_JIA);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark(reqBO.getActionCode());
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }
}

