/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocPebAbnormalAuditReqBO;
import com.tydic.uoc.common.ability.bo.UocPebAbnormalAuditRspBO;
import com.tydic.uoc.common.ability.bo.UocPebAbnormalBO;
import com.tydic.uoc.common.atom.api.GenerateOrderPaySeqAtomService;
import com.tydic.uoc.common.atom.api.UocCoreArriveRegistAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreatePayOrderAtomService;
import com.tydic.uoc.common.atom.api.UocPebRefundAtomService;
import com.tydic.uoc.common.atom.bo.ArriveInfoBO;
import com.tydic.uoc.common.atom.bo.GenerateOrderPaySeqRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreArriveRegistRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemAtomBO;
import com.tydic.uoc.common.atom.bo.UocOrderPayItemBO;
import com.tydic.uoc.common.atom.bo.UocPebRefundReqBO;
import com.tydic.uoc.common.atom.bo.UocPebRefundRspBO;
import com.tydic.uoc.common.busi.api.PebZoneAbnormalAuditBusiService;
import com.tydic.uoc.dao.OrdAbnormalMapper;
import com.tydic.uoc.dao.OrdInspectionItemMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdShipAbnormalItemMapper;
import com.tydic.uoc.dao.OrdShipAbnormalMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdAbnormalPO;
import com.tydic.uoc.po.OrdInspectionItemPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdShipAbnormalItemPO;
import com.tydic.uoc.po.OrdShipAbnormalPO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebZoneAbnormalAuditBusiServiceImpl
implements PebZoneAbnormalAuditBusiService {
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private OrdAbnormalMapper ordAbnormalMapper;
    @Autowired
    private OrdShipAbnormalMapper ordShipAbnormalMapper;
    @Autowired
    private OrdShipAbnormalItemMapper ordShipAbnormalItemMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocCoreArriveRegistAtomService uocCoreArriveRegistAtomService;
    @Autowired
    private GenerateOrderPaySeqAtomService generateOrderPaySeqAtomService;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private UocPebRefundAtomService uocPebRefundAtomService;
    private Logger log = LoggerFactory.getLogger(PebZoneAbnormalAuditBusiServiceImpl.class);
    @Autowired
    private OrdInspectionItemMapper ordInspectionItemMapper;

    @Override
    public UocPebAbnormalAuditRspBO dealAudit(UocPebAbnormalAuditReqBO reqBO) {
        UocPebAbnormalAuditRspBO rspBO = new UocPebAbnormalAuditRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.validationParam(reqBO);
        if (reqBO.getOperId() == null) {
            reqBO.setOperId(reqBO.getUserId());
        }
        for (UocPebAbnormalBO uocPebAbnormalBO : reqBO.getAbnormalList()) {
            List shipAbnormalPOS;
            OrdAbnormalPO ordAbnormalPO = new OrdAbnormalPO();
            ordAbnormalPO.setOrderId(uocPebAbnormalBO.getOrderId());
            ordAbnormalPO.setAbnormalVoucherId(uocPebAbnormalBO.getAbnormalVoucherId());
            try {
                ordAbnormalPO = this.ordAbnormalMapper.getModelBy(ordAbnormalPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u5f02\u5e38\u8868\u5931\u8d25");
            }
            if (ordAbnormalPO == null) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u5f02\u5e38\u8868\u5355\u4e0d\u5b58\u5728");
            }
            if (reqBO.getFlag().equals("1")) {
                this.dealAudit(reqBO, ordAbnormalPO, uocPebAbnormalBO.getStepId());
                continue;
            }
            OrdShipAbnormalPO shipAbnormalPO = new OrdShipAbnormalPO();
            shipAbnormalPO.setOrderId(uocPebAbnormalBO.getOrderId());
            shipAbnormalPO.setAbnormalVoucherId(uocPebAbnormalBO.getAbnormalVoucherId());
            try {
                shipAbnormalPOS = this.ordShipAbnormalMapper.getList(shipAbnormalPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u5f02\u5e38\u53d1\u8d27\u8868\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty((Collection)shipAbnormalPOS)) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u5f02\u5e38\u53d1\u8d27\u8868\u4e3a\u7a7a");
            }
            this.stateAndNum(shipAbnormalPOS, reqBO, ordAbnormalPO, uocPebAbnormalBO, rspBO);
        }
        return rspBO;
    }

    private void update(UocPebAbnormalAuditReqBO reqBO, OrdAbnormalPO ordAbnormalPO) {
        ordAbnormalPO.setOrderId(ordAbnormalPO.getOrderId());
        ordAbnormalPO.setAbnormalVoucherId(ordAbnormalPO.getAbnormalVoucherId());
        if (reqBO.getFlag().equals("0")) {
            ordAbnormalPO.setAbnormalState(UocConstant.ABNORMAL_STATE.FINISH);
        } else {
            ordAbnormalPO.setDealReason(reqBO.getDealReason());
            ordAbnormalPO.setAbnormalState(UocConstant.ABNORMAL_STATE.REFUSE);
        }
        try {
            this.ordAbnormalMapper.updateById(ordAbnormalPO);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new UocProBusinessException("102045", "\u4fee\u6539\u5f02\u5e38\u5355\u72b6\u6001\u5931\u8d25");
        }
    }

    private void stateAndNum(List<OrdShipAbnormalPO> shipAbnormalPOS, UocPebAbnormalAuditReqBO reqBO, OrdAbnormalPO abnormalPO, UocPebAbnormalBO uocPebAbnormalBO, UocPebAbnormalAuditRspBO rspBO) {
        boolean finish = this.dealAudit(reqBO, abnormalPO, uocPebAbnormalBO.getStepId());
        if (!finish) {
            return;
        }
        ArrayList<UocOrderPayItemAtomBO> uocOrderPayItemList = new ArrayList<UocOrderPayItemAtomBO>();
        HashSet<OrdSaleRspBO> ordsSet = new HashSet<OrdSaleRspBO>();
        for (OrdShipAbnormalPO shipAbnormalPO : shipAbnormalPOS) {
            List itemPOS;
            List abnormalItemPOS;
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderId(uocPebAbnormalBO.getOrderId());
            ordShipPO.setShipVoucherId(shipAbnormalPO.getShipVoucherId());
            try {
                ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25", (Throwable)e);
            }
            if (ordShipPO == null) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff0cid:" + shipAbnormalPO.getSaleVoucherId());
            }
            OrdSaleRspBO ordSaleRspBO = new OrdSaleRspBO();
            ordSaleRspBO.setSaleVoucherId(ordShipPO.getSaleVoucherId());
            ordSaleRspBO.setOrderId(ordShipPO.getOrderId());
            ordsSet.add(ordSaleRspBO);
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setShipVoucherId(shipAbnormalPO.getShipVoucherId());
            ordShipItemPO.setOrderId(uocPebAbnormalBO.getOrderId());
            OrdShipAbnormalItemPO ordShipAbnormalItemPO = new OrdShipAbnormalItemPO();
            ordShipAbnormalItemPO.setAbnormalShipId(shipAbnormalPO.getAbnormalShipId());
            ordShipAbnormalItemPO.setOrderId(uocPebAbnormalBO.getOrderId());
            ordShipAbnormalItemPO.setAbnormalVoucherId(uocPebAbnormalBO.getAbnormalVoucherId());
            try {
                abnormalItemPOS = this.ordShipAbnormalItemMapper.getList(ordShipAbnormalItemPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u5f02\u5e38\u660e\u7ec6\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty((Collection)abnormalItemPOS)) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u5f02\u5e38\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            try {
                itemPOS = this.ordShipItemMapper.getList(ordShipItemPO);
            }
            catch (Exception e) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u62a5\u9519\uff0c\u53d1\u8d27\u5355id:" + shipAbnormalPO.getSaleVoucherId());
            }
            if (CollectionUtils.isEmpty((Collection)itemPOS)) {
                throw new UocProBusinessException("102045", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u53d1\u8d27\u5355id:" + shipAbnormalPO.getSaleVoucherId());
            }
            this.executeArriveRegist(uocOrderPayItemList, ordShipPO, abnormalItemPOS, itemPOS, reqBO);
        }
        ArrayList ids = new ArrayList(ordsSet);
        rspBO.setSaleIds(ids);
        if (abnormalPO.getChangeFee() < 0L) {
            this.pay(abnormalPO, uocOrderPayItemList, reqBO);
        } else if (abnormalPO.getChangeFee() > 0L) {
            this.refund(abnormalPO, uocOrderPayItemList);
        }
    }

    private void pay(OrdAbnormalPO abnormalPO, List<UocOrderPayItemAtomBO> uocOrderPayItemList, UocPebAbnormalAuditReqBO reqBO) {
        GenerateOrderPaySeqRspBO generateOrderPaySeqRspBO = this.generateOrderPaySeqAtomService.generateOrderPaySeq();
        UocCoreCreatePayOrderReqBO payOrderReqBO = new UocCoreCreatePayOrderReqBO();
        payOrderReqBO.setPayVoucherNo(generateOrderPaySeqRspBO.getPayOrderId());
        payOrderReqBO.setPayFee(-abnormalPO.getChangeFee().longValue());
        payOrderReqBO.setTotalFee(-abnormalPO.getChangeFee().longValue());
        payOrderReqBO.setObjId(abnormalPO.getAbnormalVoucherId());
        payOrderReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
        payOrderReqBO.setOrderId(abnormalPO.getOrderId());
        payOrderReqBO.setCreateOperId(String.valueOf(reqBO.getOperId()));
        payOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        payOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        payOrderReqBO.setPayType(Integer.parseInt("0"));
        ArrayList<UocOrderPayItemBO> list = new ArrayList<UocOrderPayItemBO>();
        for (UocOrderPayItemAtomBO uocOrderPayItemBO : uocOrderPayItemList) {
            UocOrderPayItemBO itemBO = new UocOrderPayItemBO();
            BeanUtils.copyProperties((Object)uocOrderPayItemBO, (Object)itemBO);
            list.add(itemBO);
        }
        payOrderReqBO.setUocOrderPayItemList(list);
        UocCoreCreatePayOrderRspBO rspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(payOrderReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new UocProBusinessException("102045", "\u521b\u5efa\u652f\u4ed8\u5355\u5931\u8d25");
        }
    }

    private void refund(OrdAbnormalPO abnormalPO, List<UocOrderPayItemAtomBO> uocOrderPayItemList) {
        UocPebRefundReqBO refundReqBO = new UocPebRefundReqBO();
        refundReqBO.setIsNeedOutBackPay(PecConstant.IS_NEED_OUT_BACKPAY_YES);
        refundReqBO.setSource(PecConstant.ORDER_SOURCE.ELEC_AREA);
        refundReqBO.setOrderId(abnormalPO.getOrderId());
        refundReqBO.setObjId(abnormalPO.getAbnormalVoucherId());
        refundReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
        refundReqBO.setPayItemBOList(uocOrderPayItemList);
        refundReqBO.setFee(abnormalPO.getChangeFee());
        UocPebRefundRspBO refundRspBO = this.uocPebRefundAtomService.dealUocPebRefund(refundReqBO);
        if (!"0000".equals(refundRspBO.getRespCode())) {
            throw new UocProBusinessException("102045", "\u9000\u6b3e\u5931\u8d25");
        }
    }

    private void buildCreatePayOrderItemParme(Long itemId, OrdShipAbnormalItemPO abnormalItemPO, List<UocOrderPayItemAtomBO> uocOrderPayItemList) {
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(abnormalItemPO.getOrderId());
        ordItemPO.setOrdItemId(itemId);
        try {
            ordItemPO = this.ordItemMapper.getModelBy(ordItemPO);
        }
        catch (Exception e) {
            throw new UocProBusinessException("102045", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25");
        }
        UocOrderPayItemAtomBO uocOrderPayItemBO = new UocOrderPayItemAtomBO();
        uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjId(abnormalItemPO.getShipItemId());
        uocOrderPayItemBO.setPayObjType(2);
        uocOrderPayItemBO.setPurchaseCount(abnormalItemPO.getChangeCount());
        uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
        uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
        uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
        uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
        uocOrderPayItemBO.setPayCount(abnormalItemPO.getChangeCount());
        uocOrderPayItemBO.setTotalFee(abnormalItemPO.getChangeFee());
        uocOrderPayItemBO.setPayFee(abnormalItemPO.getChangeFee());
        uocOrderPayItemList.add(uocOrderPayItemBO);
    }

    private void executeArriveRegist(List<UocOrderPayItemAtomBO> uocOrderPayItemList, OrdShipPO ordShipPO, List<OrdShipAbnormalItemPO> abnormalItemPOS, List<OrdShipItemPO> itemPOS, UocPebAbnormalAuditReqBO reqBO) {
        ArrayList<ArriveInfoBO> arriveInfoBOList = new ArrayList<ArriveInfoBO>();
        UocCoreArriveRegistReqBO arriveRegistReqBO = new UocCoreArriveRegistReqBO();
        arriveRegistReqBO.setIsAbnormal(true);
        for (OrdShipItemPO itemPO : itemPOS) {
            for (OrdShipAbnormalItemPO shipAbnormalItemPO : abnormalItemPOS) {
                if (!itemPO.getShipItemId().equals(shipAbnormalItemPO.getShipItemId())) continue;
                this.buildCreatePayOrderItemParme(itemPO.getOrdItemId(), shipAbnormalItemPO, uocOrderPayItemList);
                ArriveInfoBO arriveInfoBO = new ArriveInfoBO();
                arriveInfoBO.setShipItemId(shipAbnormalItemPO.getShipItemId());
                arriveInfoBO.setRejectCount(shipAbnormalItemPO.getChangeCount());
                arriveInfoBOList.add(arriveInfoBO);
                OrdInspectionItemPO ordInspectionItemPO = new OrdInspectionItemPO();
                ordInspectionItemPO.setInspectionItemId(shipAbnormalItemPO.getInspectionItemId());
                ordInspectionItemPO.setOrderId(shipAbnormalItemPO.getOrderId());
                ordInspectionItemPO.setAlreadyReturnCount(shipAbnormalItemPO.getChangeCount().negate());
                this.ordInspectionItemMapper.updateCounts(ordInspectionItemPO);
            }
        }
        arriveRegistReqBO.setShipVoucherId(ordShipPO.getShipVoucherId());
        arriveRegistReqBO.setOrderId(ordShipPO.getOrderId());
        arriveRegistReqBO.setCreateOperId(String.valueOf(reqBO.getOperId()));
        arriveRegistReqBO.setArriveInfoList(arriveInfoBOList);
        arriveRegistReqBO.setCheckFlag(1);
        UocCoreArriveRegistRspBO arriveRegistRspBO = this.uocCoreArriveRegistAtomService.dealCoreArriveRegist(arriveRegistReqBO);
        if (!"0000".equals(arriveRegistRspBO.getRespCode())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
            }
            throw new UocProBusinessException("102045", "\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1,\u8c03\u7528\u5230\u8d27\u767b\u8bb0\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + arriveRegistRspBO.getRespDesc());
        }
    }

    private boolean dealAudit(UocPebAbnormalAuditReqBO reqBO, OrdAbnormalPO abnormalPO, String stepId) {
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        if (StringUtils.isNotBlank((CharSequence)stepId)) {
            uacNoTaskAuditOrderAuditReqBO.setStepId(stepId);
        } else {
            uacNoTaskAuditOrderAuditReqBO.setStepId(abnormalPO.getStepId());
        }
        if (abnormalPO.getStepId() == null) {
            throw new UocProBusinessException("102045", "\u5ba1\u6279\u5df2\u7ed3\u675f");
        }
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(Integer.parseInt(reqBO.getFlag())));
        uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getOperId()));
        uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getUsername());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getDealDesc());
        uacNoTaskAuditOrderAuditReqBO.setObjType(UocConstant.OBJ_TYPE.ABNORMAL);
        ArrayList<Long> objIds = new ArrayList<Long>();
        objIds.add(abnormalPO.getAbnormalVoucherId());
        uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("102045", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
        }
        if (!uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
            abnormalPO.setStepId(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId());
        } else {
            this.update(reqBO, abnormalPO);
        }
        return uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish();
    }

    private void validationParam(UocPebAbnormalAuditReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100002", "\u534f\u8bae\u8ba2\u5355\u5904\u7406\u7533\u8bf7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFlag())) {
            throw new UocProBusinessException("100002", "\u534f\u8bae\u8ba2\u5355\u5904\u7406\u7533\u8bf7\uff08flag\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List abnormalList = reqBO.getAbnormalList();
        if (CollectionUtils.isEmpty((Collection)abnormalList)) {
            throw new UocProBusinessException("100002", "\u534f\u8bae\u8ba2\u5355\u5904\u7406\u7533\u8bf7\u5ba1\u6279\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UocPebAbnormalBO abnormalBO : abnormalList) {
            if (ObjectUtil.isEmpty((Object)abnormalBO.getAbnormalVoucherId())) {
                throw new UocProBusinessException("100002", "abnormalList.abnormalVoucherId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ObjectUtil.isEmpty((Object)abnormalBO.getOrderId())) continue;
            throw new UocProBusinessException("100002", "abnormalList.orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

