/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.busi.api.UocEsQryAfsTabNumberBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsTabNumberReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsTabNumberRspBO;
import com.tydic.uoc.common.busi.impl.UocEsQryOrderListBusiServiceImpl;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryAfsTabNumberBusiService")
public class UocEsQryAfsTabNumberBusiServiceImpl
implements UocEsQryAfsTabNumberBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryOrderListBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryAfsTabNumberBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryAfsTabNumberRspBO getEsQryAfsTabNumber(UocEsQryAfsTabNumberReqBO reqBO) {
        UocEsQryAfsTabNumberRspBO rspBO = new UocEsQryAfsTabNumberRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.countAfsTabNumber(reqBO);
        String endPoint = "/" + this.uocEsConfig.getAfsIndexName() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        try {
            LOGGER.debug("ES\u7edf\u8ba1\u552e\u540e\u5355\u5217\u8868\u9875\u7b7e\u6570\u91cf\u7ed3\u679csql---->" + qryString);
            Request request = new Request("POST", endPoint);
            request.setJsonEntity(qryString);
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("ES\u7edf\u8ba1\u552e\u540e\u5355\u5217\u8868\u9875\u7b7e\u6570\u91cf\u7ed3\u679cresult---->" + result);
            rspBO = this.resovelRetrunData(result, rspBO);
        }
        catch (IOException e) {
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("102043");
            rspBO.setRespDesc("ES\u8c03\u7528\u7edf\u8ba1\u63a5\u53e3\u7edf\u8ba1\u6570\u91cf\u5f02\u5e38!");
        }
        return rspBO;
    }

    private UocEsQryAfsTabNumberRspBO resovelRetrunData(String result, UocEsQryAfsTabNumberRspBO rspBO) {
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7edf\u8ba1\u6210\u529f!");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        rspBO.setTabCounts(total);
        return rspBO;
    }
}

