/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.bo.UocProBaseRspBo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfMemDetailQueryAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfWalletConsumeAbilityService;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryReqBO;
import com.tydic.uoc.busibase.busi.bo.MemDetailQueryRspBO;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductReqBO;
import com.tydic.uoc.busibase.busi.bo.SgOrgAmountDeductRspBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeReqBO;
import com.tydic.uoc.busibase.busi.bo.WalletConsumeRspBO;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSkuInfo;
import com.tydic.uoc.common.busi.api.PebExtUpdatePlanBusiService;
import com.tydic.uoc.common.busi.bo.PebExtUpdatePlanReqBO;
import com.tydic.uoc.common.busi.bo.PebExtUpdatePlanRspBO;
import com.tydic.uoc.common.busi.bo.UocReverseItemBO;
import com.tydic.uoc.common.busi.bo.UocReverseReqBO;
import com.tydic.uoc.common.comb.api.PebReverseCombService;
import com.tydic.uoc.common.comb.bo.PebExtOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdAfterServiceMapper;
import com.tydic.uoc.dao.OrdAsItemMapper;
import com.tydic.uoc.dao.OrdEcpPlanItemMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleCouponMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdAfterServicePO;
import com.tydic.uoc.po.OrdAsItemPO;
import com.tydic.uoc.po.OrdEcpPlanItemPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSaleCouponPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebReverseCombServiceImpl
implements PebReverseCombService {
    private static final Logger log = LoggerFactory.getLogger(PebReverseCombServiceImpl.class);
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdEcpPlanItemMapper ordEcpPlanItemMapper;
    @Autowired
    private PebExtUpdatePlanBusiService pebExtUpdatePlanBusiService;
    @Autowired
    private OrdAsItemMapper ordAsItemMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdAfterServiceMapper ordAfterServiceMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PebIntfWalletConsumeAbilityService pebIntfWalletConsumeAbilityService;
    @Autowired
    private PebIntfMemDetailQueryAbilityService pebIntfMemDetailQueryAbilityService;
    @Autowired
    private OrdSaleCouponMapper ordSaleCouponMapper;
    @Autowired
    private OrdPayMapper ordPayMapper;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;

    @Override
    public UocProBaseRspBo reverse(UocReverseReqBO reqBO) {
        OrdEcpPlanItemPO planItemPO;
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setFieldCode("purType");
        extMapPO.setOrderId(reqBO.getOrderId());
        extMapPO.setObjId(reqBO.getOrderId());
        extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
        extMapPO = this.ordExtMapMapper.getModelBy(extMapPO);
        boolean flag = false;
        if (extMapPO == null || !PebExtConstant.PurchType.PLAN.toString().equals(extMapPO.getFieldCode())) {
            flag = true;
        }
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        UocProBaseRspBo infoBO = new UocProBaseRspBo();
        infoBO.setRespCode("0000");
        infoBO.setRespDesc("\u6210\u529f");
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(itemPO);
        if (((OrdItemPO)list.get(0)).getPlanItemId() == null) {
            flag = true;
            planItemPO = new OrdEcpPlanItemPO();
        } else {
            Long planItemId = ((OrdItemPO)list.get(0)).getPlanItemId();
            planItemPO = this.ordEcpPlanItemMapper.getModelById(planItemId.longValue());
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        if (reqBO.getReturnFee() != null && reqBO.getReturnFee() != 0L) {
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.SALE)) {
            this.dealOrder(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.AFTER_SERVICE)) {
            this.dealAfs(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.ABNORMAL)) {
            this.dealAb(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        if (reqBO.getObjType().equals(UocCoreConstant.OBJ_TYPE.SHIP)) {
            this.dealShip(reqBO, infoBO, list, planItemPO.getPlanId(), flag, stakeholderPO, salePO);
            return infoBO;
        }
        return infoBO;
    }

    private void dealShip(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        OrdShipPO ordShipPO = new OrdShipPO();
        ordShipPO.setOrderId(reqBO.getOrderId());
        ordShipPO.setShipVoucherId(reqBO.getObjId());
        ordShipPO = this.ordShipMapper.getModelBy(ordShipPO);
        OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
        ordShipItemPO.setOrderId(reqBO.getOrderId());
        ordShipItemPO.setShipVoucherId(reqBO.getObjId());
        List ordShipItemPOS = this.ordShipItemMapper.getList(ordShipItemPO);
        long amount = 0L;
        for (OrdShipItemPO shipItemPO : ordShipItemPOS) {
            for (OrdItemPO itemPO : list) {
                if (!shipItemPO.getOrdItemId().equals(itemPO.getOrdItemId())) continue;
                amount += itemPO.getTotalSaleFee().longValue();
            }
        }
        if ("1203".equals(ordShipPO.getShipStatus())) {
            amount *= -1L;
        } else {
            this.returnWallet(salePO.getOrderId(), salePO.getSaleFee());
        }
        if (UocConstant.SALE_ORDER_STATUS.REJECTED_ORDER.equals(salePO.getSaleState())) {
            try {
                OrdPayPO ordPayPO = new OrdPayPO();
                ordPayPO.setInterType(Integer.valueOf(0));
                ordPayPO.setOrderId(salePO.getOrderId());
                ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.UNPAID);
                this.ordPayMapper.updateById(ordPayPO);
                this.syncIdx(salePO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("\u62d2\u6536\u9006\u5411" + amount);
    }

    private void dealAb(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        PebExtUpdatePlanReqBO updatePlanReqBO = new PebExtUpdatePlanReqBO();
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        updatePlanReqBO.setPlanId(planId);
        updatePlanReqBO.setSaleOrderItemList(saleOrderItemList);
        long price = 0L;
        for (UocReverseItemBO reverseItemBO : reqBO.getItemBOS()) {
            for (OrdItemPO ordItemPO : list) {
                if (!ordItemPO.getOrdItemId().equals(reverseItemBO.getOrdItemId())) continue;
                PebExtThirdSupplierSkuInfo skuInfo = new PebExtThirdSupplierSkuInfo();
                skuInfo.setPurchaseCount(reverseItemBO.getCount());
                skuInfo.setPlanItemId(ordItemPO.getPlanItemId());
                skuInfo.setSkuSalePrice(new BigDecimal(ordItemPO.getSalePrice()));
                price += skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount()).longValue();
                saleOrderItemList.add(skuInfo);
            }
        }
        this.editOrgAmount(Long.valueOf(stakeholderPO.getPurNo()), price, salePO.getOrderId());
        if (!flag) {
            return;
        }
        PebExtUpdatePlanRspBO rspBO = this.pebExtUpdatePlanBusiService.dealReverse(updatePlanReqBO);
        BeanUtils.copyProperties((Object)((Object)rspBO), (Object)infoBO);
    }

    private void syncIdx(OrdSalePO salePO) {
        PebExtOrdIdxSyncReqBO reqBO = new PebExtOrdIdxSyncReqBO();
        reqBO.setObjId(salePO.getSaleVoucherId());
        reqBO.setOrderId(salePO.getOrderId());
        reqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        reqBO.setIsStatistics(false);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)((Object)reqBO))));
    }

    private void dealAfs(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        OrdAfterServicePO servicePO = new OrdAfterServicePO();
        servicePO.setAfterServId(reqBO.getObjId());
        servicePO.setOrderId(reqBO.getOrderId());
        servicePO = this.ordAfterServiceMapper.getModelBy(servicePO);
        if (!UocConstant.SERV_TYPE.SALES_RETURN.equals(servicePO.getServType())) {
            return;
        }
        OrdAsItemPO asItemPO = new OrdAsItemPO();
        asItemPO.setAfterServId(reqBO.getObjId());
        asItemPO.setOrderId(reqBO.getOrderId());
        asItemPO = this.ordAsItemMapper.getModelBy(asItemPO);
        PebExtUpdatePlanReqBO updatePlanReqBO = new PebExtUpdatePlanReqBO();
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        updatePlanReqBO.setPlanId(planId);
        updatePlanReqBO.setSaleOrderItemList(saleOrderItemList);
        long price = 0L;
        for (OrdItemPO ordItemPO : list) {
            if (!ordItemPO.getOrdItemId().equals(asItemPO.getOrdItemId())) continue;
            PebExtThirdSupplierSkuInfo skuInfo = new PebExtThirdSupplierSkuInfo();
            skuInfo.setPurchaseCount(asItemPO.getReturnCount().negate());
            skuInfo.setPlanItemId(ordItemPO.getPlanItemId());
            skuInfo.setSkuSalePrice(new BigDecimal(ordItemPO.getSalePrice()));
            price += skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount()).longValue();
            saleOrderItemList.add(skuInfo);
            break;
        }
        this.editOrgAmount(Long.valueOf(stakeholderPO.getPurNo()), price, salePO.getOrderId());
        if (!flag) {
            return;
        }
        PebExtUpdatePlanRspBO rspBO = this.pebExtUpdatePlanBusiService.dealReverse(updatePlanReqBO);
        BeanUtils.copyProperties((Object)((Object)rspBO), (Object)infoBO);
    }

    private void dealOrder(UocReverseReqBO reqBO, UocProBaseRspBo infoBO, List<OrdItemPO> list, Long planId, boolean flag, OrdStakeholderPO stakeholderPO, OrdSalePO salePO) {
        this.editOrgAmount(Long.valueOf(stakeholderPO.getPurNo()), salePO.getSaleFee(), salePO.getOrderId());
        this.returnWallet(salePO.getOrderId(), salePO.getSaleFee());
        try {
            OrdPayPO ordPayPO = new OrdPayPO();
            ordPayPO.setInterType(Integer.valueOf(0));
            ordPayPO.setOrderId(salePO.getOrderId());
            ordPayPO.setPayState(UocConstant.PAY_ORDER_STATUS.UNPAID);
            this.ordPayMapper.updateById(ordPayPO);
            this.syncIdx(salePO);
        }
        catch (Exception ordPayPO) {
            // empty catch block
        }
        if (!flag) {
            return;
        }
        PebExtUpdatePlanReqBO updatePlanReqBO = new PebExtUpdatePlanReqBO();
        ArrayList<PebExtThirdSupplierSkuInfo> saleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        for (OrdItemPO ordItemPO : list) {
            PebExtThirdSupplierSkuInfo skuInfo = new PebExtThirdSupplierSkuInfo();
            skuInfo.setPlanItemId(ordItemPO.getPlanItemId());
            skuInfo.setPurchaseCount(ordItemPO.getPurchaseCount());
            skuInfo.setSkuSalePrice(new BigDecimal(ordItemPO.getSalePrice()));
            saleOrderItemList.add(skuInfo);
        }
        updatePlanReqBO.setSaleOrderItemList(saleOrderItemList);
        updatePlanReqBO.setPlanId(planId);
        PebExtUpdatePlanRspBO rspBO = this.pebExtUpdatePlanBusiService.dealReverse(updatePlanReqBO);
        BeanUtils.copyProperties((Object)((Object)rspBO), (Object)infoBO);
    }

    private void editOrgAmount(Long orgId, Long price, Long orderId) {
        SgOrgAmountDeductReqBO sgOrgAmountDeductReqBO = new SgOrgAmountDeductReqBO();
        try {
            sgOrgAmountDeductReqBO.setAmount(UocMoneyUtil.long2BigDecimal((Long)price).negate().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        sgOrgAmountDeductReqBO.setOrgId(orgId);
        sgOrgAmountDeductReqBO.setBalanceType(PebExtConstant.BalanceType.ND);
        sgOrgAmountDeductReqBO.setOperType("2");
        log.info("\u5e74\u5ea6\u4f59\u989d\u6263\u51cf" + JSON.toJSONString((Object)sgOrgAmountDeductReqBO));
        SgOrgAmountDeductRspBO sgOrgAmountDeductRspBO = this.pebIntfSgOrgAmountDeductAbilityService.editOrgAmount(sgOrgAmountDeductReqBO);
        if (!("2".equals(orderPO.getUserType()) || "1".equals(orderPO.getUserType()) || "0000".equals(sgOrgAmountDeductRspBO.getRespCode()))) {
            throw new UocProBusinessException("103012", sgOrgAmountDeductRspBO.getRespDesc());
        }
    }

    private void returnWallet(Long orderId, Long fee) {
        OrdSaleCouponPO couponPO = new OrdSaleCouponPO();
        couponPO.setOrderId(orderId);
        List list = this.ordSaleCouponMapper.getList(couponPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
        if ("103012".equals(orderPO.getProcState())) {
            return;
        }
        MemDetailQueryReqBO reqBO = new MemDetailQueryReqBO();
        reqBO.setUserIdWeb(Long.valueOf(orderPO.getCreateOperId()));
        MemDetailQueryRspBO memDetailQueryRspBO = this.pebIntfMemDetailQueryAbilityService.memDetailQuery(reqBO);
        if (memDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO() == null) {
            return;
        }
        WalletConsumeReqBO walletConsumeReqBO = new WalletConsumeReqBO();
        try {
            walletConsumeReqBO.setConsumeAmount(UocMoneyUtil.long2BigDecimal((Long)fee).negate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        walletConsumeReqBO.setCheckFlag(Integer.valueOf(0));
        walletConsumeReqBO.setMemId(memDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO().getMemId());
        walletConsumeReqBO.setWalletType(Integer.valueOf(5));
        walletConsumeReqBO.setOrderId(orderId.toString());
        walletConsumeReqBO.setActivityCode(((OrdSaleCouponPO)list.get(0)).getCouponNo());
        WalletConsumeRspBO rspBO = this.pebIntfWalletConsumeAbilityService.walletConsume(walletConsumeReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            log.error("\u53d6\u6d88\u9000\u79ef\u5206\u5931\u8d25");
        }
    }
}

