/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocOrderItemPriceRecordQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderItemPriceRecordQueryBO;
import com.tydic.uoc.common.ability.bo.UocOrderItemPriceRecordQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderItemPriceRecordQueryRspBO;
import com.tydic.uoc.dao.UocOrderItemPriceRecordMapper;
import com.tydic.uoc.po.UocOrderItemPriceRecordPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderItemPriceRecordQueryAbilityService"})
public class UocOrderItemPriceRecordQueryAbilityServiceImpl
implements UocOrderItemPriceRecordQueryAbilityService {
    @Autowired
    private UocOrderItemPriceRecordMapper recordMapper;

    @PostMapping(value={"getPriceRecord"})
    public UocOrderItemPriceRecordQueryRspBO getPriceRecord(@RequestBody UocOrderItemPriceRecordQueryReqBO reqBO) {
        UocOrderItemPriceRecordQueryRspBO rspBO = new UocOrderItemPriceRecordQueryRspBO();
        ArrayList<UocOrderItemPriceRecordQueryBO> recordQueryList = new ArrayList<UocOrderItemPriceRecordQueryBO>();
        this.validateParams(reqBO);
        UocOrderItemPriceRecordPO recordPO = new UocOrderItemPriceRecordPO();
        recordPO.setSkuId(reqBO.getSkuId());
        recordPO.setRecordDateBegin(reqBO.getRecordDateBegin());
        recordPO.setRecordDateEnd(reqBO.getRecordDateEnd());
        List recordList = this.recordMapper.getList(recordPO);
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            for (UocOrderItemPriceRecordPO po : recordList) {
                String jsonPo = JSONObject.toJSONString((Object)po, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                UocOrderItemPriceRecordQueryBO recordQueryBO = (UocOrderItemPriceRecordQueryBO)JSON.parseObject((String)jsonPo, UocOrderItemPriceRecordQueryBO.class);
                recordQueryBO.setLowerPrice(recordQueryBO.getLowerPrice().divide(new BigDecimal(10000)));
                recordQueryBO.setAveragePrice(recordQueryBO.getAveragePrice().divide(new BigDecimal(10000)));
                recordQueryList.add(recordQueryBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRecordQueryList(recordQueryList);
        return rspBO;
    }

    private void validateParams(UocOrderItemPriceRecordQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e2d\u5fc3sku\u6210\u4ea4\u4ef7\u683c\u8bb0\u5f55\u67e5\u8be2API\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSkuId()) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u4e2d\u5fc3sku\u6210\u4ea4\u4ef7\u683c\u8bb0\u5f55\u67e5\u8be2API\u5165\u53c2\u5355\u54c1ID\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getRecordDateBegin()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(2, -1);
            Date recordDateBegin = calendar.getTime();
            reqBO.setRecordDateBegin(recordDateBegin);
        }
        if (null == reqBO.getRecordDateEnd()) {
            reqBO.setRecordDateEnd(new Date());
        }
    }
}

