/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocProDicValueConstants;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.UocProInspectionConfigSaveAbilityService;
import com.tydic.uoc.common.ability.bo.UocProInspectionConfigSaveAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProInspectionConfigSaveAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocProInspectionConfigSaveCommodityReqBo;
import com.tydic.uoc.dao.UocConfInspectionMapper;
import com.tydic.uoc.dao.UocConfInspectionUseMapper;
import com.tydic.uoc.po.UocConfInspectionPo;
import com.tydic.uoc.po.UocConfInspectionUsePo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProInspectionConfigSaveAbilityService"})
public class UocProInspectionConfigSaveAbilityServiceImpl
implements UocProInspectionConfigSaveAbilityService {
    @Autowired
    private UocConfInspectionMapper uocConfInspectionMapper;
    @Autowired
    private UocConfInspectionUseMapper uocConfInspectionUseMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"saveConfig"})
    public UocProInspectionConfigSaveAbilityRspBo saveConfig(@RequestBody UocProInspectionConfigSaveAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        Integer inspectionType = reqBo.getInspectionType();
        this.updateUse(reqBo);
        this.deleteOldData(reqBo);
        if (UocProDicValueConstants.INSPECTION_TYPE_ALL.equals(inspectionType)) {
            this.insertAllInspection(reqBo);
        } else {
            this.insertInspection(reqBo);
        }
        return (UocProInspectionConfigSaveAbilityRspBo)UocProRspBoUtil.success(UocProInspectionConfigSaveAbilityRspBo.class);
    }

    private void insertInspection(UocProInspectionConfigSaveAbilityReqBo reqBo) {
        for (UocProInspectionConfigSaveCommodityReqBo commodityReqBo : reqBo.getCommodityReqBos()) {
            UocConfInspectionPo insertPo = new UocConfInspectionPo();
            BeanUtils.copyProperties((Object)commodityReqBo, (Object)insertPo);
            insertPo.setBusiType(reqBo.getBusiType());
            insertPo.setInspectionType(reqBo.getInspectionType());
            insertPo.setConfigId(Long.valueOf(this.sequence.nextId()));
            insertPo.setOperId(reqBo.getUserId().toString());
            insertPo.setOperName(reqBo.getUsername());
            insertPo.setOperTime(new Date());
            int insert = this.uocConfInspectionMapper.insert(insertPo);
            if (insert != 0) continue;
            throw new UocProBusinessException("104016", "\u63d2\u5165\u6570\u636e\u8fd4\u56de0");
        }
    }

    private void insertAllInspection(UocProInspectionConfigSaveAbilityReqBo reqBo) {
        UocConfInspectionPo allPo = new UocConfInspectionPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)allPo);
        allPo.setConfigId(Long.valueOf(this.sequence.nextId()));
        allPo.setExcessPercent(reqBo.getAllExcessPercent());
        allPo.setOperId(reqBo.getUserId().toString());
        allPo.setOperName(reqBo.getUsername());
        allPo.setOperTime(new Date());
        int insert = this.uocConfInspectionMapper.insert(allPo);
        if (insert == 0) {
            throw new UocProBusinessException("104016", "\u63d2\u5165\u6570\u636e\u8fd4\u56de0");
        }
    }

    private void deleteOldData(UocProInspectionConfigSaveAbilityReqBo reqBo) {
        UocConfInspectionPo deletePo = new UocConfInspectionPo();
        deletePo.setBusiType(reqBo.getBusiType());
        deletePo.setInspectionType(reqBo.getInspectionType());
        int deleteRet = this.uocConfInspectionMapper.deleteByPrimaryCondition(deletePo);
        if (deleteRet == 0) {
            throw new UocProBusinessException("104016", "\u63d2\u5165\u6570\u636e\u8fd4\u56de0");
        }
    }

    private void updateUse(UocProInspectionConfigSaveAbilityReqBo reqBo) {
        UocConfInspectionUsePo updateUsePo = new UocConfInspectionUsePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updateUsePo);
        updateUsePo.setOperId(reqBo.getUserId().toString());
        updateUsePo.setOperName(reqBo.getUsername());
        updateUsePo.setOperTime(new Date());
        this.uocConfInspectionUseMapper.updateByPrimaryKeySelective(updateUsePo);
    }

    private void validateArgs(UocProInspectionConfigSaveAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer busiType = reqBo.getBusiType();
        if (ObjectUtil.isEmpty((Object)busiType)) {
            throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[busiType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UocProDicValueConstants.INSPECTION_BUSI_TYPE_AGE.equals(busiType) && !UocProDicValueConstants.INSPECTION_BUSI_TYPE_NO_AGE.equals(busiType)) {
            throw new UocProBusinessException("104016", "\u65e0\u6548\u5c5e\u6027[busiType](" + busiType + ")");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[userId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUsername())) {
            throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[username]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInspectionType())) {
            throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[inspectionType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer inspectionType = reqBo.getInspectionType();
        if (UocProDicValueConstants.INSPECTION_TYPE_ALL.equals(inspectionType)) {
            if (reqBo.getAllExcessPercent() == null || reqBo.getAllExcessPercent() < 0) {
                throw new UocProBusinessException("104016", "\u5168\u54c1\u7c7b\u65f6[allExcessPercent]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e0");
            }
            if (reqBo.getAllExcessPercent() > 100) {
                throw new UocProBusinessException("104016", "\u5168\u54c1\u7c7b\u65f6[allExcessPercent]\u503c\u4e0d\u80fd\u8d85\u8fc7100");
            }
        } else if (UocProDicValueConstants.INSPECTION_TYPE_COMMODITY.equals(inspectionType)) {
            List commodityReqBos = reqBo.getCommodityReqBos();
            if (ObjectUtil.isEmpty((Object)commodityReqBos)) {
                throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[commodityReqBos]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (UocProInspectionConfigSaveCommodityReqBo commodityReqBo : commodityReqBos) {
                if (commodityReqBo == null) {
                    throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[commodityReqBos]\u5c5e\u6027\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)commodityReqBo.getCommodityName())) {
                    throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[commodityReqBos]\u5c5e\u6027\u4e2d\u5bf9\u8c61\u7684\u5c5e\u6027[commodityName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)commodityReqBo.getCommodityType())) {
                    throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[commodityReqBos]\u5c5e\u6027\u4e2d\u5bf9\u8c61\u7684\u5c5e\u6027[commodityType]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)commodityReqBo.getExcessPercent())) {
                    throw new UocProBusinessException("104016", "\u5165\u53c2\u5bf9\u8c61[commodityReqBos]\u5c5e\u6027\u4e2d\u5bf9\u8c61\u7684\u5c5e\u6027[excessPercent]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (commodityReqBo.getExcessPercent() < 100) continue;
                throw new UocProBusinessException("104016", "ExcessPercent\u4e0d\u80fd\u8d85\u8fc7100");
            }
        } else {
            throw new UocProBusinessException("104016", "\u65e0\u6548\u7684inspectionType\uff08" + inspectionType + "\uff09");
        }
    }
}

