/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.annotation.OrderLogRecord;
import com.tydic.uoc.common.ability.bo.PebExtThirdSupplierSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.atom.api.UocCoreBusiOperRecordAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreBusiOperRecordReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=102)
public class OrderLogRecordAspect {
    private static final Logger log = LoggerFactory.getLogger(OrderLogRecordAspect.class);
    private static final String RESP_CODE = "respCode";
    private static final String RESP_DESC = "respDesc";
    private static final String SALE_VOUCHER_ID = "saleVoucherId";
    private static final String USERNAME = "username";
    private static final String USER_ID = "userId";
    private static final String ORDER_SALE_LIST = "submitOrderSaleItem";
    @Autowired
    private UocCoreBusiOperRecordAtomService uocCoreBusiOperRecordAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Pointcut(value="@annotation(com.tydic.uoc.common.ability.annotation.OrderLogRecord)")
    public void operationLog() {
    }

    @AfterReturning(returning="response", value="operationLog()")
    public void doAfterReturning(JoinPoint joinPoint, Object response) {
        try {
            this.recordLog(joinPoint, response);
        }
        catch (ClassNotFoundException e) {
            log.error("\u8bb0\u5f55\u8ba2\u5355\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public void recordLog(JoinPoint joinPoint, Object response) throws ClassNotFoundException {
        OrderLogRecord record = this.getDescription(joinPoint);
        String description = record.description();
        log.info("\u672c\u6b21\u64cd\u4f5c\u7684\u63cf\u8ff0\u4fe1\u606f\u662f\uff1a{}", (Object)description);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)response));
            log.info("\u8ba2\u5355\u7684\u521b\u5efa\u5b8c\u6210\u7684\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)jsonObject);
            Object[] args = joinPoint.getArgs();
            JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
            String operationName = params.getString(USERNAME);
            String userId = params.getString(USER_ID);
            UocCoreBusiOperRecordReqBO recordReqBO = new UocCoreBusiOperRecordReqBO();
            recordReqBO.setDealOperName(operationName);
            recordReqBO.setDealOperId(userId);
            recordReqBO.setDealDesc(description + jsonObject.getString(RESP_DESC));
            if ("\u65b0\u589e".equals(description)) {
                if (null != jsonObject.getString(ORDER_SALE_LIST)) {
                    List saleItemList = JSONArray.parseArray((String)jsonObject.getString(ORDER_SALE_LIST), PebExtThirdSupplierSubmitOrderSaleItemRspBO.class);
                    saleItemList.forEach(saleItem -> {
                        recordReqBO.setOrderId(saleItem.getOrderId());
                        recordReqBO.setOrderNo(saleItem.getSaleOrderCode());
                        this.buildOrderLog(recordReqBO);
                    });
                } else {
                    this.buildOrderLog(recordReqBO);
                }
            } else {
                Long saleVoucherId = params.getLong(SALE_VOUCHER_ID);
                OrdSalePO orderSale = this.getOrdSale(saleVoucherId);
                recordReqBO.setOrderId(orderSale.getOrderId());
                recordReqBO.setOrderNo(orderSale.getSaleVoucherNo());
                this.buildOrderLog(recordReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }

    private OrdSalePO getOrdSale(Long saleVoucherId) {
        OrdSalePO orderSale = this.ordSaleMapper.getModelById(saleVoucherId.longValue());
        if (null == orderSale) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u5355\u8bb0\u5f55");
        }
        return orderSale;
    }

    private void buildOrderLog(UocCoreBusiOperRecordReqBO recordReqBO) {
        recordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        recordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_LOG_RECORD);
        recordReqBO.setCreateTime(new Date());
        this.uocCoreBusiOperRecordAtomService.createBusiOperRecord(recordReqBO);
        log.info("\u8bb0\u5f55\u8ba2\u5355\u65e5\u5fd7\u6210\u529f...");
    }

    public OrderLogRecord getDescription(JoinPoint joinPoint) throws ClassNotFoundException {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        OrderLogRecord annotation = null;
        for (Method method : methods) {
            Class<?>[] clazz;
            if (!method.getName().equals(methodName) || (clazz = method.getParameterTypes()).length != arguments.length) continue;
            if (method.getAnnotation(OrderLogRecord.class) == null) break;
            annotation = method.getAnnotation(OrderLogRecord.class);
            break;
        }
        return annotation;
    }
}

