/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.api.UocPebSendMsgAtomService;
import com.tydic.uoc.common.atom.bo.UocPebSendMsgReqBO;
import com.tydic.uoc.common.atom.bo.UocPebSendMsgRspBO;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.PecRemindLogMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.PecRemindLogPO;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebSendMsgAtomService")
public class UocPebSendMsgAtomServiceImpl
implements UocPebSendMsgAtomService {
    private static final Logger log = LoggerFactory.getLogger(UocPebSendMsgAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private PecRemindLogMapper pecRemindLogMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public UocPebSendMsgRspBO dealSendMsg(UocPebSendMsgReqBO atomReqBO) {
        UocPebSendMsgRspBO rsp = new UocPebSendMsgRspBO();
        this.initParam(atomReqBO);
        String orderKey = "orderCode";
        if (atomReqBO.getTemplateParam() != null && atomReqBO.getTemplateParam().get(orderKey) != null) {
            OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setFieldCode("saleVoucherName");
            ordExtMapPO.setOrderId(atomReqBO.getOrderId());
            try {
                ordExtMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
                if (ordExtMapPO == null) {
                    rsp.setRespCode("101069");
                    rsp.setRespDesc("\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a\u8ba2\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    return rsp;
                }
                atomReqBO.getTemplateParam().put("orderName", ordExtMapPO.getFieldValue());
            }
            catch (Exception e) {
                log.error("\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8ba2\u5355\u540d\u79f0\u5f02\u5e38", (Throwable)e);
                rsp.setRespCode("101069");
                rsp.setRespDesc("\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u8ba2\u5355\u540d\u79f0\u5f02\u5e38");
                return rsp;
            }
        }
        for (String sendType : atomReqBO.getSendTypes()) {
            if ("1".equals(sendType)) {
                Map<String, String> sendFlagMap = this.dicDictionaryService.getValueByCode("SEND_SMS_FLAG");
                if (sendFlagMap != null && sendFlagMap.get("1") != null) {
                    rsp = this.smsSend(atomReqBO);
                } else {
                    rsp.setRespCode("0000");
                }
                rsp.setContactInformation("\u77ed\u4fe1\u6536\u4ef6\u4eba\u4fe1\u606f\uff1a" + atomReqBO.getMobile());
            } else if ("2".equals(sendType)) {
                rsp = this.emailSend(atomReqBO);
                rsp.setContactInformation(rsp.getContactInformation() + ",\u90ae\u4ef6\u6536\u4ef6\u4eba\u4fe1\u606f\uff1a" + atomReqBO.getEmail());
            } else if ("3".equals(sendType)) {
                rsp = this.messageSend(atomReqBO);
                rsp.setContactInformation(rsp.getContactInformation() + "\uff0c\u7ad9\u5185\u4fe1\u6536\u4ef6\u4eba\u4fe1\u606f" + atomReqBO.getReceiveList().toString());
            } else {
                rsp.setRespCode("101069");
                rsp.setRespDesc("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u9001\u7c7b\u578b");
                return rsp;
            }
            if (null == rsp.getSendContext()) continue;
            PecRemindLogPO pecRemindLogPO = new PecRemindLogPO();
            pecRemindLogPO.setTemplateId(atomReqBO.getTemplateId());
            pecRemindLogPO.setSendType(atomReqBO.getSendTypes().toString());
            pecRemindLogPO.setSendStatus(rsp.getRespCode());
            if (null == atomReqBO.getRemindConfigureId()) {
                pecRemindLogPO.setRemindConfigureId(atomReqBO.getTemplateId());
            } else {
                pecRemindLogPO.setRemindConfigureId(atomReqBO.getRemindConfigureId());
            }
            pecRemindLogPO.setContactInformation(rsp.getContactInformation());
            if (rsp.getSendContext() != null && rsp.getSendContext().length() > 500) {
                pecRemindLogPO.setSendContext(rsp.getSendContext().substring(0, 500));
            } else {
                pecRemindLogPO.setSendContext(rsp.getSendContext());
            }
            pecRemindLogPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            pecRemindLogPO.setOrderId(atomReqBO.getOrderId());
            try {
                pecRemindLogPO.setId(Long.valueOf(this.sequence.nextId()));
                this.pecRemindLogMapper.insert(pecRemindLogPO);
            }
            catch (Exception e) {
                log.error("\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5199\u5165\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                rsp.setRespCode("101069");
                rsp.setRespDesc("\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5199\u5165\u65e5\u5fd7\u5f02\u5e38");
                return rsp;
            }
        }
        return rsp;
    }

    private UocPebSendMsgRspBO messageSend(UocPebSendMsgReqBO atomReqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u53d1\u9001\u7ad9\u5185\u4fe1=======start------\u5165\u53c2\uff1a" + JSON.toJSONString((Object)atomReqBO));
        }
        UocPebSendMsgRspBO uocPebSendMsgRspBO = new UocPebSendMsgRspBO();
        if (CollectionUtils.isEmpty(atomReqBO.getReceiveList())) {
            if (this.isDebugEnabled) {
                log.debug("\u53d1\u9001\u7ad9\u5185\u4fe1=======start");
            }
            uocPebSendMsgRspBO.setRespCode("101069");
            uocPebSendMsgRspBO.setRespDesc("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25-\u7ad9\u5185\u4fe1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return uocPebSendMsgRspBO;
        }
        for (Long userAccount : atomReqBO.getReceiveList()) {
            if (userAccount != null) continue;
            if (this.isDebugEnabled) {
                log.debug("\u53d1\u9001\u7ad9\u5185\u4fe1=======start");
            }
            uocPebSendMsgRspBO.setRespCode("101069");
            uocPebSendMsgRspBO.setRespDesc("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25-\u7ad9\u5185\u4fe1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return uocPebSendMsgRspBO;
        }
        String content = "";
        uocPebSendMsgRspBO.setSendContext("\u7ad9\u5185\u4fe1\u53d1\u9001\u5185\u5bb9" + content);
        return uocPebSendMsgRspBO;
    }

    private UocPebSendMsgRspBO emailSend(UocPebSendMsgReqBO atomReqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u53d1\u9001\u90ae\u4ef6=======start");
        }
        UocPebSendMsgRspBO uocPebSendMsgRspBO = new UocPebSendMsgRspBO();
        String email = atomReqBO.getEmail();
        String failContent = "";
        if (StringUtils.isBlank((CharSequence)email)) {
            if (this.isDebugEnabled) {
                log.debug("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uocPebSendMsgRspBO.setRespCode("101069");
            uocPebSendMsgRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u7bb1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return uocPebSendMsgRspBO;
        }
        Long emailTemplateId = atomReqBO.getTemplateId();
        if (emailTemplateId == null) {
            if (this.isDebugEnabled) {
                log.debug("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u4ef6\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uocPebSendMsgRspBO.setRespCode("101069");
            uocPebSendMsgRspBO.setRespDesc("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25-\u90ae\u4ef6\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            return uocPebSendMsgRspBO;
        }
        if (StringUtils.isNotBlank((CharSequence)failContent)) {
            uocPebSendMsgRspBO.setSendContext(failContent);
        } else {
            uocPebSendMsgRspBO.setSendContext("\u90ae\u4ef6\u53d1\u9001\u5185\u5bb9\uff1a" + JSONObject.toJSONString(atomReqBO.getTemplateParam()));
        }
        return uocPebSendMsgRspBO;
    }

    private UocPebSendMsgRspBO smsSend(UocPebSendMsgReqBO atomReqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u53d1\u9001\u624b\u673a\u77ed\u4fe1=======start");
        }
        UocPebSendMsgRspBO uocPebSendMsgRspBO = new UocPebSendMsgRspBO();
        String mobile = atomReqBO.getMobile();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            if (this.isDebugEnabled) {
                log.debug("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uocPebSendMsgRspBO.setRespCode("101069");
            uocPebSendMsgRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return uocPebSendMsgRspBO;
        }
        Long smsTemplateId = atomReqBO.getTemplateId();
        if (smsTemplateId == null) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u77ed\u4fe1\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            uocPebSendMsgRspBO.setRespCode("101069");
            uocPebSendMsgRspBO.setRespDesc("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25-\u77ed\u4fe1\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            return uocPebSendMsgRspBO;
        }
        String content = "";
        uocPebSendMsgRspBO.setSendContext("\u77ed\u4fe1\u53d1\u9001\u5185\u5bb9\uff1a" + content);
        return uocPebSendMsgRspBO;
    }

    private void initParam(UocPebSendMsgReqBO atomReqBO) {
        if (atomReqBO == null) {
            throw new UocProBusinessException("100002", "\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == atomReqBO.getOrderId()) {
            throw new UocProBusinessException("100002", "\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == atomReqBO.getSendTypes() || atomReqBO.getSendTypes().size() <= 0) {
            throw new UocProBusinessException("100002", "\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010SendTypes\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == atomReqBO.getTemplateId()) {
            throw new UocProBusinessException("100002", "\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010TemplateId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

