/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.WatermarkInfoBO;
import com.tydic.uoc.common.ability.api.PebExtInspectionDetailExportAbilityService;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtInspectionDetailExportReqBO;
import com.tydic.uoc.common.ability.bo.PebExtInspectionDetailExportRspBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdInspectionItemRspBO;
import com.tydic.uoc.common.utils.PdfUtil;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtInspectionDetailExportAbilityService"})
public class PebExtInspectionDetailExportAbilityServiceImpl
implements PebExtInspectionDetailExportAbilityService {
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    @Autowired
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    @Autowired
    private UocInspectionDetailsQueryAbilityService uocInspectionDetailsQueryAbilityService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"inspectionDetailExport"})
    public PebExtInspectionDetailExportRspBO inspectionDetailExport(@RequestBody PebExtInspectionDetailExportReqBO reqBO) {
        this.validateParams(reqBO);
        PebExtInspectionDetailExportRspBO rspBO = new PebExtInspectionDetailExportRspBO();
        PebExtMainOrderDetailQueryReqBO mainOrderDetailReqBO = new PebExtMainOrderDetailQueryReqBO();
        mainOrderDetailReqBO.setOrderId(reqBO.getOrderId());
        PebExtMainOrderDetailQueryRspBO mainOrderDetailRspBO = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(mainOrderDetailReqBO);
        if (!"0000".equals(mainOrderDetailRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", mainOrderDetailRspBO.getRespDesc());
        }
        UocInspectionDetailsQueryReqBO inspectionDetailsQueryReqBO = new UocInspectionDetailsQueryReqBO();
        inspectionDetailsQueryReqBO.setOrderId(reqBO.getOrderId());
        inspectionDetailsQueryReqBO.setInspectionVoucherId(reqBO.getInspectionVoucherId());
        inspectionDetailsQueryReqBO.setQueryLevel(UocCoreConstant.QUERY_LEVEL.QUERY_All);
        UocInspectionDetailsQueryRspBO inspectionDetailsQueryRspBO = this.uocInspectionDetailsQueryAbilityService.getUocInspectionDetailsQuery(inspectionDetailsQueryReqBO);
        if (!"0000".equals(inspectionDetailsQueryRspBO.getRespCode())) {
            throw new UocProBusinessException("100001", inspectionDetailsQueryRspBO.getRespDesc());
        }
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        String fileExportUrl = this.createExcelFile(mainOrderDetailRspBO, inspectionDetailsQueryRspBO, reqBO.getPrintType(), ordSalePO, reqBO);
        rspBO.setInspectionDetailsUrl(fileExportUrl);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String createExcelFile(PebExtMainOrderDetailQueryRspBO mainOrderDetailRspBO, UocInspectionDetailsQueryRspBO inspectionDetailsQueryRspBO, Integer printType, OrdSalePO ordSalePO, PebExtInspectionDetailExportReqBO reqBO) {
        String fileExportUrl = "";
        String fileName = "\u5230\u8d27\u9a8c\u6536\u5355.xls";
        byte[] bytes = new byte[]{};
        if (PebExtConstant.PrintType.EXCEL.equals(printType)) {
            bytes = this.generateExcel(mainOrderDetailRspBO, inspectionDetailsQueryRspBO, ordSalePO);
            fileName = "\u5230\u8d27\u9a8c\u6536\u5355.xls";
        } else if (PebExtConstant.PrintType.PDF.equals(printType)) {
            bytes = this.generatePdf(mainOrderDetailRspBO, inspectionDetailsQueryRspBO, ordSalePO, reqBO);
            fileName = "\u5230\u8d27\u9a8c\u6536\u5355.pdf";
        } else {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u6253\u5370\u7c7b\u578b\u65e0\u6548");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileExportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileExportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u65f6\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return fileExportUrl;
    }

    private HSSFCellStyle getStyleInCommon(HSSFWorkbook workbook, short fontHeightInPoints, String fontName, boolean wrapText) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setWrapText(wrapText);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleFont.setFontHeightInPoints(fontHeightInPoints);
        titleFont.setFontName(fontName);
        titleStyle.setFont(titleFont);
        return titleStyle;
    }

    private HSSFCellStyle getDataStyle(HSSFWorkbook workbook) {
        HSSFCellStyle dataSetStyle = workbook.createCellStyle();
        dataSetStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        dataSetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        dataSetStyle.setWrapText(true);
        dataSetStyle.setBorderBottom(BorderStyle.THIN);
        dataSetStyle.setBorderLeft(BorderStyle.THIN);
        dataSetStyle.setBorderRight(BorderStyle.THIN);
        dataSetStyle.setBorderTop(BorderStyle.THIN);
        dataSetStyle.setAlignment(HorizontalAlignment.CENTER);
        dataSetStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont dataSetFont = workbook.createFont();
        dataSetFont.setFontHeightInPoints((short)11);
        dataSetFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        dataSetFont.setFontName("\u5b8b\u4f53");
        dataSetStyle.setFont(dataSetFont);
        return dataSetStyle;
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    private HSSFCellStyle getDataStyle(HSSFWorkbook workbook, boolean wrapText) {
        HSSFCellStyle dataSetStyle = workbook.createCellStyle();
        dataSetStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        dataSetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        dataSetStyle.setWrapText(wrapText);
        dataSetStyle.setBorderBottom(BorderStyle.THIN);
        dataSetStyle.setBorderLeft(BorderStyle.THIN);
        dataSetStyle.setBorderRight(BorderStyle.THIN);
        dataSetStyle.setBorderTop(BorderStyle.THIN);
        dataSetStyle.setAlignment(HorizontalAlignment.CENTER);
        dataSetStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont dataSetFont = workbook.createFont();
        dataSetFont.setFontHeightInPoints((short)11);
        dataSetFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        dataSetFont.setFontName("\u5b8b\u4f53");
        dataSetStyle.setFont(dataSetFont);
        return dataSetStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateExcel(PebExtMainOrderDetailQueryRspBO mainOrderDetailRspBO, UocInspectionDetailsQueryRspBO inspectionDetailsQueryRspBO, OrdSalePO ordSalePO) {
        int length = 11;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle titleStyle = this.getStyleInCommon(workbook, (short)18, "\u5b8b\u4f53", false);
        HSSFCellStyle contentStyle = this.getStyleInCommon(workbook, (short)11, "\u5b8b\u4f53", false);
        HSSFCellStyle dataStyle = this.getDataStyle(workbook, true);
        HSSFSheet sheet = workbook.createSheet();
        sheet.setDefaultColumnWidth(15);
        sheet.setDisplayGridlines(false);
        int initRows = 8 + inspectionDetailsQueryRspBO.getOrdInspectionItemRspBOList().size();
        for (int rowIndex = 0; rowIndex <= initRows; ++rowIndex) {
            HSSFRow titleRow = sheet.createRow(rowIndex);
            titleRow.setHeightInPoints(30.0f);
            for (int columnIndex = 0; columnIndex <= length - 1; ++columnIndex) {
                titleRow.createCell(columnIndex);
            }
        }
        HSSFRow titleRow = sheet.getRow(1);
        HSSFCell titleCell = titleRow.getCell(4);
        titleCell.setCellValue("\u5230\u8d27\u9a8c\u6536\u5355");
        titleCell.setCellStyle(titleStyle);
        HSSFRow orderInfoRow = sheet.getRow(2);
        orderInfoRow = sheet.getRow(3);
        HSSFCell orderInfoCell = orderInfoRow.getCell(0);
        orderInfoCell.setCellValue("\u5382\u5546\u540d\u79f0");
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(1);
        orderInfoCell.setCellStyle(dataStyle);
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 4));
        orderInfoCell.setCellValue(this.convertNullToString(mainOrderDetailRspBO.getOrdStakeholderRspBO().getSupName()));
        orderInfoCell = orderInfoRow.getCell(2);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(3);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(4);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(5);
        orderInfoCell.setCellValue("\u8ba2\u5355\u540d\u79f0\uff1a");
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(6);
        orderInfoCell.setCellStyle(dataStyle);
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 6, 10));
        orderInfoCell.setCellValue(this.convertNullToString(mainOrderDetailRspBO.getOrderRspBO().getOrderName()));
        orderInfoCell = orderInfoRow.getCell(7);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(8);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(9);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(10);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoRow = sheet.getRow(4);
        orderInfoCell = orderInfoRow.getCell(0);
        orderInfoCell.setCellValue("\u9a8c\u6536\u5355\u4f4d");
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(1);
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 4));
        orderInfoCell.setCellValue(this.convertNullToString(mainOrderDetailRspBO.getOrdStakeholderRspBO().getPurAccountName()));
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(2);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(3);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(4);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(5);
        orderInfoCell.setCellValue("\u8ba2\u5355\u7f16\u53f7\uff1a");
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(6);
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 6, 10));
        orderInfoCell.setCellValue(this.convertNullToString(ordSalePO.getSaleVoucherNo()));
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(7);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(8);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(9);
        orderInfoCell.setCellStyle(dataStyle);
        orderInfoCell = orderInfoRow.getCell(10);
        orderInfoCell.setCellStyle(dataStyle);
        String[] headers = new String[]{"\u5e8f\u53f7", "\u7269\u8d44\u540d\u79f0", "\u89c4\u683c\\\u578b\u53f7\\\u56fe\u53f7", "\u91c7\u8d2d\u6570\u91cf", "\u5230\u8d27\u6570\u91cf", "\u9a8c\u6536\u6570\u91cf", "\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)", "\u9a8c\u6536\u91d1\u989d(\u542b\u7a0e)", "\u9a8c\u6536\u72b6\u6001"};
        HSSFRow row = sheet.getRow(5);
        for (int i = 0; i < headers.length; i = (int)((short)(i + 1))) {
            HSSFCell cell = i > 2 ? row.getCell(i + 2) : row.getCell(i);
            cell.setCellStyle(dataStyle);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            if (i == 2) {
                sheet.addMergedRegion(new CellRangeAddress(5, 5, 2, 4));
                cell = row.getCell(3);
                cell.setCellStyle(dataStyle);
                cell = row.getCell(4);
                cell.setCellStyle(dataStyle);
            }
            cell.setCellValue((RichTextString)text);
        }
        int serialNum = 0;
        int index = 5;
        for (UocOrdInspectionItemRspBO item : inspectionDetailsQueryRspBO.getOrdInspectionItemRspBOList()) {
            HSSFCell cell;
            ++serialNum;
            row = sheet.createRow(++index);
            for (int column = 0; column <= length - 1; ++column) {
                cell = row.createCell(column);
                cell.setCellStyle(dataStyle);
                cell.setCellValue(serialNum + "");
            }
            cell = row.getCell(0);
            cell.setCellStyle(dataStyle);
            cell.setCellValue(serialNum + "");
            for (int i = 1; i < headers.length; i = (int)((short)(i + 1))) {
                cell = i > 2 ? row.getCell(i + 2) : row.getCell(i);
                cell.setCellStyle(dataStyle);
                String value = null;
                if (1 == i) {
                    value = item.getSkuMaterialName();
                }
                if (2 == i) {
                    sheet.addMergedRegion(new CellRangeAddress(index, index, 2, 4));
                    value = "\u89c4\u683c\uff1a" + item.getSpec() + "\\\u578b\u53f7\uff1a" + item.getModel() + "\\\u56fe\u53f7\uff1a" + item.getFigure();
                    cell = row.getCell(3);
                    cell.setCellStyle(dataStyle);
                    cell = row.getCell(4);
                    cell.setCellStyle(dataStyle);
                }
                if (3 == i) {
                    value = item.getPurchaseCount() + "";
                }
                if (4 == i) {
                    value = item.getSendCount() + "";
                }
                if (5 == i) {
                    value = item.getInspectionCount() + "";
                }
                if (6 == i) {
                    value = item.getSalePriceMoney() + "";
                }
                if (7 == i) {
                    value = item.getInspSaleMoney() + "";
                }
                if (8 == i) {
                    value = inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspectionStateStr() + "";
                }
                cell.setCellValue(this.convertNullToString(value));
            }
        }
        orderInfoRow = sheet.getRow(index + 1);
        orderInfoCell = orderInfoRow.getCell(9);
        orderInfoCell.setCellValue("\u9a8c\u6536\u91d1\u989d\u5408\u8ba1\uff1a");
        orderInfoCell.setCellStyle(contentStyle);
        orderInfoCell = orderInfoRow.getCell(10);
        orderInfoCell.setCellValue(this.convertNullToString(inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspTotalSaleMoney()));
        orderInfoCell.setCellStyle(contentStyle);
        orderInfoRow = sheet.getRow(index + 2);
        orderInfoCell = orderInfoRow.getCell(0);
        orderInfoCell.setCellValue("\u9a8c\u6536\u65f6\u95f4\uff1a");
        orderInfoCell.setCellStyle(contentStyle);
        orderInfoCell = orderInfoRow.getCell(1);
        orderInfoCell.setCellValue(this.convertNullToString(DateUtils.dateToStr((Date)inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspectionTime())));
        orderInfoCell.setCellStyle(contentStyle);
        orderInfoCell = orderInfoRow.getCell(9);
        orderInfoCell.setCellValue("\u9a8c\u6536\u4eba\uff1a");
        orderInfoCell.setCellStyle(contentStyle);
        orderInfoCell = orderInfoRow.getCell(10);
        orderInfoCell.setCellValue(this.convertNullToString(inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspectionOper()));
        orderInfoCell.setCellStyle(contentStyle);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] generatePdf(PebExtMainOrderDetailQueryRspBO mainOrderDetailRspBO, UocInspectionDetailsQueryRspBO inspectionDetailsQueryRspBO, OrdSalePO ordSalePO, PebExtInspectionDetailExportReqBO reqBO) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519", (Throwable)e);
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 11;
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO);
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u5230\u8d27\u9a8c\u6536\u5355", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(60.0f);
        titleCell.setHorizontalAlignment(1);
        titleCell.setVerticalAlignment(5);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable pdfPTable1 = new PdfPTable(11);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("\u5382\u5546\u540d\u79f0", contentFont));
        pdfPCell1.setFixedHeight(20.0f);
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(mainOrderDetailRspBO.getOrdStakeholderRspBO().getSupName(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(4);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u8ba2\u5355\u540d\u79f0", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(mainOrderDetailRspBO.getOrderRspBO().getOrderName(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(5);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable pdfPTable2 = new PdfPTable(11);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("\u9a8c\u6536\u5355\u4f4d", contentFont));
        pdfPCell2.setFixedHeight(20.0f);
        pdfPCell2.setHorizontalAlignment(2);
        pdfPCell2.setVerticalAlignment(5);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(mainOrderDetailRspBO.getOrdStakeholderRspBO().getPurAccountName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("\u8ba2\u5355\u7f16\u53f7", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(ordSalePO.getSaleVoucherNo(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(5);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add((Element)pdfPTable2);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable headTable = new PdfPTable(11);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setFixedHeight(20.0f);
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u8d44\u540d\u79f0", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u89c4\u683c\\\u578b\u53f7\\\u56fe\u53f7", contentFont));
        headCell.setColspan(3);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u91c7\u8d2d\u6570\u91cf", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5230\u8d27\u6570\u91cf", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9a8c\u6536\u6570\u91cf", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9a8c\u6536\u91d1\u989d(\u542b\u7a0e)", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9a8c\u6536\u72b6\u6001", contentFont));
        headCell.setColspan(1);
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        int count = 1;
        for (UocOrdInspectionItemRspBO item : inspectionDetailsQueryRspBO.getOrdInspectionItemRspBOList()) {
            PdfPTable detailTable = new PdfPTable(11);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setFixedHeight(20.0f);
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(item.getSkuMaterialName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase("\u89c4\u683c\uff1a" + item.getSpec() + "\\\u578b\u53f7\uff1a" + item.getModel() + "\\\u56fe\u53f7\uff1a" + item.getFigure(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(3);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(String.valueOf(item.getPurchaseCount()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(String.valueOf(item.getSendCount()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(String.valueOf(item.getInspectionCount()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(String.valueOf(item.getSalePriceMoney()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(String.valueOf(item.getInspSaleMoney()), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspectionStateStr(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e) {
                throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
            }
        }
        PdfPTable pdfPTable3 = new PdfPTable(11);
        PdfPCell pdfPCell3 = new PdfPCell(new Phrase("\u9a8c\u6536\u91d1\u989d\u5408\u8ba1\uff1a" + inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspTotalSaleMoney(), contentFont));
        pdfPCell3.setHorizontalAlignment(2);
        pdfPCell3.setVerticalAlignment(5);
        pdfPCell3.setColspan(11);
        pdfPTable3.addCell(pdfPCell3);
        try {
            document.add((Element)pdfPTable3);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        PdfPTable pdfPTable4 = new PdfPTable(11);
        PdfPCell pdfPCell4 = new PdfPCell(new Phrase("\u9a8c\u6536\u65f6\u95f4\uff1a" + DateUtils.dateToStr((Date)inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspectionTime()), contentFont));
        pdfPCell4.setHorizontalAlignment(2);
        pdfPCell4.setVerticalAlignment(5);
        pdfPCell4.setColspan(8);
        pdfPTable4.addCell(pdfPCell4);
        String inspectionOperName = inspectionDetailsQueryRspBO.getOrdInspectionRspBO().getInspectionOper();
        if (StringUtils.isEmpty((Object)inspectionOperName)) {
            inspectionOperName = "-";
        }
        pdfPCell4 = new PdfPCell(new Phrase("\u9a8c\u6536\u4eba\uff1a" + inspectionOperName, contentFont));
        pdfPCell4.setHorizontalAlignment(2);
        pdfPCell4.setVerticalAlignment(5);
        pdfPCell4.setColspan(3);
        pdfPTable4.addCell(pdfPCell4);
        try {
            document.add((Element)pdfPTable4);
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519", (Throwable)e);
        }
        document.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void validateParams(PebExtInspectionDetailExportReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId() || 0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInspectionVoucherId() || 0L == reqBO.getInspectionVoucherId()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5355ID\u3010inspectionVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPrintType()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u6253\u5370\u7c7b\u578b\u3010printType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void doAddTextWatermark(PdfWriter pdfWriter, PebExtInspectionDetailExportReqBO reqBO) {
        ArrayList<WatermarkInfoBO> watermarkInfoList = new ArrayList<WatermarkInfoBO>();
        WatermarkInfoBO watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        watermarkInfoBO.setX(300.0f);
        watermarkInfoBO.setY(310.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u4eba\uff1a" + reqBO.getName());
        watermarkInfoBO.setX(320.0f);
        watermarkInfoBO.setY(270.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u7f51\u5740\uff1awww.dicyicai.com");
        watermarkInfoBO.setX(340.0f);
        watermarkInfoBO.setY(230.0f);
        watermarkInfoBO.setRotation(30.0f);
        PdfUtil.addTextWatermark(pdfWriter, watermarkInfoList, 0.5f, 0, BaseColor.GRAY, null, 20.0f);
    }
}

